/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import org.opennms.netmgt.provision.detector.simple.client.LineOrientedClient;

public class DominoIIOPClient
extends LineOrientedClient {
    private int m_iorPort = 1000;

    public void connect(InetAddress host, int port, int timeout) throws IOException, Exception {
        if (!this.preconnect(host, this.getIorPort(), timeout)) {
            throw new Exception("Failed to preconnect");
        }
    }

    private boolean preconnect(InetAddress host, int port, int timeout) throws IOException {
        return this.retrieveIORText(host.getHostAddress(), port, timeout);
    }

    private boolean retrieveIORText(String hostAddress, int port, int timeout) throws IOException {
        String IOR = "";
        URL u = new URL("http://" + hostAddress + ":" + port + "/diiop_ior.txt");
        URLConnection conn = u.openConnection();
        conn.setConnectTimeout(timeout);
        conn.setReadTimeout(timeout);
        InputStream is = conn.getInputStream();
        BufferedReader dis = new BufferedReader(new InputStreamReader(is));
        boolean done = false;
        while (!done) {
            String line = dis.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            if (!(IOR = IOR + line).startsWith("IOR:")) continue;
            done = true;
        }
        dis.close();
        return IOR.startsWith("IOR:");
    }

    public void setIorPort(int iorPort) {
        this.m_iorPort = iorPort;
    }

    public int getIorPort() {
        return this.m_iorPort;
    }
}

