/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple;

import java.nio.charset.Charset;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.opennms.netmgt.provision.detector.simple.AsyncLineOrientedDetector;
import org.opennms.netmgt.provision.detector.simple.response.LineOrientedResponse;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.codec.TcpCodecFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
public class TcpDetector
extends AsyncLineOrientedDetector {
    private static final String DEFAULT_SERVICE_NAME = "TCP";
    private static final int DEFAULT_PORT = 23;
    private String m_banner = null;

    public TcpDetector() {
        super(DEFAULT_SERVICE_NAME, 23);
        this.setProtocolCodecFilter(new ProtocolCodecFilter((ProtocolCodecFactory)new TcpCodecFactory(Charset.forName("UTF-8"))));
    }

    public TcpDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    @Override
    public void onInit() {
        this.expectBanner(this.matches(this.getBanner()));
    }

    public AsyncClientConversation.ResponseValidator<LineOrientedResponse> matches(final String regex) {
        return new AsyncClientConversation.ResponseValidator<LineOrientedResponse>(){

            public boolean validate(LineOrientedResponse response) {
                if (regex == null) {
                    return true;
                }
                return response.matches(regex);
            }
        };
    }

    public void setBanner(String banner) {
        this.m_banner = banner;
    }

    public String getBanner() {
        return this.m_banner;
    }
}

