/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple;

import java.nio.charset.Charset;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.opennms.netmgt.provision.detector.simple.AsyncMultilineDetector;
import org.opennms.netmgt.provision.support.codec.MultilineOrientedCodecFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class FtpDetector
extends AsyncMultilineDetector {
    private static final String DEFAULT_SERVICE_NAME = "FTP";
    private static final int DEFAULT_PORT = 21;
    private String m_multilineIndicator = "-";

    public FtpDetector() {
        super(DEFAULT_SERVICE_NAME, 21);
    }

    public FtpDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    public void onInit() {
        this.setProtocolCodecFilter(new ProtocolCodecFilter((ProtocolCodecFactory)new MultilineOrientedCodecFactory(Charset.forName("UTF-8"), this.getMultilineIndicator())));
        this.expectBanner(this.expectCodeRange(100, 600));
        this.send(this.request("quit"), this.expectCodeRange(100, 600));
    }

    public void setMultilineIndicator(String multilineIndicator) {
        this.m_multilineIndicator = multilineIndicator;
    }

    public String getMultilineIndicator() {
        return this.m_multilineIndicator;
    }
}

