/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.msexchange.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.opennms.netmgt.provision.detector.msexchange.response.MSExchangeResponse;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.support.Client;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSExchangeDetectorClient
implements Client<LineOrientedRequest, MSExchangeResponse> {
    private Integer m_imapPort;
    private Integer m_pop3Port;
    private String m_pop3Response;
    private String m_imapResponse;

    public void close() {
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        this.setImapResponse(this.connectAndGetResponse(address, this.getImapPort(), timeout));
        this.setPop3Response(this.connectAndGetResponse(address, this.getPop3Port(), timeout));
    }

    private String connectAndGetResponse(InetAddress address, Integer port, int timeout) {
        block5: {
            if (port != null) {
                Socket socket = new Socket();
                try {
                    socket.connect(new InetSocketAddress(address, (int)port), timeout);
                    socket.setSoTimeout(timeout);
                    BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    String banner = lineRdr.readLine();
                    socket.close();
                    return banner;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (socket == null) break block5;
                    try {
                        socket.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public MSExchangeResponse receiveBanner() throws IOException, Exception {
        MSExchangeResponse response = new MSExchangeResponse();
        response.setPop3Response(this.getPop3Response());
        response.setImapResponse(this.getImapResponse());
        return response;
    }

    public MSExchangeResponse sendRequest(LineOrientedRequest request) throws IOException, Exception {
        return null;
    }

    public void setImapPort(int imapPort) {
        this.m_imapPort = imapPort;
    }

    public Integer getImapPort() {
        return this.m_imapPort;
    }

    public void setFtpPort(int ftpPort) {
        this.m_pop3Port = ftpPort;
    }

    public Integer getPop3Port() {
        return this.m_pop3Port;
    }

    public void setPop3Port(int pop3Port) {
        this.m_pop3Port = pop3Port;
    }

    public void setImapResponse(String imapResponse) {
        this.m_imapResponse = imapResponse;
    }

    public String getImapResponse() {
        return this.m_imapResponse;
    }

    public void setPop3Response(String pop3Response) {
        this.m_pop3Response = pop3Response;
    }

    public String getPop3Response() {
        return this.m_pop3Response;
    }
}

