/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.qosd.jmx;

import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.openoss.opennms.spring.qosd.jmx.QoSDMBean;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.DefaultLocatorFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class QoSD
extends AbstractServiceDaemon
implements QoSDMBean {
    private static final String NAME = "OpenOSS.QoSD";
    private ClassPathXmlApplicationContext m_context;

    public QoSD() {
        super(NAME);
    }

    ApplicationContext getContext() {
        return this.m_context;
    }

    protected void onInit() {
    }

    protected void onStart() {
        ThreadCategory.getInstance().debug("SPRING: thread.classLoader=" + Thread.currentThread().getContextClassLoader());
        BeanFactoryLocator bfl = DefaultLocatorFactory.getInstance();
        BeanFactoryReference bf = bfl.useBeanFactory("daoContext");
        ApplicationContext daoContext = (ApplicationContext)bf.getFactory();
        String qosdj2ee = System.getProperty("qosd.usej2ee");
        ThreadCategory.getInstance().info("QoSD System Property qosd.usej2ee=" + qosdj2ee);
        if ("true".equals(qosdj2ee)) {
            ThreadCategory.getInstance().debug("QoSD using /org/openoss/opennms/spring/qosd/qosd-j2ee-context.xml");
            this.m_context = new ClassPathXmlApplicationContext(new String[]{"/org/openoss/opennms/spring/qosd/qosd-j2ee-context.xml"}, daoContext);
        } else {
            ThreadCategory.getInstance().debug("QoSD using /org/openoss/opennms/spring/qosd/qosd-spring-context.xml");
            this.m_context = new ClassPathXmlApplicationContext(new String[]{"/org/openoss/opennms/spring/qosd/qosd-spring-context.xml"}, daoContext);
        }
        ThreadCategory.getInstance().debug("SPRING: context.classLoader=" + this.m_context.getClassLoader());
        this.getQoSD().init();
        this.getQoSD().start();
    }

    protected void onStop() {
        this.getQoSD().stop();
        this.m_context.close();
    }

    public String getStats() {
        return this.getQoSD().getStats();
    }

    private org.openoss.opennms.spring.qosd.QoSD getQoSD() {
        org.openoss.opennms.spring.qosd.QoSD qosd = (org.openoss.opennms.spring.qosd.QoSD)this.m_context.getBean("QoSD");
        qosd.setApplicationContext(this.m_context);
        return qosd;
    }
}

