/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.qosd.ejb;

import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.oss.fm.monitor.AlarmKey;
import javax.oss.fm.monitor.AlarmValue;
import javax.oss.fm.monitor.JVTAlarmMonitorHome;
import javax.oss.fm.monitor.JVTAlarmMonitorSession;
import javax.rmi.PortableRemoteObject;
import org.opennms.core.utils.ThreadCategory;
import org.openoss.opennms.spring.qosd.AlarmListConnectionManager;
import org.openoss.opennms.spring.qosd.PropertiesLoader;
import org.openoss.opennms.spring.qosd.QoSDimpl2;
import org.openoss.ossj.fm.monitor.j2ee.AlarmMonitor;
import org.openoss.ossj.jvt.fm.monitor.OOSSAlarmValue;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmListJ2eeConnectionManagerThread
extends Thread
implements AlarmListConnectionManager {
    private int status = 1;
    private PropertiesLoader props;
    public Properties env;
    private JVTAlarmMonitorHome home;
    private JVTAlarmMonitorSession session;
    private Object ref;
    private AlarmMonitor alarmInternals;
    private Hashtable<AlarmKey, AlarmValue> alarmList;
    private int send_status = 1;
    private boolean init = false;
    private String rebuilt_message = "not set";
    ThreadCategory log;
    private ClassPathXmlApplicationContext m_context = null;

    @Override
    public void reset_list(String _rebuilt_message) {
        this.rebuilt_message = _rebuilt_message;
        this.send_status = 2;
        this.interrupt();
    }

    @Override
    public void send(Hashtable<AlarmKey, AlarmValue> alarmList) {
        this.alarmList = alarmList;
        this.send_status = 0;
        this.interrupt();
    }

    @Override
    public void run() throws IllegalStateException {
        if (!this.init) {
            throw new IllegalStateException("AlarmListJ2eeConnectionManagerThread - You must call init() before calling run()");
        }
        while (true) {
            block25: {
                if (this.status == 0 && this.send_status == 0 | this.send_status == 2) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("AlarmListJ2eeConnectionManagerThread.run() Sending alarms");
                    }
                    try {
                        if (this.alarmInternals == null) {
                            this.log.error("AlarmListJ2eeConnectionManagerThread.run() alarmInternals is null");
                        }
                        if (this.send_status == 2) {
                            if (this.alarmInternals == null) {
                                this.log.error("AlarmListJ2eeConnectionManagerThread.run() rebuilt_message is null");
                            }
                            this.alarmInternals.rebuildAlarmList(this.rebuilt_message);
                        } else {
                            if (this.alarmList == null) {
                                this.log.error("AlarmListJ2eeConnectionManagerThread.run() alarmList is null");
                            }
                            this.alarmInternals.updateAlarmList(this.alarmList);
                        }
                        this.send_status = 1;
                    }
                    catch (RemoteException remote_ex) {
                        this.log.error("Could not contact bean - reconnection attempt started");
                        this.status = 1;
                        this.send_status = 0;
                    }
                    catch (NullPointerException np_ex) {
                        this.log.error("alarmInternals is null, JBoss server may be down", (Throwable)np_ex);
                        this.log.info("Attempting reconnect");
                        this.status = 1;
                        this.send_status = 0;
                    }
                }
                if (this.status == 0 && this.send_status == 1) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("AlarmListJ2eeConnectionManagerThread.run() - Polling connection");
                    }
                    try {
                        this.alarmInternals.getVersion();
                    }
                    catch (RemoteException remote_ex) {
                        this.log.error("AlarmListJ2eeConnectionManagerThread.run() Could not contact bean - reconnection attempt started");
                        this.status = 1;
                    }
                }
                if (this.status == 1) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("AlarmListJ2eeConnectionManagerThread.run() Attempting Connecting to bean");
                    }
                    try {
                        this.lookupBean();
                        this.status = 0;
                        this.log.info("AlarmListJ2eeConnectionManagerThread.run() Connected to bean");
                    }
                    catch (NamingException name_ex) {
                        this.status = 1;
                        this.log.error("AlarmListJ2eeConnectionManagerThread.run() NamingException caught, Could not connect to bean", (Throwable)name_ex);
                    }
                    catch (RemoteException remote_ex) {
                        this.log.error("AlarmListJ2eeConnectionManagerThread.run() RemoteException caught, cannot connect to bean", (Throwable)remote_ex);
                        this.status = 1;
                    }
                }
                if (this.status == 2) {
                    this.log.info("AlarmListJ2eeConnectionManagerThread.run() Stopping thread");
                    this.cleanUp();
                    return;
                }
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("AlarmListJ2eeConnectionManagerThread.run() AlarmListJ2eeConnectionManagerThread.run() Going to sleep for 1 minute");
                    }
                    AlarmListJ2eeConnectionManagerThread.sleep(60000L);
                }
                catch (InterruptedException int_ex) {
                    if (!this.log.isDebugEnabled()) break block25;
                    this.log.debug("AlarmListJ2eeConnectionManagerThread.run() Thread interrupted");
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("AlarmListJ2eeConnectionManagerThread.run() Waking up");
            this.log.debug("AlarmListJ2eeConnectionManagerThread.run() Connection State = " + this.status);
            this.log.debug("AlarmListJ2eeConnectionManagerThread.run() send_status = " + this.send_status);
        }
    }

    @Override
    public void init(PropertiesLoader props, Properties env) {
        this.props = props;
        this.env = env;
        this.log = QoSDimpl2.getLog();
        this.init = true;
    }

    @Override
    public void kill() {
        this.status = 2;
        this.interrupt();
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupBean() throws NamingException, RemoteException {
        this.log.info("AlarmListJ2eeConnectionManagerThread.lookupBean() Looking up QoS bean");
        InitialContext ic = new InitialContext(this.env);
        this.log.info("AlarmListJ2eeConnectionManagerThread.lookupBean() InitialContext created");
        try {
            this.ref = ic.lookup(this.props.getProperty("org.openoss.opennms.spring.qosd.jvthome"));
            this.log.info("AlarmListJ2eeConnectionManagerThread.lookupBean() QoS Bean found");
            this.home = (JVTAlarmMonitorHome)PortableRemoteObject.narrow((Object)this.ref, JVTAlarmMonitorHome.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("AlarmListJ2eeConnectionManagerThread.lookupBean() home initialised");
            }
            this.session = this.home.create();
            if (this.log.isDebugEnabled()) {
                this.log.debug("AlarmListJ2eeConnectionManagerThread.lookupBean() Session created");
            }
            this.alarmInternals = (AlarmMonitor)PortableRemoteObject.narrow((Object)this.session.getHandle().getEJBObject(), AlarmMonitor.class);
            if (this.alarmInternals == null) {
                this.log.error("AlarmListJ2eeConnectionManagerThread.lookupBean() AlarmMonitor alarmInternals is null line 244");
            }
        }
        catch (IllegalArgumentException iae_ex) {
            this.log.error("AlarmListJ2eeConnectionManagerThread.lookupBean() jvthome property does not exist", (Throwable)iae_ex);
        }
        catch (CreateException create_ex) {
            this.log.error("AlarmListJ2eeConnectionManagerThread.lookupBean() Cannot create new session", (Throwable)create_ex);
        }
        catch (NullPointerException np_ex) {
            this.log.error("AlarmListJ2eeConnectionManagerThread.lookupBean() NullPointerException caught", (Throwable)np_ex);
        }
        finally {
            ic.close();
        }
        this.log.info("AlarmListJ2eeConnectionManagerThread.lookupBean() New bean session started");
    }

    private void cleanUp() {
        try {
            this.session.remove();
        }
        catch (RemoveException remove_ex) {
            this.log.error("AlarmListJ2eeConnectionManagerThread.lookupBean() Cannot remove session", (Throwable)remove_ex);
        }
        catch (RemoteException remote_ex) {
            this.log.error("AlarmListJ2eeConnectionManagerThread.lookupBean() Connection to bean lost", (Throwable)remote_ex);
        }
    }

    @Override
    public AlarmValue makeAlarmValue() {
        return new OOSSAlarmValue();
    }

    @Override
    public AlarmValue makeAlarmValueFromSpec() {
        AlarmValue alarmValueSpecification = (AlarmValue)this.m_context.getBean("alarmValueSpecification");
        return alarmValueSpecification;
    }

    @Override
    public void setApplicationContext(ClassPathXmlApplicationContext m_context) {
        this.m_context = m_context;
    }
}

