/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.qosd;

import org.opennms.core.utils.ThreadCategory;
import org.openoss.opennms.spring.dao.OssDao;

public class OpenNMSEventHandlerThread
extends Thread {
    private static OssDao ossDao;
    private static boolean sendList;
    private static boolean updateNCache;
    private static boolean runThread;
    private static boolean init;

    public void setOssDao(OssDao _ossDao) {
        ossDao = _ossDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IllegalStateException {
        ThreadCategory log = OpenNMSEventHandlerThread.getLog();
        boolean localupdateNCache = false;
        boolean localsendList = false;
        if (!init) {
            throw new IllegalStateException("OpenNMSEventHandlerThread.run() - You must call init() before calling run()");
        }
        while (runThread) {
            OpenNMSEventHandlerThread openNMSEventHandlerThread = this;
            synchronized (openNMSEventHandlerThread) {
                block17: {
                    try {
                        if (!sendList && !updateNCache) {
                            if (log.isDebugEnabled()) {
                                log.debug("OpenNMSEventHandlerThread.run() thread waiting for interrupt");
                            }
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        if (!log.isDebugEnabled()) break block17;
                        log.debug("OpenNMSEventHandlerThread.run() thread woken up");
                    }
                }
                localupdateNCache = updateNCache;
                localsendList = sendList;
                updateNCache = false;
                sendList = false;
            }
            if (localupdateNCache) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("OpenNMSEventHandlerThread.run() updating node list");
                    }
                    ossDao.updateNodeCaches();
                }
                catch (Exception ex) {
                    log.error("OpenNMSEventHandlerThread.run() Exception caught in ossDao.updateNodeCaches():", (Throwable)ex);
                }
            }
            if (!localsendList) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("OpenNMSEventHandlerThread.run() updating and sending alarm list");
                }
                ossDao.updateAlarmCacheAndSendAlarms();
            }
            catch (Exception ex) {
                log.error("OpenNMSEventHandlerThread.run() Exception caught in ossDao.updateAlarmCacheAndSendAlarms():", (Throwable)ex);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("OpenNMSEventHandlerThread.run() STOPPED");
        }
    }

    public synchronized void init() {
        ThreadCategory log = OpenNMSEventHandlerThread.getLog();
        if (log.isDebugEnabled()) {
            log.debug("OpenNMSEventHandlerThread.init() initialised");
        }
        init = true;
        runThread = true;
    }

    public synchronized void kill() {
        ThreadCategory log = OpenNMSEventHandlerThread.getLog();
        if (log.isDebugEnabled()) {
            log.debug("OpenNMSEventHandlerThread.kill() request received to kill thread");
        }
        runThread = false;
        this.notify();
    }

    public synchronized void sendAlarmList() {
        ThreadCategory log = OpenNMSEventHandlerThread.getLog();
        if (log.isDebugEnabled()) {
            log.debug("OpenNMSEventHandlerThread.sendAlarmList() request received to update alarm list");
        }
        sendList = true;
        this.notify();
    }

    public synchronized void updateNodeCache() {
        ThreadCategory log = OpenNMSEventHandlerThread.getLog();
        if (log.isDebugEnabled()) {
            log.debug("OpenNMSEventHandlerThread.updateNodeCache() request received to update node list");
        }
        updateNCache = true;
        this.notify();
    }

    private static ThreadCategory getLog() {
        return ThreadCategory.getInstance(OpenNMSEventHandlerThread.class);
    }

    static {
        sendList = false;
        updateNCache = false;
        runThread = false;
        init = false;
    }
}

