/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.oss.UnsupportedAttributeException;
import javax.oss.fm.monitor.AlarmKey;
import javax.oss.fm.monitor.AlarmValue;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;
import org.openoss.opennms.spring.dao.OssDao;
import org.openoss.ossj.jvt.fm.monitor.OOSSProbableCause;

public class OnmsAlarmOssjMapper {
    private static Pattern p = Pattern.compile("<[^>]*>");
    private DistPollerDao distPollerDao;
    private AssetRecordDao _assetRecordDao;
    private NodeDao _nodeDao;
    private OssDao ossDao;
    public static int SPECIFY_OUTSTATION = 1;
    public static int USE_TYPE_INSTANCE = 2;
    private static String[] alarmUpdateBehaviourStr = new String[]{"SPECIFY_OUTSTATION", "USE_TYPE_INSTANCE"};

    private static ThreadCategory getLog() {
        return ThreadCategory.getInstance(OnmsAlarmOssjMapper.class);
    }

    public void setDistPollerDao(DistPollerDao _distPollerDao) {
        this.distPollerDao = _distPollerDao;
    }

    public void setAssetRecordDao(AssetRecordDao ar) {
        this._assetRecordDao = ar;
    }

    public void setNodeDao(NodeDao nodedao) {
        this._nodeDao = nodedao;
    }

    public void setOssDao(OssDao _ossDao) {
        this.ossDao = _ossDao;
    }

    private static String getAlarmUpdateBehaviourForInt(Integer aub) {
        try {
            return alarmUpdateBehaviourStr[aub];
        }
        catch (Exception ex) {
            return "getAlarmUpdateBehaviourForInt INVALID_VALUE:" + aub;
        }
    }

    private static Integer getAlarmUpdateBehaviourForString(String _alarmUpdateBehaviour) {
        Integer almUpdateBehaviour = null;
        if (_alarmUpdateBehaviour == null) {
            throw new IllegalArgumentException("getalarmUpdateBehaviourForString: Null value for alarmUpdateBehaviour");
        }
        if (_alarmUpdateBehaviour.equals("USE_TYPE_INSTANCE")) {
            almUpdateBehaviour = USE_TYPE_INSTANCE;
            return almUpdateBehaviour;
        }
        if (_alarmUpdateBehaviour.equals("SPECIFY_OUTSTATION")) {
            almUpdateBehaviour = SPECIFY_OUTSTATION;
            return almUpdateBehaviour;
        }
        throw new IllegalArgumentException("getalarmUpdateBehaviourForString: Unknown value for alarmUpdateBehaviour:" + _alarmUpdateBehaviour);
    }

    public OnmsAlarm populateOnmsAlarmFromOssjAlarm(OnmsAlarm onmsAlarm, AlarmValue alarmValue, Integer almUpdateBehaviour, String defaultUpdateNodeLabel) throws IllegalArgumentException, UnsupportedAttributeException {
        block28: {
            ThreadCategory log = OnmsAlarmOssjMapper.getLog();
            String logheader = "\t\t" + this.getClass().getSimpleName() + "populateOnmsAlarmFromOssjAlarm():";
            try {
                String applicationDN;
                block29: {
                    OnmsSeverity onmsseverity;
                    String ossPrimaryKey = alarmValue.getAlarmKey().getAlarmPrimaryKey();
                    applicationDN = alarmValue.getAlarmKey().getApplicationDN();
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + " - AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN + " alarmRaisedTime: " + alarmValue.getAlarmRaisedTime());
                    }
                    if (applicationDN == null || applicationDN.equals("") || ossPrimaryKey == null || ossPrimaryKey.equals("")) {
                        log.error(logheader + " ApplicatioDN or PrimaryKey not set");
                        break block28;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + ": trying to find existing alarm using getCurrentAlarmForUniqueKey");
                    }
                    if ((onmsAlarm = this.ossDao.getCurrentAlarmForUniqueKey(applicationDN, ossPrimaryKey)) != null) {
                        log.error(logheader + " Alarm Already exists with this Unique ID");
                        break block28;
                    }
                    onmsAlarm = new OnmsAlarm();
                    onmsAlarm.setUei(OnmsAlarmOssjMapper.ossjAlarmTypeToUei(alarmValue.getAlarmType()));
                    onmsAlarm.setX733AlarmType(alarmValue.getAlarmType() == null ? "" : alarmValue.getAlarmType());
                    onmsAlarm.setX733ProbableCause((int)alarmValue.getProbableCause());
                    onmsAlarm.setTTicketState(null);
                    onmsAlarm.setTTicketId("");
                    onmsAlarm.setQosAlarmState("");
                    onmsAlarm.setSuppressedUser("");
                    onmsAlarm.setSuppressedUntil(new Date());
                    onmsAlarm.setSuppressedTime(new Date());
                    try {
                        onmsseverity = OnmsAlarmOssjMapper.ossjSeveritytoOnmsSeverity(alarmValue.getPerceivedSeverity());
                    }
                    catch (IllegalArgumentException iae) {
                        log.error(logheader + " problem setting severity used default:'WARNING'. Exception:" + iae);
                        onmsseverity = OnmsSeverity.WARNING;
                    }
                    onmsAlarm.setSeverity(onmsseverity);
                    OnmsServiceType service = new OnmsServiceType();
                    service.setId(new Integer(-1));
                    onmsAlarm.setServiceType(new OnmsServiceType());
                    onmsAlarm.setReductionKey(":managedObjectInstance:" + alarmValue.getManagedObjectInstance() + ":managedObjectType:" + alarmValue.getManagedObjectClass() + ":ossPrimaryKey:-" + ossPrimaryKey + ":applicationDN:-" + applicationDN);
                    onmsAlarm.setOssPrimaryKey(ossPrimaryKey);
                    onmsAlarm.setOperInstruct(alarmValue.getProposedRepairActions());
                    OnmsNode node = new OnmsNode();
                    node.setId(new Integer(1));
                    onmsAlarm.setNode(node);
                    if (almUpdateBehaviour == null) {
                        log.error(logheader + ": This receiver's alarmUpdateBehaviour is not set: defaulting to update nodeID:1");
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug(logheader + " alarmUpdateBehaviour:" + almUpdateBehaviour + " " + OnmsAlarmOssjMapper.getAlarmUpdateBehaviourForInt(almUpdateBehaviour));
                        }
                        if (almUpdateBehaviour.equals(SPECIFY_OUTSTATION)) {
                            if (log.isDebugEnabled()) {
                                log.debug(logheader + " SPECIFY_OUTSTATION looking for node with nodelabel:" + defaultUpdateNodeLabel);
                            }
                            try {
                                try {
                                    node = this.ossDao.findNodeByLabel(defaultUpdateNodeLabel);
                                }
                                catch (Exception ex) {
                                    log.error(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node " + ex);
                                }
                                if (node != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug(logheader + " alarmUpdateBehaviour.equals(SPECIFY_OUTSTATION):" + "NODE FOUND for this name:" + defaultUpdateNodeLabel + " setting node id to NodeLabel:" + node.getLabel() + " NodeID:" + node.getId());
                                    }
                                    onmsAlarm.setNode(node);
                                    break block29;
                                }
                                log.error(logheader + " alarmUpdateBehaviour.equals(SPECIFY_OUTSTATION):" + "NODE NOT FOUND for this name:" + defaultUpdateNodeLabel + " setting node id to default NodeID: 1");
                                node = new OnmsNode();
                                node.setId(new Integer(1));
                                onmsAlarm.setNode(node);
                            }
                            catch (Exception ex) {
                                log.error(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node for alarm Set to default nodeID:1" + ex);
                            }
                        } else if (almUpdateBehaviour.equals(USE_TYPE_INSTANCE)) {
                            String managedObjectType = alarmValue.getManagedObjectClass();
                            String managedObjectInstance = alarmValue.getManagedObjectInstance();
                            if (log.isDebugEnabled()) {
                                log.debug(logheader + " USE_TYPE_INSTANCE looking for node with managedObjectType:" + managedObjectType + " managedObjectInstance:" + managedObjectInstance);
                            }
                            try {
                                node = this.ossDao.findNodeByInstanceAndType(managedObjectInstance, managedObjectType);
                                if (node != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE):" + "NODE FOUND for this RX Name:" + defaultUpdateNodeLabel + " setting node id to NodeLabel:" + node.getLabel() + " NodeID:" + node.getId());
                                    }
                                    onmsAlarm.setNode(node);
                                    break block29;
                                }
                                log.error(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE):" + "NODE NOT FOUND for this managedObjectType:" + managedObjectType + " managedObjectInstance:" + managedObjectInstance + " setting node id to default NodeID: 1");
                                node = new OnmsNode();
                                node.setId(new Integer(1));
                                onmsAlarm.setNode(node);
                            }
                            catch (Exception ex) {
                                log.error(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node for alarm Set to default nodeID:1" + ex);
                            }
                        } else {
                            log.error(logheader + " Invalid value for alarmUpdateBehaviour:" + almUpdateBehaviour + " " + OnmsAlarmOssjMapper.getAlarmUpdateBehaviourForInt(almUpdateBehaviour) + " defaulting to update nodeID:1");
                        }
                    }
                }
                onmsAlarm.setMouseOverText("");
                onmsAlarm.setManagedObjectType(alarmValue.getManagedObjectClass());
                onmsAlarm.setManagedObjectInstance(alarmValue.getManagedObjectInstance());
                onmsAlarm.setLogMsg(alarmValue.getSpecificProblem());
                onmsAlarm.setIpAddr("localhost");
                onmsAlarm.setId(null);
                onmsAlarm.setFirstEventTime(alarmValue.getAlarmRaisedTime());
                onmsAlarm.setLastEventTime(alarmValue.getAlarmChangedTime());
                onmsAlarm.setDistPoller((OnmsDistPoller)this.distPollerDao.get((Serializable)((Object)"localhost")));
                onmsAlarm.setDescription(alarmValue.getAdditionalText());
                onmsAlarm.setCounter(new Integer(1));
                onmsAlarm.setApplicationDN(applicationDN);
                onmsAlarm.setAlarmType(new Integer(1));
                if (log.isDebugEnabled()) {
                    log.debug(logheader + ": Creating Alarm: ");
                }
            }
            catch (Exception e) {
                log.error(logheader + " Error : ", (Throwable)e);
            }
        }
        return onmsAlarm;
    }

    public AlarmValue populateOssjAlarmFromOpenNMSAlarm(AlarmValue alarmValueSpecification, OnmsAlarm _openNMSalarm) throws IllegalArgumentException, UnsupportedAttributeException {
        String _opinstr;
        String assetAddress2;
        String assetDescription;
        String assetManagedObjectInstance;
        String assetManagedObjectType;
        String managedObjectInstance;
        String managedObjectType;
        String _uei_no_html;
        Matcher matcher;
        boolean isQoSDrxAlarm;
        String logheader;
        ThreadCategory log;
        block54: {
            log = OnmsAlarmOssjMapper.getLog();
            logheader = "\t\t" + this.getClass().getSimpleName() + "populateOssjAlarmFromOpenNMSAlarm():";
            OnmsNode node = null;
            OnmsAssetRecord asset = null;
            isQoSDrxAlarm = false;
            if (log.isDebugEnabled()) {
                log.debug(logheader + ": Populating alarm");
            }
            if (_openNMSalarm.getManagedObjectInstance() != null && _openNMSalarm.getManagedObjectType() != null && !_openNMSalarm.getManagedObjectInstance().equals("") && !_openNMSalarm.getManagedObjectType().equals("")) {
                isQoSDrxAlarm = true;
                if (log.isDebugEnabled()) {
                    log.debug(logheader + ": isQoSDrxAlarm TRUE - because OpenNMS alarm has ManagedObjectInstance and ManagedObjectType");
                }
            } else {
                isQoSDrxAlarm = false;
                if (log.isDebugEnabled()) {
                    log.debug(logheader + ": isQoSDrxAlarm FALSE - because OpenNMS alarm NOT POPULATED ManagedObjectInstance and ManagedObjectType");
                }
            }
            try {
                if (null != _openNMSalarm.getAlarmAckTime() && null != _openNMSalarm.getAlarmAckUser()) {
                    alarmValueSpecification.setAckUserId(_openNMSalarm.getAlarmAckUser());
                    alarmValueSpecification.setAckTime(new Date(_openNMSalarm.getAlarmAckTime().getTime()));
                    alarmValueSpecification.setAlarmAckState(1);
                } else {
                    alarmValueSpecification.setAlarmAckState(2);
                }
                if (_openNMSalarm.getSeverity() == OnmsSeverity.CLEARED) {
                    alarmValueSpecification.setAlarmClearedTime(new Date(_openNMSalarm.getLastEventTime().getTime()));
                } else {
                    alarmValueSpecification.setAlarmClearedTime(null);
                }
                if (null != _openNMSalarm.getFirstEventTime()) {
                    alarmValueSpecification.setAlarmRaisedTime(new Date(_openNMSalarm.getFirstEventTime().getTime()));
                }
                if (null != _openNMSalarm.getLastEventTime()) {
                    alarmValueSpecification.setAlarmChangedTime(new Date(_openNMSalarm.getLastEventTime().getTime()));
                }
            }
            catch (Exception e) {
                log.error(logheader + ": Problem getting ACK time information", (Throwable)e);
            }
            matcher = null;
            _uei_no_html = "NOT_SET";
            try {
                String uei = _openNMSalarm.getUei();
                if (null != uei) {
                    matcher = p.matcher(uei);
                    _uei_no_html = matcher.replaceAll(" ");
                }
                alarmValueSpecification.setAlarmType(_openNMSalarm.getX733AlarmType() == null ? "EquipmentAlarm" : _openNMSalarm.getX733AlarmType());
            }
            catch (Exception e) {
                log.error(logheader + ": Problem getting  X733AlarmType or Uei", (Throwable)e);
            }
            managedObjectType = "NOT_SET";
            managedObjectInstance = "NOT_SET";
            assetManagedObjectType = "NOT_SET";
            assetManagedObjectInstance = "NOT_SET";
            assetDescription = "NOT_SET";
            assetAddress2 = "NOT_SET";
            if (!isQoSDrxAlarm) {
                try {
                    if (_openNMSalarm.getNode() == null) break block54;
                    node = this.ossDao.findNodeByID(_openNMSalarm.getNode().getId());
                    asset = node.getAssetRecord();
                    if (asset != null) {
                        if (asset.getDescription() != null) {
                            assetDescription = asset.getDescription();
                        }
                        if (asset.getAddress2() != null) {
                            assetAddress2 = asset.getAddress2();
                        }
                        if (asset.getManagedObjectInstance() != null) {
                            assetManagedObjectInstance = asset.getManagedObjectInstance();
                        }
                        if (asset.getManagedObjectType() != null) {
                            assetManagedObjectType = asset.getManagedObjectType();
                        }
                    }
                    managedObjectInstance = assetManagedObjectInstance;
                    managedObjectType = assetManagedObjectType;
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + ": isQoSDrxAlarm=FALSE  OpenNMS type and instance not set. Using from Node Asset record: ManagedObjectInstance: " + managedObjectInstance + " ManagedObjectType:" + managedObjectType);
                    }
                }
                catch (Exception ex) {
                    log.error(logheader + ": Problem getting node and asset information", (Throwable)ex);
                }
            } else {
                try {
                    managedObjectInstance = _openNMSalarm.getManagedObjectInstance();
                    managedObjectType = _openNMSalarm.getManagedObjectType();
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + ": isQoSDrxAlarm=TRUE  OpenNMS type and instance set. Using from OnmsAlarm: ManagedObjectInstance: " + managedObjectInstance + " ManagedObjectType:" + managedObjectType);
                    }
                }
                catch (Exception ex) {
                    log.error(logheader + ": Problem managedObjectInstance or managedObjectType", (Throwable)ex);
                }
            }
        }
        alarmValueSpecification.setManagedObjectClass(managedObjectType);
        if (log.isDebugEnabled()) {
            log.debug(logheader + ": _av.setManagedObjectClass set to: " + managedObjectType);
        }
        alarmValueSpecification.setManagedObjectInstance(managedObjectInstance);
        if (log.isDebugEnabled()) {
            log.debug(logheader + ": _av.setManagedObjectInstance set to: " + managedObjectInstance);
        }
        try {
            alarmValueSpecification.setPerceivedSeverity(OnmsAlarmOssjMapper.onmsSeverityToOssjSeverity(_openNMSalarm.getSeverity()));
            alarmValueSpecification.setProbableCause((short)_openNMSalarm.getX733ProbableCause());
        }
        catch (Exception e) {
            log.error(logheader + ": Problem getting severity or probable cause: ", (Throwable)e);
        }
        if (!isQoSDrxAlarm) {
            try {
                String x733ProbableCause;
                _opinstr = _openNMSalarm.getOperInstruct();
                if (null != _opinstr) {
                    matcher = p.matcher(_opinstr);
                    _opinstr = matcher.replaceAll(" ");
                } else {
                    _opinstr = "NOT_SET";
                }
                alarmValueSpecification.setProposedRepairActions(_opinstr);
                String _logmsg = _openNMSalarm.getLogMsg();
                if (null != _logmsg) {
                    matcher = p.matcher(_logmsg);
                    _logmsg = matcher.replaceAll(" ");
                } else {
                    _logmsg = "NOT_SET";
                }
                String _description = _openNMSalarm.getDescription();
                if (null != _description) {
                    matcher = p.matcher(_description);
                    _description = matcher.replaceAll(" ");
                } else {
                    _description = "NOT_SET";
                }
                alarmValueSpecification.setSpecificProblem(_logmsg);
                Integer alarmid = _openNMSalarm.getId();
                Integer counter = _openNMSalarm.getCounter();
                String reductionkey = _openNMSalarm.getReductionKey();
                Integer nodeid = 0;
                String onmsnodelabel = "";
                if (_openNMSalarm.getNode() != null) {
                    nodeid = _openNMSalarm.getNode().getId();
                    onmsnodelabel = _openNMSalarm.getNode().getLabel();
                }
                String ipaddress = _openNMSalarm.getIpAddr();
                String x733AlarmType = _openNMSalarm.getX733AlarmType();
                try {
                    x733ProbableCause = OOSSProbableCause.getStringforEnum((short)((short)_openNMSalarm.getX733ProbableCause()));
                }
                catch (Exception e) {
                    x733ProbableCause = "X733 Probable Cause Incorrectly Defined";
                }
                alarmValueSpecification.setAdditionalText("<alarmid>" + alarmid + "</alarmid>" + "\n            " + "<logmsg>" + _logmsg + "</logmsg>" + "\n            " + "<uei>" + _uei_no_html + "<uei>" + "\n            " + "<x733AlarmType>" + x733AlarmType + "</x733AlarmType>" + "\n            " + "<x733ProbableCause>" + x733ProbableCause + "</x733ProbableCause>" + "\n            " + "<counter>" + counter + "</counter>" + "\n            " + "<reductionkey>" + reductionkey + "</reductionkey>" + "\n            " + "<nodeid>" + nodeid + "</nodeid>" + "\n            " + "<nodelabel>" + onmsnodelabel + "</nodelabel>" + "\n            " + "<ipaddress>" + ipaddress + "</ipaddress>" + "\n            " + "<description>" + _description + "</description>" + "\n            " + "<opinstr>" + _opinstr + "</opinstr>" + "\n            " + "<asset.managedobjectinstance>" + assetManagedObjectInstance + "</asset.managedobjectinstance>" + "\n            " + "<asset.managedobjecttype>" + assetManagedObjectType + "</asset.managedobjecttype>" + "\n            " + "<asset.address2>" + assetAddress2 + "</asset.address2>" + "\n            " + "<asset.description>" + assetDescription + "</asset.description>" + "\n");
            }
            catch (Exception e) {
                log.error(logheader + ": Problem setting description, logmessage or operator instrctions: ", (Throwable)e);
            }
        } else {
            try {
                _opinstr = _openNMSalarm.getOperInstruct();
                if (null == _opinstr) {
                    _opinstr = "NOT_SET";
                }
                alarmValueSpecification.setProposedRepairActions(_opinstr);
                String _logmsg = _openNMSalarm.getLogMsg();
                if (null == _logmsg) {
                    _logmsg = "NOT_SET";
                }
                alarmValueSpecification.setSpecificProblem(_logmsg);
                String _description = _openNMSalarm.getDescription();
                if (null == _description) {
                    _description = "NOT_SET";
                }
                alarmValueSpecification.setAdditionalText(_description);
            }
            catch (Exception e) {
                log.error(logheader + ": Problem setting description, logmessage or operator instrctions: ", (Throwable)e);
            }
        }
        try {
            AlarmKey ak = alarmValueSpecification.getAlarmKey();
            ak.setAlarmPrimaryKey(Integer.toString(_openNMSalarm.getId()));
            ak.setPrimaryKey((Object)ak.getAlarmPrimaryKey());
        }
        catch (Exception e) {
            log.error(logheader + ": Problem setting AlarmKey: ", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug(logheader + ": Alarm Populated");
        }
        return alarmValueSpecification;
    }

    public static OnmsSeverity ossjSeveritytoOnmsSeverity(short ossjseverity) throws IllegalArgumentException {
        OnmsSeverity onmsseverity;
        switch (ossjseverity) {
            case 1: {
                onmsseverity = OnmsSeverity.INDETERMINATE;
                break;
            }
            case 6: {
                onmsseverity = OnmsSeverity.CLEARED;
                break;
            }
            case 5: {
                onmsseverity = OnmsSeverity.WARNING;
                break;
            }
            case 4: {
                onmsseverity = OnmsSeverity.MINOR;
                break;
            }
            case 3: {
                onmsseverity = OnmsSeverity.MAJOR;
                break;
            }
            case 2: {
                onmsseverity = OnmsSeverity.CRITICAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid OSS/J severity value:" + ossjseverity);
            }
        }
        return onmsseverity;
    }

    private static short onmsSeverityToOssjSeverity(OnmsSeverity onmsSeverity) throws IllegalArgumentException {
        short ossjseverity = 0;
        if (onmsSeverity == null) {
            throw new IllegalArgumentException("onmsSeverityToOssjSeverity: onmsSeverity is Null");
        }
        switch (onmsSeverity) {
            case INDETERMINATE: {
                ossjseverity = 1;
                break;
            }
            case CLEARED: {
                ossjseverity = 6;
                break;
            }
            case NORMAL: {
                ossjseverity = 5;
                break;
            }
            case WARNING: {
                ossjseverity = 5;
                break;
            }
            case MINOR: {
                ossjseverity = 4;
                break;
            }
            case MAJOR: {
                ossjseverity = 3;
                break;
            }
            case CRITICAL: {
                ossjseverity = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid OpenNMS severity value:" + onmsSeverity);
            }
        }
        return ossjseverity;
    }

    public static String ossjAlarmTypeToUei(String alarmType) {
        if (alarmType == null) {
            return "uei.openoss.org.alarm/unknown";
        }
        if (alarmType.equals("CommunicationsAlarm")) {
            return "uei.openoss.org.alarm/CommunicationsAlarm";
        }
        if (alarmType.equals("EnvironmentalAlarm")) {
            return "uei.openoss.org.alarm/EnvironmentalAlarm";
        }
        if (alarmType.equals("EquipmentAlarm")) {
            return "uei.openoss.org.alarm/EquipmentAlarm";
        }
        if (alarmType.equals("IntegrityViolation")) {
            return "uei.openoss.org.alarm/IntegrityViolation";
        }
        if (alarmType.equals("OperationalViolation")) {
            return "uei.openoss.org.alarm/OperationalViolation";
        }
        if (alarmType.equals("PhysicalViolation")) {
            return "uei.openoss.org.alarm/PhysicalViolation";
        }
        if (alarmType.equals("ProcessingErrorAlarm")) {
            return "uei.openoss.org.alarm/ProcessingErrorAlarm";
        }
        if (alarmType.equals("QualityOfServiceAlarm")) {
            return "uei.openoss.org.alarm/QualityOfServiceAlarm";
        }
        if (alarmType.equals("SecurityViolation")) {
            return "uei.openoss.org.alarm/SecurityViolation";
        }
        if (alarmType.equals("TimeDomainViolation")) {
            return "uei.openoss.org.alarm/TimeDomainViolation";
        }
        return "uei.openoss.org.alarm/unknown";
    }
}

