/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.IOException;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdGraphConstants;

class RrdFetchCmd
extends RrdToolCmd
implements RrdGraphConstants {
    RrdFetchCmd() {
    }

    String getCmdType() {
        return "fetch";
    }

    Object execute() throws RrdException, IOException {
        String startStr = this.getOptionValue("s", "start", "end-1d");
        String endStr = this.getOptionValue("e", "end", "now");
        long[] timestamps = Util.getTimestamps(startStr, endStr);
        String resolutionStr = this.getOptionValue("r", "resolution", "1");
        long resolution = RrdFetchCmd.parseLong(resolutionStr);
        String[] words = this.getRemainingWords();
        if (words.length != 3) {
            throw new RrdException("Invalid rrdfetch syntax");
        }
        String path = words[1];
        String consolFun = words[2];
        RrdDb rrdDb = RrdFetchCmd.getRrdDbReference(path);
        try {
            FetchRequest fetchRequest = rrdDb.createFetchRequest(consolFun, timestamps[0], timestamps[1], resolution);
            System.out.println(fetchRequest.dump());
            FetchData fetchData = fetchRequest.fetchData();
            RrdFetchCmd.println(fetchData.toString());
            FetchData fetchData2 = fetchData;
            return fetchData2;
        }
        finally {
            RrdFetchCmd.releaseRrdDbReference(rrdDb);
        }
    }
}

