/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.beanwrapper;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.TypeMismatchException;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyNotFoundException;
import org.springframework.binding.expression.ValueCoercionException;

public class BeanWrapperExpression
implements Expression {
    private String expression;
    private ConversionService conversionService;
    static /* synthetic */ Class class$0;

    public BeanWrapperExpression(String expression, ConversionService conversionService) {
        this.expression = expression;
        this.conversionService = conversionService;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BeanWrapperExpression)) {
            return false;
        }
        BeanWrapperExpression other = (BeanWrapperExpression)o;
        return this.expression.equals(other.expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public Object getValue(Object context) throws EvaluationException {
        try {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(context);
            return beanWrapper.getPropertyValue(this.expression);
        }
        catch (NotReadablePropertyException e) {
            throw new PropertyNotFoundException(context.getClass(), this.expression, e);
        }
        catch (BeansException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "A BeansException occurred getting the value for expression '" + this.getExpressionString() + "' on context [" + context.getClass() + "]", e);
        }
    }

    public void setValue(Object context, Object value) {
        try {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(context);
            this.registerConvertersAsPropertyEditors((PropertyEditorRegistry)beanWrapper);
            beanWrapper.setPropertyValue(this.expression, value);
        }
        catch (NotWritablePropertyException e) {
            throw new PropertyNotFoundException(context.getClass(), this.expression, e);
        }
        catch (TypeMismatchException e) {
            throw new ValueCoercionException(context.getClass(), this.expression, value, e.getRequiredType(), e);
        }
        catch (BeansException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "A BeansException occurred setting the value of expression '" + this.getExpressionString() + "' on context [" + context.getClass() + "] to [" + value + "]", e);
        }
    }

    public Class getValueType(Object context) {
        try {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(context);
            return beanWrapper.getPropertyType(this.expression);
        }
        catch (NotReadablePropertyException e) {
            throw new PropertyNotFoundException(context.getClass(), this.expression, e);
        }
        catch (BeansException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "An BeansException occurred getting the value type for expression '" + this.getExpressionString() + "' on context [" + context.getClass() + "]", e);
        }
    }

    public String getExpressionString() {
        return this.expression;
    }

    public String toString() {
        return this.expression;
    }

    protected void registerConvertersAsPropertyEditors(PropertyEditorRegistry registry) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Set converters = this.conversionService.getConversionExecutors(clazz);
        Iterator it = converters.iterator();
        while (it.hasNext()) {
            ConversionExecutor converter = (ConversionExecutor)it.next();
            if (converter.getTargetClass().getName().equals("java.lang.Enum")) continue;
            registry.registerCustomEditor(converter.getTargetClass(), (PropertyEditor)new PropertyEditorConverter(converter));
        }
    }

    private static class PropertyEditorConverter
    extends PropertyEditorSupport {
        private ConversionExecutor converter;

        public PropertyEditorConverter(ConversionExecutor converter) {
            this.converter = converter;
        }

        public void setAsText(String text) throws IllegalArgumentException {
            try {
                Object convertedValue = this.converter.execute(text);
                this.setValue(convertedValue);
            }
            catch (ConversionException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Unable to convert text '" + text + "'");
                iae.initCause(e);
                throw iae;
            }
        }
    }
}

