/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;

public class CollectionToCollection
implements Converter {
    private ConversionService conversionService;
    private ConversionExecutor elementConverter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public CollectionToCollection(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public CollectionToCollection(ConversionExecutor elementConverter) {
        this.elementConverter = elementConverter;
    }

    public Class getSourceClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Class getTargetClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Object convertSourceToTargetClass(Object source, Class targetClass) throws Exception {
        if (source == null) {
            return null;
        }
        Class targetCollectionImpl = this.getCollectionImplClass(targetClass);
        Collection targetCollection = (Collection)targetCollectionImpl.getConstructor(null).newInstance(null);
        ConversionExecutor elementConverter = this.getElementConverter(source, targetClass);
        Collection sourceCollection = (Collection)source;
        Iterator it = sourceCollection.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (elementConverter != null) {
                value = elementConverter.execute(value);
            }
            targetCollection.add(value);
        }
        return targetCollection;
    }

    private Class getCollectionImplClass(Class targetClass) {
        if (targetClass.isInterface()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.util.List");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(targetClass)) {
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("java.util.ArrayList");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz2;
            }
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("java.util.Set");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz3.equals(targetClass)) {
                Class<?> clazz4 = class$4;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$4 = Class.forName("java.util.LinkedHashSet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz4;
            }
            Class<?> clazz5 = class$5;
            if (clazz5 == null) {
                try {
                    clazz5 = class$5 = Class.forName("java.util.SortedSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz5.equals(targetClass)) {
                Class<?> clazz6 = class$6;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$6 = Class.forName("java.util.TreeSet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz6;
            }
            throw new IllegalArgumentException("Unsupported collection interface [" + targetClass.getName() + "]");
        }
        return targetClass;
    }

    private ConversionExecutor getElementConverter(Object source, Class targetClass) {
        Class elementType;
        if (this.elementConverter != null) {
            return this.elementConverter;
        }
        if (JdkVersion.isAtLeastJava15() && (elementType = GenericCollectionTypeResolver.getCollectionType((Class)targetClass)) != null) {
            Class<?> componentType = source.getClass().getComponentType();
            return this.conversionService.getConversionExecutor(componentType, elementType);
        }
        return null;
    }
}

