/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

import org.codehaus.jackson.JsonContext;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.util.CharTypes;

public abstract class JsonReadContext
extends JsonContext {
    protected int _lineNr;
    protected int _columnNr;
    protected String _currentName;

    public JsonReadContext(int type, int lineNr, int colNr) {
        super(type);
        this._type = type;
        this._lineNr = lineNr;
        this._columnNr = colNr;
    }

    public abstract JsonReadContext getParent();

    public final JsonLocation getStartLocation(Object srcRef) {
        long totalChars = -1L;
        return new JsonLocation(srcRef, totalChars, this._lineNr, this._columnNr);
    }

    public final String getCurrentName() {
        return this._currentName;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                sb.append("/");
                break;
            }
            case 1: {
                sb.append('[');
                sb.append(this.getCurrentIndex());
                sb.append(']');
                break;
            }
            case 2: {
                sb.append('{');
                if (this._currentName != null) {
                    sb.append('\"');
                    CharTypes.appendQuoted(sb, this._currentName);
                    sb.append('\"');
                } else {
                    sb.append('?');
                }
                sb.append(']');
            }
        }
        return sb.toString();
    }
}

