/*
 * Decompiled with CFR 0.152.
 */
package edu.bucknell.net.JDHCP;

import edu.bucknell.net.JDHCP.DHCPOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DHCPMessage {
    private byte op;
    private byte htype;
    private byte hlen;
    private byte hops;
    private int xid;
    private short secs;
    private short flags;
    private byte[] ciaddr = new byte[4];
    private byte[] yiaddr = new byte[4];
    private byte[] siaddr = new byte[4];
    private byte[] giaddr = new byte[4];
    private byte[] chaddr = new byte[16];
    private byte[] sname = new byte[64];
    private byte[] file = new byte[128];
    private DHCPOptions optionsList;
    private int gPort;
    private InetAddress destination_IP;
    public static final int CLIENT_PORT = 68;
    public static final int SERVER_PORT = 67;
    public static InetAddress BROADCAST_ADDR;
    public static final int DISCOVER = 1;
    public static final int OFFER = 2;
    public static final int REQUEST = 3;
    public static final int DECLINE = 4;
    public static final int ACK = 5;
    public static final int NAK = 6;
    public static final int RELEASE = 7;
    public static final int INFORM = 8;

    public DHCPMessage() {
        this.Initialize();
        this.destination_IP = BROADCAST_ADDR;
        this.gPort = 67;
    }

    public DHCPMessage(DHCPMessage dHCPMessage) {
        this.Initialize();
        this.destination_IP = BROADCAST_ADDR;
        this.gPort = 67;
        this.op = dHCPMessage.getOp();
        this.htype = dHCPMessage.getHtype();
        this.hlen = dHCPMessage.getHlen();
        this.hops = dHCPMessage.getHops();
        this.xid = dHCPMessage.getXid();
        this.secs = dHCPMessage.getSecs();
        this.flags = dHCPMessage.getFlags();
        this.ciaddr = dHCPMessage.getCiaddr();
        this.yiaddr = dHCPMessage.getYiaddr();
        this.siaddr = dHCPMessage.getSiaddr();
        this.giaddr = dHCPMessage.getGiaddr();
        this.chaddr = dHCPMessage.getChaddr();
        this.sname = dHCPMessage.getSname();
        this.file = dHCPMessage.getFile();
        this.optionsList.internalize(dHCPMessage.getOptions());
    }

    public DHCPMessage(DHCPMessage dHCPMessage, InetAddress inetAddress, int n) {
        this.Initialize();
        this.destination_IP = inetAddress;
        this.gPort = n;
        this.op = dHCPMessage.getOp();
        this.htype = dHCPMessage.getHtype();
        this.hlen = dHCPMessage.getHlen();
        this.hops = dHCPMessage.getHops();
        this.xid = dHCPMessage.getXid();
        this.secs = dHCPMessage.getSecs();
        this.flags = dHCPMessage.getFlags();
        this.ciaddr = dHCPMessage.getCiaddr();
        this.yiaddr = dHCPMessage.getYiaddr();
        this.siaddr = dHCPMessage.getSiaddr();
        this.giaddr = dHCPMessage.getGiaddr();
        this.chaddr = dHCPMessage.getChaddr();
        this.sname = dHCPMessage.getSname();
        this.file = dHCPMessage.getFile();
        this.optionsList.internalize(dHCPMessage.getOptions());
    }

    public DHCPMessage(DHCPMessage dHCPMessage, InetAddress inetAddress) {
        this.Initialize();
        this.destination_IP = inetAddress;
        this.gPort = 67;
        this.op = dHCPMessage.getOp();
        this.htype = dHCPMessage.getHtype();
        this.hlen = dHCPMessage.getHlen();
        this.hops = dHCPMessage.getHops();
        this.xid = dHCPMessage.getXid();
        this.secs = dHCPMessage.getSecs();
        this.flags = dHCPMessage.getFlags();
        this.ciaddr = dHCPMessage.getCiaddr();
        this.yiaddr = dHCPMessage.getYiaddr();
        this.siaddr = dHCPMessage.getSiaddr();
        this.giaddr = dHCPMessage.getGiaddr();
        this.chaddr = dHCPMessage.getChaddr();
        this.sname = dHCPMessage.getSname();
        this.file = dHCPMessage.getFile();
        this.optionsList.internalize(dHCPMessage.getOptions());
    }

    public DHCPMessage(InetAddress inetAddress, int n) {
        this.Initialize();
        this.destination_IP = inetAddress;
        this.gPort = n;
    }

    public DHCPMessage(InetAddress inetAddress) {
        this.Initialize();
        this.destination_IP = inetAddress;
        this.gPort = 67;
    }

    public DHCPMessage(int n) {
        this.Initialize();
        this.destination_IP = BROADCAST_ADDR;
        this.gPort = n;
    }

    public DHCPMessage(byte[] byArray) {
        this.Initialize();
        this.internalize(byArray);
        this.destination_IP = BROADCAST_ADDR;
        this.gPort = 67;
    }

    public DHCPMessage(byte[] byArray, InetAddress inetAddress, int n) {
        this.Initialize();
        this.internalize(byArray);
        this.destination_IP = inetAddress;
        this.gPort = n;
    }

    public DHCPMessage(byte[] byArray, int n) {
        this.Initialize();
        this.internalize(byArray);
        this.destination_IP = BROADCAST_ADDR;
        this.gPort = n;
    }

    public DHCPMessage(byte[] byArray, InetAddress inetAddress) {
        this.Initialize();
        this.internalize(byArray);
        this.destination_IP = inetAddress;
        this.gPort = 67;
    }

    public DHCPMessage(DataInputStream dataInputStream) {
        this.Initialize();
        try {
            this.op = dataInputStream.readByte();
            this.htype = dataInputStream.readByte();
            this.hlen = dataInputStream.readByte();
            this.hops = dataInputStream.readByte();
            this.xid = dataInputStream.readInt();
            this.secs = dataInputStream.readShort();
            this.flags = dataInputStream.readShort();
            dataInputStream.readFully(this.ciaddr, 0, 4);
            dataInputStream.readFully(this.yiaddr, 0, 4);
            dataInputStream.readFully(this.siaddr, 0, 4);
            dataInputStream.readFully(this.giaddr, 0, 4);
            dataInputStream.readFully(this.chaddr, 0, 16);
            dataInputStream.readFully(this.sname, 0, 64);
            dataInputStream.readFully(this.file, 0, 128);
            byte[] byArray = new byte[312];
            dataInputStream.readFully(byArray, 0, 312);
            this.optionsList.internalize(byArray);
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
    }

    private void Initialize() {
        this.optionsList = new DHCPOptions();
    }

    public synchronized byte[] externalize() {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(this.op);
            dataOutputStream.writeByte(this.htype);
            dataOutputStream.writeByte(this.hlen);
            dataOutputStream.writeByte(this.hops);
            dataOutputStream.writeInt(this.xid);
            dataOutputStream.writeShort(this.secs);
            dataOutputStream.writeShort(this.flags);
            dataOutputStream.write(this.ciaddr, 0, 4);
            dataOutputStream.write(this.yiaddr, 0, 4);
            dataOutputStream.write(this.siaddr, 0, 4);
            dataOutputStream.write(this.giaddr, 0, 4);
            dataOutputStream.write(this.chaddr, 0, 16);
            dataOutputStream.write(this.sname, 0, 64);
            dataOutputStream.write(this.file, 0, 128);
            byArray = new byte[312];
            if (this.optionsList == null) {
                this.Initialize();
            }
            byArray = this.optionsList.externalize();
            dataOutputStream.write(byArray, 0, 312);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public synchronized DHCPMessage internalize(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, byArray.length);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            this.op = dataInputStream.readByte();
            this.htype = dataInputStream.readByte();
            this.hlen = dataInputStream.readByte();
            this.hops = dataInputStream.readByte();
            this.xid = dataInputStream.readInt();
            this.secs = dataInputStream.readShort();
            this.flags = dataInputStream.readShort();
            dataInputStream.readFully(this.ciaddr, 0, 4);
            dataInputStream.readFully(this.yiaddr, 0, 4);
            dataInputStream.readFully(this.siaddr, 0, 4);
            dataInputStream.readFully(this.giaddr, 0, 4);
            dataInputStream.readFully(this.chaddr, 0, 16);
            dataInputStream.readFully(this.sname, 0, 64);
            dataInputStream.readFully(this.file, 0, 128);
            byte[] byArray2 = new byte[312];
            dataInputStream.readFully(byArray2, 0, 312);
            if (this.optionsList == null) {
                this.Initialize();
            }
            this.optionsList.internalize(byArray2);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return this;
    }

    public void setOp(byte by) {
        this.op = by;
    }

    public void setHtype(byte by) {
        this.htype = by;
    }

    public void setHlen(byte by) {
        this.hlen = by;
    }

    public void setHops(byte by) {
        this.hops = by;
    }

    public void setXid(int n) {
        this.xid = n;
    }

    public void setSecs(short s) {
        this.secs = s;
    }

    public void setFlags(short s) {
        this.flags = s;
    }

    public void setCiaddr(byte[] byArray) {
        this.ciaddr = byArray;
    }

    public void setYiaddr(byte[] byArray) {
        this.yiaddr = byArray;
    }

    public void setSiaddr(byte[] byArray) {
        this.siaddr = byArray;
    }

    public void setGiaddr(byte[] byArray) {
        this.giaddr = byArray;
    }

    public void setChaddr(byte[] byArray) {
        this.chaddr = byArray;
    }

    public void setSname(byte[] byArray) {
        this.sname = byArray;
    }

    public void setFile(byte[] byArray) {
        this.file = byArray;
    }

    public void setPort(int n) {
        this.gPort = n;
    }

    public void setDestinationHost(String string) {
        try {
            this.destination_IP = InetAddress.getByName(string);
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public byte getOp() {
        return this.op;
    }

    public byte getHtype() {
        return this.htype;
    }

    public byte getHlen() {
        return this.hlen;
    }

    public byte getHops() {
        return this.hops;
    }

    public int getXid() {
        return this.xid;
    }

    public short getSecs() {
        return this.secs;
    }

    public short getFlags() {
        return this.flags;
    }

    public byte[] getCiaddr() {
        return this.ciaddr;
    }

    public byte[] getYiaddr() {
        return this.yiaddr;
    }

    public byte[] getSiaddr() {
        return this.siaddr;
    }

    public byte[] getGiaddr() {
        return this.giaddr;
    }

    public byte[] getChaddr() {
        return this.chaddr;
    }

    public byte[] getSname() {
        return this.sname;
    }

    public byte[] getFile() {
        return this.file;
    }

    public byte[] getOptions() {
        if (this.optionsList == null) {
            this.Initialize();
        }
        return this.optionsList.externalize();
    }

    public int getPort() {
        return this.gPort;
    }

    public String getDestinationAddress() {
        return this.destination_IP.getHostAddress();
    }

    public void setOption(int n, byte[] byArray) {
        this.optionsList.setOption((byte)n, byArray);
    }

    public byte[] getOption(int n) {
        if (this.optionsList == null) {
            this.Initialize();
        }
        return this.optionsList.getOption((byte)n);
    }

    public void removeOption(int n) {
        if (this.optionsList == null) {
            this.Initialize();
        }
        this.optionsList.removeOption((byte)n);
    }

    public boolean IsOptSet(int n) {
        if (this.optionsList == null) {
            this.Initialize();
        }
        return this.optionsList.contains((byte)n);
    }

    public void printMessage() {
        byte[] byArray = this.externalize();
        int n = 0;
        while (n < 100) {
            System.out.print(byArray[n]);
            if (n % 25 == 0 && n != 0) {
                System.out.print("\n");
            } else {
                System.out.print(" ");
            }
            ++n;
        }
        System.out.print("\n");
        if (this.optionsList == null) {
            this.Initialize();
        }
        this.optionsList.printList();
    }

    static {
        block2: {
            BROADCAST_ADDR = null;
            if (BROADCAST_ADDR != null) break block2;
            try {
                BROADCAST_ADDR = InetAddress.getByName("255.255.255.255");
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }
}

