/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.LazySet;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.config.StorageStrategy;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.ExternalValueAttribute;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.StringPropertyAttribute;
import org.springframework.orm.ObjectRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericIndexResourceType
implements OnmsResourceType {
    private static final Pattern SUB_INDEX_PATTERN = Pattern.compile("^subIndex\\((.*)\\)$");
    private static final Pattern SUB_INDEX_ARGUMENTS_PATTERN = Pattern.compile("^(-?\\d+|n)(?:,\\s*(\\d+|n))?$");
    private static final Pattern HEX_PATTERN = Pattern.compile("^hex\\((.*)\\)$");
    private static final Pattern STRING_PATTERN = Pattern.compile("^string\\((.*)\\)$");
    private String m_name;
    private String m_label;
    private String m_resourceLabelExpression;
    private ResourceDao m_resourceDao;
    private StorageStrategy m_storageStrategy;

    public GenericIndexResourceType(ResourceDao resourceDao, String name, String label, String resourceLabelExpression, StorageStrategy storageStrategy) {
        this.m_resourceDao = resourceDao;
        this.m_name = name;
        this.m_label = label;
        this.m_resourceLabelExpression = resourceLabelExpression;
        this.m_storageStrategy = storageStrategy;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLabel() {
        return this.m_label;
    }

    public StorageStrategy getStorageStrategy() {
        return this.m_storageStrategy;
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return this.getResourceTypeDirectory(nodeId, false).isDirectory();
    }

    private File getResourceTypeDirectory(int nodeId, boolean verify) {
        File snmp = new File(this.m_resourceDao.getRrdDirectory(verify), "snmp");
        File node = new File(snmp, Integer.toString(nodeId));
        if (verify && !node.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No node directory exists for node " + nodeId + ": " + node));
        }
        File generic = new File(node, this.getName());
        if (verify && !generic.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No node directory exists for generic index " + this.getName() + ": " + generic));
        }
        return generic;
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        List<String> indexes = this.getQueryableIndexesForNode(nodeId);
        for (String index : indexes) {
            resources.add(this.getResourceByNodeAndIndex(nodeId, index));
        }
        return OnmsResource.sortIntoResourceList(resources);
    }

    public List<String> getQueryableIndexesForNode(int nodeId) {
        File nodeDir = this.getResourceTypeDirectory(nodeId, true);
        LinkedList<String> indexes = new LinkedList<String>();
        File[] indexDirs = nodeDir.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        if (indexDirs == null) {
            return indexes;
        }
        for (File indexDir : indexDirs) {
            indexes.add(indexDir.getName());
        }
        return indexes;
    }

    public OnmsResource getResourceByNodeAndIndex(int nodeId, final String index) {
        String label;
        LazySet set = new LazySet((LazySet.Loader)new AttributeLoader(nodeId, index));
        if (this.m_resourceLabelExpression == null) {
            label = index;
        } else {
            PropertiesUtils.SymbolTable symbolTable = new PropertiesUtils.SymbolTable((Set)set){
                private int lastN;
                private boolean lastNSet = false;
                final /* synthetic */ Set val$set;
                {
                    this.val$set = set;
                }

                public String getSymbolValue(String symbol) {
                    if (symbol.equals("index")) {
                        return index;
                    }
                    Matcher subIndexMatcher = SUB_INDEX_PATTERN.matcher(symbol);
                    if (subIndexMatcher.matches()) {
                        int end;
                        int start;
                        Matcher subIndexArgumentsMatcher = SUB_INDEX_ARGUMENTS_PATTERN.matcher(subIndexMatcher.group(1));
                        if (!subIndexArgumentsMatcher.matches()) {
                            return null;
                        }
                        List<String> indexElements = this.tokenizeIndex(index);
                        if ("n".equals(subIndexArgumentsMatcher.group(1)) && this.lastNSet) {
                            start = this.lastN;
                            this.lastNSet = false;
                        } else {
                            if ("n".equals(subIndexArgumentsMatcher.group(1))) {
                                return null;
                            }
                            int offset = Integer.parseInt(subIndexArgumentsMatcher.group(1));
                            start = offset < 0 ? indexElements.size() + offset : offset;
                        }
                        if ("n".equals(subIndexArgumentsMatcher.group(2))) {
                            end = start + Integer.parseInt(indexElements.get(start)) + 1;
                            ++start;
                            this.lastN = end;
                            this.lastNSet = true;
                        } else {
                            end = subIndexArgumentsMatcher.group(2) == null ? indexElements.size() : start + Integer.parseInt(subIndexArgumentsMatcher.group(2));
                        }
                        if (start < 0 || start >= indexElements.size()) {
                            return null;
                        }
                        if (end < 0 || end > indexElements.size()) {
                            return null;
                        }
                        StringBuffer indexSubString = new StringBuffer();
                        for (int i = start; i < end; ++i) {
                            if (indexSubString.length() != 0) {
                                indexSubString.append(".");
                            }
                            indexSubString.append(indexElements.get(i));
                        }
                        return indexSubString.toString();
                    }
                    Matcher hexMatcher = HEX_PATTERN.matcher(symbol);
                    if (hexMatcher.matches()) {
                        String subSymbol = this.getSymbolValue(hexMatcher.group(1));
                        List<String> indexElements = this.tokenizeIndex(subSymbol);
                        StringBuffer hexString = new StringBuffer();
                        for (String indexElement : indexElements) {
                            if (hexString.length() > 0) {
                                hexString.append(":");
                            }
                            try {
                                hexString.append(String.format("%02X", Integer.parseInt(indexElement)));
                            }
                            catch (NumberFormatException e) {
                                return null;
                            }
                        }
                        return hexString.toString();
                    }
                    Matcher stringMatcher = STRING_PATTERN.matcher(symbol);
                    if (stringMatcher.matches()) {
                        String subSymbol = this.getSymbolValue(stringMatcher.group(1));
                        List<String> indexElements = this.tokenizeIndex(subSymbol);
                        StringBuffer stringString = new StringBuffer();
                        for (String indexElement : indexElements) {
                            stringString.append(String.format("%c", Integer.parseInt(indexElement)));
                        }
                        return stringString.toString();
                    }
                    for (OnmsAttribute attr : this.val$set) {
                        if (!symbol.equals(attr.getName())) continue;
                        if (StringPropertyAttribute.class.isAssignableFrom(attr.getClass())) {
                            StringPropertyAttribute stringAttr = (StringPropertyAttribute)attr;
                            return stringAttr.getValue();
                        }
                        if (!ExternalValueAttribute.class.isAssignableFrom(attr.getClass())) continue;
                        ExternalValueAttribute extAttr = (ExternalValueAttribute)attr;
                        return extAttr.getValue();
                    }
                    return null;
                }

                private List<String> tokenizeIndex(String index2) {
                    ArrayList<String> indexElements = new ArrayList<String>();
                    StringTokenizer t = new StringTokenizer(index2, ".");
                    while (t.hasMoreTokens()) {
                        indexElements.add(t.nextToken());
                    }
                    return indexElements;
                }
            };
            label = PropertiesUtils.substitute((String)this.m_resourceLabelExpression, (PropertiesUtils.SymbolTable[])new PropertiesUtils.SymbolTable[]{symbolTable});
        }
        return new OnmsResource(index, label, (OnmsResourceType)this, (Set)set);
    }

    public String getRelativePathForResource(int nodeId, String index) {
        return "snmp" + File.separator + Integer.toString(nodeId) + File.separator + this.getName() + File.separator + index;
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        return Collections.EMPTY_LIST;
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeLoader
    implements LazySet.Loader<OnmsAttribute> {
        private int m_nodeId;
        private String m_index;

        public AttributeLoader(int nodeId, String index) {
            this.m_nodeId = nodeId;
            this.m_index = index;
        }

        public Set<OnmsAttribute> load() {
            return ResourceTypeUtils.getAttributesAtRelativePath(GenericIndexResourceType.this.m_resourceDao.getRrdDirectory(), GenericIndexResourceType.this.getRelativePathForResource(this.m_nodeId, this.m_index));
        }
    }
}

