/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.opennms.netmgt.dao.db.BackupTablesFoundException;
import org.opennms.netmgt.dao.db.Column;
import org.opennms.netmgt.dao.db.ColumnChange;
import org.opennms.netmgt.dao.db.ColumnChangeReplacement;
import org.opennms.netmgt.dao.db.Constraint;
import org.opennms.netmgt.dao.db.Index;
import org.opennms.netmgt.dao.db.IndexDao;
import org.opennms.netmgt.dao.db.Table;
import org.opennms.netmgt.dao.db.Trigger;
import org.opennms.netmgt.dao.db.TriggerDao;
import org.opennms.netmgt.dao.db.columnchanges.AutoIntegerReplacement;
import org.opennms.netmgt.dao.db.columnchanges.DoNotAddColumnReplacement;
import org.opennms.netmgt.dao.db.columnchanges.EventSourceReplacement;
import org.opennms.netmgt.dao.db.columnchanges.FixedIntegerReplacement;
import org.opennms.netmgt.dao.db.columnchanges.NextValReplacement;
import org.opennms.netmgt.dao.db.columnchanges.RowHasBogusDataReplacement;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerDb {
    private static final String IPLIKE_SQL_RESOURCE = "iplike.sql";
    public static final float POSTGRES_MIN_VERSION = 7.3f;
    public static final float POSTGRES_MAX_VERSION_PLUS_ONE = 8.5f;
    private static final int s_fetch_size = 1024;
    private static Comparator<Constraint> constraintComparator = new Comparator<Constraint>(){

        @Override
        public int compare(Constraint o1, Constraint o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final IndexDao m_indexDao = new IndexDao();
    private final TriggerDao m_triggerDao = new TriggerDao();
    private DataSource m_dataSource = null;
    private DataSource m_adminDataSource = null;
    private PrintStream m_out = System.out;
    private boolean m_debug = false;
    private String m_createSqlLocation = null;
    private String m_storedProcedureDirectory = null;
    private String m_databaseName = null;
    private String m_pass = null;
    private String m_pg_iplike = null;
    private String m_pg_plpgsql = null;
    private final Map<String, ColumnChangeReplacement> m_columnReplacements = new HashMap<String, ColumnChangeReplacement>();
    private String m_sql;
    private LinkedList<String> m_tables = null;
    private LinkedList<String> m_sequences = null;
    private final HashMap<String, List<Insert>> m_inserts = new HashMap();
    private final HashSet<String> m_drops = new HashSet();
    private final HashSet<String> m_changed = new HashSet();
    private Map<String, Integer> m_dbtypes = null;
    private HashMap<String, String[]> m_seqmapping = null;
    private Connection m_connection;
    private Connection m_adminConnection;
    private String m_user;
    private float m_pg_version;
    private boolean m_force = false;
    private boolean m_ignore_notnull = false;
    private boolean m_no_revert = false;

    public void readTables() throws Exception {
        this.readTables(new InputStreamReader((InputStream)new FileInputStream(this.m_createSqlLocation), "UTF-8"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readTables(Reader reader) throws Exception {
        String line;
        BufferedReader r = new BufferedReader(reader);
        this.m_tables = new LinkedList();
        this.m_seqmapping = new HashMap();
        this.m_sequences = new LinkedList();
        this.m_indexDao.reset();
        LinkedList<String> sql_l = new LinkedList<String>();
        Pattern seqmappingPattern = Pattern.compile("\\s*--#\\s+install:\\s*(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*.*");
        Pattern createPattern = Pattern.compile("(?i)\\s*create\\b.*");
        Pattern criteriaPattern = Pattern.compile("\\s*--#\\s+criteria:\\s*(.*)");
        Pattern insertPattern = Pattern.compile("(?i)INSERT INTO [\"']?([\\w_]+)[\"']?.*");
        Pattern dropPattern = Pattern.compile("(?i)DROP TABLE [\"']?([\\w_]+)[\"']?.*");
        String criteria = null;
        while ((line = r.readLine()) != null) {
            Insert insert;
            String table;
            if (line.matches("\\s*") || line.matches("\\s*\\\\.*")) continue;
            Matcher m = seqmappingPattern.matcher(line);
            if (m.matches()) {
                String[] a = new String[]{m.group(2), m.group(3)};
                this.m_seqmapping.put(m.group(1), a);
                continue;
            }
            m = criteriaPattern.matcher(line);
            if (m.matches()) {
                criteria = m.group(1);
                continue;
            }
            if (line.matches("--.*")) continue;
            if (createPattern.matcher(line).matches()) {
                m = Pattern.compile("(?i)\\s*create\\s+((?:unique )?\\w+)\\s+[\"']?(\\w+)[\"']?.*").matcher(line);
                if (!m.matches()) throw new Exception("Unknown CREATE encountered: " + line);
                String type = m.group(1);
                String name = m.group(2).replaceAll("^[\"']", "").replaceAll("[\"']$", "");
                if (type.toLowerCase().indexOf("table") != -1) {
                    this.m_tables.add(name);
                } else if (type.toLowerCase().indexOf("sequence") != -1) {
                    this.m_sequences.add(name);
                } else if (type.toLowerCase().indexOf("function") != -1) {
                    if (type.toLowerCase().indexOf("language 'c'") != -1) {
                        // empty if block
                    }
                } else if (type.toLowerCase().indexOf("trusted") != -1) {
                    m = Pattern.compile("(?i)\\s*create\\s+trusted procedural language\\s+[\"']?(\\w+)[\"']?.*").matcher(line);
                    if (!m.matches()) {
                        throw new Exception("Could not match name and type of the trusted procedural language in this line: " + line);
                    }
                } else {
                    if (!type.toLowerCase().matches(".*\\bindex\\b.*")) throw new Exception("Unknown CREATE encountered: CREATE " + type + " " + name);
                    Index i = Index.findIndexInString(line);
                    if (i == null) {
                        throw new Exception("Could not match name and type of the index in this line: " + line);
                    }
                    this.m_indexDao.add(i);
                }
                sql_l.add(line);
                continue;
            }
            m = insertPattern.matcher(line);
            if (m.matches()) {
                table = m.group(1);
                insert = new Insert(table, line, criteria);
                criteria = null;
                if (!this.m_inserts.containsKey(table)) {
                    this.m_inserts.put(table, new LinkedList());
                }
                this.m_inserts.get(table).add(insert);
                continue;
            }
            if (line.toLowerCase().startsWith("select setval ")) {
                table = "select_setval";
                insert = new Insert("select_setval", line, null);
                if (!this.m_inserts.containsKey(table)) {
                    this.m_inserts.put(table, new LinkedList());
                }
                this.m_inserts.get(table).add(insert);
                sql_l.add(line);
                continue;
            }
            m = dropPattern.matcher(line);
            if (m.matches()) {
                this.m_drops.add(m.group(1));
                sql_l.add(line);
                continue;
            }
            sql_l.add(line);
        }
        r.close();
        this.m_sql = InstallerDb.cleanText(sql_l);
    }

    public static String cleanText(List<String> list) {
        StringBuffer s = new StringBuffer();
        for (String l : list) {
            s.append(l.replaceAll("\\s+", " "));
            if (l.indexOf(59) == -1) continue;
            s.append('\n');
        }
        return s.toString();
    }

    public void createSequences() throws Exception {
        this.assertUserSet();
        Statement st = this.getConnection().createStatement();
        this.m_out.println("- creating sequences... ");
        for (String sequence : this.getSequenceNames()) {
            if (this.getSequenceMapping(sequence) != null) continue;
            throw new Exception("Cannot find sequence mapping for " + sequence);
        }
        for (String sequence : this.getSequenceNames()) {
            int minvalue = 1;
            this.m_out.print("  - checking \"" + sequence + "\" sequence... ");
            ResultSet rs = st.executeQuery("SELECT relname FROM pg_class WHERE relname = '" + sequence.toLowerCase() + "'");
            boolean alreadyExists = rs.next();
            if (alreadyExists) {
                this.m_out.println("ALREADY EXISTS");
                continue;
            }
            this.m_out.println("DOES NOT EXIST");
            this.m_out.print("    - creating sequence \"" + sequence + "\"... ");
            st.execute("CREATE SEQUENCE " + sequence + " minvalue " + minvalue);
            this.m_out.println("OK");
            this.grantAccessToObject(sequence, 4);
        }
        this.m_out.println("- creating sequences... DONE");
    }

    public void updatePlPgsql() throws Exception {
        Statement st = this.getConnection().createStatement();
        this.m_out.print("- adding PL/pgSQL call handler... ");
        ResultSet rs = st.executeQuery("SELECT oid FROM pg_proc WHERE proname='plpgsql_call_handler' AND proargtypes = ''");
        if (rs.next()) {
            this.m_out.println("EXISTS");
        } else if (this.isPgPlPgsqlLibPresent()) {
            st.execute("CREATE FUNCTION plpgsql_call_handler () RETURNS OPAQUE AS '" + this.m_pg_plpgsql + "' LANGUAGE 'c'");
            this.m_out.println("OK");
        } else {
            this.m_out.println("SKIPPED (location of PL/pgSQL library not set, will try to continue)");
        }
        this.m_out.print("- adding PL/pgSQL language module... ");
        rs = st.executeQuery("SELECT pg_language.oid FROM pg_language, pg_proc WHERE pg_proc.proname='plpgsql_call_handler' AND pg_proc.proargtypes = '' AND pg_proc.oid = pg_language.lanplcallfoid AND pg_language.lanname = 'plpgsql'");
        if (rs.next()) {
            this.m_out.println("EXISTS");
        } else {
            st.execute("CREATE TRUSTED PROCEDURAL LANGUAGE 'plpgsql' HANDLER plpgsql_call_handler LANCOMPILER 'PL/pgSQL'");
            this.m_out.println("OK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIpLikeUsable() {
        Statement st = null;
        try {
            this.m_out.print("- checking if iplike is usable... ");
            st = this.getConnection().createStatement();
            st.execute("SELECT IPLIKE('127.0.0.1', '*.*.*.*')");
            this.m_out.println("YES");
            boolean bl = true;
            this.closeQuietly(st);
            return bl;
        }
        catch (SQLException selectException) {
            try {
                this.m_out.println("NO");
                boolean bl = false;
                this.closeQuietly(st);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeQuietly(st);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIplike() throws Exception {
        block8: {
            boolean insert_iplike;
            boolean bl = insert_iplike = !this.isIpLikeUsable();
            if (insert_iplike) {
                this.dropExistingIpLike();
                boolean success = this.installCIpLike();
                if (!success) {
                    this.setupPlPgsqlIplike();
                }
            }
            this.m_out.print("- checking for stale eventtime.so references... ");
            Statement st = null;
            try {
                st = this.getConnection().createStatement();
                st.execute("DROP FUNCTION eventtime(text)");
                this.m_out.println("REMOVED");
            }
            catch (SQLException e) {
                if (e.toString().indexOf("does not exist") != -1 || "42883".equals(e.getSQLState())) {
                    this.m_out.println("OK");
                    break block8;
                }
                this.m_out.println("FAILED");
                throw e;
            }
            finally {
                this.closeQuietly(st);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installCIpLike() {
        boolean success;
        this.m_out.print("- inserting C iplike function... ");
        if (this.m_pg_iplike == null) {
            success = false;
            this.m_out.println("SKIPPED (location of iplike function not set)");
        } else {
            Statement st = null;
            try {
                st = this.getConnection().createStatement();
                st.execute("CREATE FUNCTION iplike(text,text) RETURNS bool AS '" + this.m_pg_iplike + "' LANGUAGE 'c' WITH(isstrict)");
                success = true;
                this.m_out.println("OK");
            }
            catch (SQLException e) {
                success = false;
                this.m_out.println("FAILED (" + e + ")");
            }
            finally {
                this.closeQuietly(st);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropExistingIpLike() throws SQLException {
        block6: {
            Statement st = null;
            this.m_out.print("- removing existing iplike definition (if any)... ");
            try {
                st = this.getConnection().createStatement();
                st.execute("DROP FUNCTION iplike(text,text)");
                this.m_out.println("OK");
            }
            catch (SQLException dropException) {
                if (dropException.toString().contains("does not exist") || "42883".equals(dropException.getSQLState())) {
                    this.m_out.println("OK");
                    break block6;
                }
                this.m_out.println("FAILED");
                throw dropException;
            }
            finally {
                this.closeQuietly(st);
            }
        }
    }

    public void setupPlPgsqlIplike() throws Exception {
        InputStream sqlfile = null;
        Statement st = null;
        try {
            String line;
            st = this.getConnection().createStatement();
            this.m_out.print("- inserting PL/pgSQL iplike function... ");
            sqlfile = this.getClass().getResourceAsStream(IPLIKE_SQL_RESOURCE);
            if (sqlfile == null) {
                String message = "unable to locate iplike.sql";
                this.m_out.println("FAILED (" + message + ")");
                throw new Exception(message);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(sqlfile, "UTF-8"));
            StringBuffer createFunction = new StringBuffer();
            while ((line = in.readLine()) != null) {
                createFunction.append(line).append("\n");
            }
            st.execute(createFunction.toString());
            this.m_out.println("OK");
            this.closeQuietly(st);
            this.closeQuietly(sqlfile);
        }
        catch (Exception e) {
            try {
                this.m_out.println("FAILED");
                throw e;
            }
            catch (Throwable throwable) {
                this.closeQuietly(st);
                this.closeQuietly(sqlfile);
                throw throwable;
            }
        }
    }

    private void closeQuietly(InputStream sqlfile) {
        try {
            if (sqlfile != null) {
                sqlfile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeQuietly(Statement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addStoredProcedures() throws Exception {
        File[] list;
        this.m_triggerDao.reset();
        Statement st = this.getConnection().createStatement();
        this.m_out.print("- adding stored procedures... ");
        FileFilter sqlFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().startsWith("get") && pathname.getName().endsWith(".sql") || pathname.getName().endsWith("Trigger.sql");
            }
        };
        for (File element : list = new File(this.m_storedProcedureDirectory).listFiles(sqlFilter)) {
            String returns;
            String columns;
            Matcher m;
            String line;
            LinkedList<String> drop = new LinkedList<String>();
            StringBuffer create = new StringBuffer();
            this.m_out.print("\n  - " + element.getName() + "... ");
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(element), "UTF-8"));
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).matches("--.*")) continue;
                if (line.toLowerCase().startsWith("drop function") || line.toLowerCase().startsWith("drop trigger")) {
                    drop.add(line);
                    continue;
                }
                create.append(line);
                create.append("\n");
            }
            r.close();
            Trigger t = Trigger.findTriggerInString(create.toString());
            if (t != null) {
                this.m_triggerDao.add(t);
            }
            if (!(m = Pattern.compile("(?is)\\b(CREATE(?: OR REPLACE)? FUNCTION\\s+(\\w+)\\s*\\((.*?)\\)\\s+RETURNS\\s+(\\S+)\\s+AS\\s+(.+? language ['\"]?\\w+['\"]?);)").matcher(create.toString())).find()) {
                throw new Exception("For stored procedure in file '" + element.getName() + "' couldn't match \"" + m.pattern().pattern() + "\" in string \"" + create + "\"");
            }
            String createSql = m.group(1);
            String function = m.group(2);
            if (this.functionExists(function, columns = m.group(3), returns = m.group(4))) {
                if (t != null && t.isOnDatabase(this.getConnection())) {
                    t.removeFromDatabase(this.getConnection());
                }
                st.execute("DROP FUNCTION " + function + " (" + columns + ")");
                st.execute(createSql);
                this.m_out.print("OK (dropped and re-added)");
                continue;
            }
            st.execute(createSql);
            this.m_out.print("OK");
        }
        this.m_out.println("");
    }

    public boolean functionExists(String function, String columns, String returnType) throws Exception {
        Map<String, Integer> types = this.getTypesFromDB();
        int[] columnTypes = new int[]{};
        if ((columns = columns.trim()).length() > 0) {
            String[] splitColumns = columns.split("\\s*,\\s*");
            columnTypes = new int[splitColumns.length];
            for (int j = 0; j < splitColumns.length; ++j) {
                Column c = new Column();
                c.parseColumnType(splitColumns[j]);
                columnTypes[j] = types.get(c.getType());
            }
        }
        Column c = new Column();
        try {
            c.parseColumnType(returnType);
        }
        catch (Exception e) {
            throw new Exception("Could not parse column type '" + returnType + "' for function '" + function + "'.  Nested exception: " + e.getMessage(), e);
        }
        int retType = types.get(c.getType());
        return this.functionExists(function, columnTypes, retType);
    }

    public boolean functionExists(String function, int[] columnTypes, int retType) throws Exception {
        Statement st = this.getConnection().createStatement();
        StringBuffer ct = new StringBuffer();
        for (int columnType : columnTypes) {
            ct.append(" " + columnType);
        }
        String query = "SELECT oid FROM pg_proc WHERE proname='" + function.toLowerCase() + "' AND " + "prorettype=" + retType + " AND " + "proargtypes='" + ct.toString().trim() + "'";
        ResultSet rs = st.executeQuery(query);
        return rs.next();
    }

    public Map<String, Integer> getTypesFromDB() throws SQLException {
        if (this.m_dbtypes != null) {
            return this.m_dbtypes;
        }
        Statement st = this.getConnection().createStatement();
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        ResultSet rs = st.executeQuery("SELECT oid,typname,typlen FROM pg_type");
        while (rs.next()) {
            try {
                m.put(Column.normalizeColumnType(rs.getString(2), rs.getInt(3) < 0), new Integer(rs.getInt(1)));
            }
            catch (Exception e) {}
        }
        this.m_dbtypes = m;
        return this.m_dbtypes;
    }

    public void addTriggersForTable(String table) throws SQLException {
        List<Trigger> triggers = this.m_triggerDao.getTriggersForTable(table.toLowerCase());
        for (Trigger trigger : triggers) {
            this.m_out.print("    - checking trigger '" + trigger.getName() + "' on this table... ");
            if (!trigger.isOnDatabase(this.getConnection())) {
                trigger.addToDatabase(this.getConnection());
            }
            this.m_out.println("DONE");
        }
    }

    public void createTables() throws Exception {
        this.assertUserSet();
        Statement st = this.getConnection().createStatement();
        this.m_out.println("- creating tables...");
        for (String tableName : this.getTableNames()) {
            if (this.m_force) {
                tableName = tableName.toLowerCase();
                String create = this.getTableCreateFromSQL(tableName);
                ResultSet rs = st.executeQuery("SELECT relname FROM pg_class WHERE relname = '" + tableName + "'");
                boolean remove = rs.next();
                this.m_out.print("  - removing old table... ");
                if (remove) {
                    st.execute("DROP TABLE " + tableName + " CASCADE");
                    this.m_out.println("REMOVED");
                } else {
                    this.m_out.println("CLEAN");
                }
                this.m_out.print("  - creating table \"" + tableName + "\"... ");
                st.execute("CREATE TABLE " + tableName + " (" + create + ")");
                this.m_out.println("CREATED");
                this.addIndexesForTable(tableName);
                this.addTriggersForTable(tableName);
                this.grantAccessToObject(tableName, 2);
                continue;
            }
            this.m_out.println("  - checking table \"" + tableName + "\"... ");
            tableName = tableName.toLowerCase();
            Table newTable = this.getTableFromSQL(tableName);
            Table oldTable = this.getTableFromDB(tableName);
            if (newTable.equals(oldTable)) {
                this.addIndexesForTable(tableName);
                this.addTriggersForTable(tableName);
                this.m_out.println("  - checking table \"" + tableName + "\"... UPTODATE");
                continue;
            }
            if (oldTable == null) {
                String create = this.getTableCreateFromSQL(tableName);
                String createSql = "CREATE TABLE " + tableName + " (" + create + ")";
                this.m_out.print("  - checking table \"" + tableName + "\"... ");
                st.execute(createSql);
                this.m_out.println("CREATED");
                this.addIndexesForTable(tableName);
                this.addTriggersForTable(tableName);
                this.grantAccessToObject(tableName, 2);
                continue;
            }
            try {
                this.changeTable(tableName, oldTable, newTable);
            }
            catch (Exception e) {
                throw new Exception("Error changing table '" + tableName + "'.  Nested exception: " + e.getMessage(), e);
            }
        }
        this.m_out.println("- creating tables... DONE");
    }

    public Table getTableFromSQL(String tableName) throws Exception {
        Table table = new Table();
        LinkedList<Column> columns = new LinkedList<Column>();
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        boolean parens = false;
        StringBuffer accumulator = new StringBuffer();
        String create = this.getTableCreateFromSQL(tableName);
        for (int i = 0; i <= create.length(); ++i) {
            char c = ' ';
            if (i < create.length() && ((c = (char)create.charAt(i)) == '(' || c == ')')) {
                parens = c == '(';
                accumulator.append(c);
                continue;
            }
            if (c == ',' && !parens || i == create.length()) {
                String a = accumulator.toString().trim();
                if (a.toLowerCase().startsWith("constraint ")) {
                    Constraint constraint;
                    try {
                        constraint = new Constraint(tableName, a);
                    }
                    catch (Exception e) {
                        throw new Exception("Could not parse constraint for table '" + tableName + "'.  Nested exception: " + e.getMessage(), e);
                    }
                    List<String> constraintColumns = constraint.getColumns();
                    if (constraint.getType() != 3) {
                        Assert.state((constraintColumns.size() > 0 ? 1 : 0) != 0, (String)("constraint '" + constraint.getName() + "' has no constrained columns"));
                        for (String constrainedName : constraintColumns) {
                            Column constrained = this.findColumn(columns, constrainedName);
                            if (constrained != null) continue;
                            throw new Exception("constraint " + constraint.getName() + " references column \"" + constrainedName + "\", which is not a column in the table " + tableName);
                        }
                    }
                    constraints.add(constraint);
                } else {
                    Column column = new Column();
                    try {
                        column.parse(accumulator.toString());
                        columns.add(column);
                    }
                    catch (Exception e) {
                        throw new Exception("Could not parse table " + tableName + ".  Chained: " + e.getMessage(), e);
                    }
                }
                accumulator = new StringBuffer();
                continue;
            }
            accumulator.append(c);
        }
        table.setName(tableName);
        table.setColumns(columns);
        Collections.sort(constraints, constraintComparator);
        table.setConstraints(constraints);
        table.setNotNullOnPrimaryKeyColumns();
        return table;
    }

    public String getXFromSQL(String item, String regex, int itemGroup, int returnGroup, String description) throws Exception {
        item = item.toLowerCase();
        Matcher m = Pattern.compile(regex).matcher(this.getSql());
        while (m.find()) {
            if (!m.group(itemGroup).toLowerCase().equals(item)) continue;
            return m.group(returnGroup);
        }
        throw new Exception("could not find " + description + " \"" + item + "\"");
    }

    public Column findColumn(List<Column> columns, String column) {
        for (Column c : columns) {
            if (!c.getName().equals(column.toLowerCase())) continue;
            return c;
        }
        return null;
    }

    public boolean tableColumnExists(String table, String column) throws Exception {
        return this.findColumn(this.getTableColumnsFromDB(table), column) != null;
    }

    public List<Column> getTableColumnsFromDB(String tableName) throws Exception {
        Table table = this.getTableFromDB(tableName);
        if (table == null) {
            return null;
        }
        return table.getColumns();
    }

    public Table getTableFromDB(String tableName) throws Exception {
        if (!this.tableExists(tableName)) {
            return null;
        }
        Table table = new Table();
        table.setName(tableName.toLowerCase());
        List<Column> columns = this.getColumnsFromDB(tableName);
        List<Constraint> constraints = this.getConstraintsFromDB(tableName);
        Collections.sort(constraints, constraintComparator);
        table.setColumns(columns);
        table.setConstraints(constraints);
        return table;
    }

    public boolean tableExists(String table) throws SQLException {
        Statement st = this.getConnection().createStatement();
        ResultSet rs = st.executeQuery("SELECT DISTINCT tablename FROM pg_tables WHERE lower(tablename) = '" + table.toLowerCase() + "'");
        return rs.next();
    }

    public List<Column> getColumnsFromDB(String tableName) throws Exception {
        LinkedList<Column> columns = new LinkedList<Column>();
        Statement st = this.getConnection().createStatement();
        String query = "SELECT         attname,         format_type(atttypid, atttypmod),         attnotnull FROM         pg_attribute WHERE         attrelid = (SELECT oid FROM pg_class WHERE relname = '" + tableName.toLowerCase() + "') " + "    AND " + "        attnum > 0";
        if ((double)this.m_pg_version >= 7.3) {
            query = query + " AND attisdropped = false";
        }
        query = query + " ORDER BY attnum";
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            Column c = new Column();
            c.setName(rs.getString(1));
            String columnType = rs.getString(2);
            try {
                c.parseColumnType(columnType);
            }
            catch (Exception e) {
                throw new Exception("Error parsing column type '" + columnType + "' for column '" + rs.getString(1) + "' in table '" + tableName + "'.  Nested: " + e.getMessage(), e);
            }
            c.setNotNull(rs.getBoolean(3));
            columns.add(c);
        }
        rs.close();
        st.close();
        st = this.getConnection().createStatement();
        query = "SELECT         attr.attname,         pg_get_expr(def.adbin, def.adrelid) FROM         pg_attribute attr,         pg_attrdef def WHERE         attr.attrelid = (SELECT oid FROM pg_class WHERE relname = '" + tableName.toLowerCase() + "') " + "    AND " + "        attr.attnum > 0" + "    AND " + "        attr.atthasdef = 't' " + "    AND " + "        attr.attrelid = def.adrelid" + "    AND " + "        attr.attnum = def.adnum";
        if ((double)this.m_pg_version >= 7.3) {
            query = query + " AND attr.attisdropped = false";
        }
        rs = st.executeQuery(query);
        while (rs.next()) {
            Column column = null;
            for (Column c : columns) {
                if (!c.getName().equals(rs.getString(1))) continue;
                column = c;
                break;
            }
            if (column == null) {
                throw new Exception("Could not find column '" + rs.getString(1) + "' in original column list when adding default values");
            }
            column.setDefaultValue(rs.getString(2).replaceAll("'(.*)'::([a-zA-Z ]+)", "'$1'"));
        }
        rs.close();
        st.close();
        return columns;
    }

    public List<Constraint> getConstraintsFromDB(String tableName) throws SQLException, Exception {
        Statement st = this.getConnection().createStatement();
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        String query = "SELECT c.oid, c.conname, c.contype, c.conrelid, c.confrelid, a.relname, c.confupdtype, c.confdeltype, c.consrc from pg_class a right join pg_constraint c on c.confrelid = a.oid where c.conrelid = (select oid from pg_class where relname = '" + tableName.toLowerCase() + "') order by c.oid";
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            Constraint constraint;
            List<String> columns;
            int oid = rs.getInt(1);
            String name = rs.getString(2);
            String type = rs.getString(3);
            int conrelid = rs.getInt(4);
            int confrelid = rs.getInt(5);
            String ftable = rs.getString(6);
            String foreignUpdType = rs.getString(7);
            String foreignDelType = rs.getString(8);
            String checkExpression = rs.getString(9);
            if ("p".equals(type)) {
                columns = this.getConstrainedColumnsFromDBForConstraint(oid, conrelid);
                constraint = new Constraint(tableName.toLowerCase(), name, columns);
            } else if ("f".equals(type)) {
                columns = this.getConstrainedColumnsFromDBForConstraint(oid, conrelid);
                List<String> fcolumns = this.getForeignColumnsFromDBForConstraint(oid, confrelid);
                constraint = new Constraint(tableName.toLowerCase(), name, columns, ftable, fcolumns, foreignUpdType, foreignDelType);
            } else if ("c".equals(type)) {
                constraint = new Constraint(tableName.toLowerCase(), name, checkExpression);
            } else {
                throw new Exception("Do not support constraint type \"" + type + "\" in constraint \"" + name + "\"");
            }
            constraints.add(constraint);
        }
        return constraints;
    }

    private List<String> getConstrainedColumnsFromDBForConstraint(int oid, int conrelid) throws Exception {
        Statement st = this.getConnection().createStatement();
        LinkedList<String> columns = new LinkedList<String>();
        String query = "select a.attname from pg_attribute a, pg_constraint c where a.attrelid = c.conrelid and a.attnum = ANY (c.conkey) and c.oid = " + oid + " and a.attrelid = " + conrelid;
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            columns.add(rs.getString(1));
        }
        rs.close();
        st.close();
        return columns;
    }

    private List<String> getForeignColumnsFromDBForConstraint(int oid, int confrelid) throws Exception {
        Statement st = this.getConnection().createStatement();
        LinkedList<String> columns = new LinkedList<String>();
        String query = "select a.attname from pg_attribute a, pg_constraint c where a.attrelid = c.confrelid and a.attnum = ANY (c.confkey) and c.oid = " + oid + " and a.attrelid = " + confrelid;
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            columns.add(rs.getString(1));
        }
        rs.close();
        st.close();
        return columns;
    }

    public void changeTable(String table, Table oldTable, Table newTable) throws Exception {
        this.assertUserSet();
        List<Column> oldColumns = oldTable.getColumns();
        List<Column> newColumns = newTable.getColumns();
        Statement st = this.getConnection().createStatement();
        TreeMap<String, ColumnChange> columnChanges = new TreeMap<String, ColumnChange>();
        Object[] oldColumnNames = new String[oldColumns.size()];
        if (this.hasTableChanged(table)) {
            return;
        }
        this.tableChanged(table);
        this.m_out.println("  - checking table \"" + table + "\"... SCHEMA DOES NOT MATCH");
        this.m_out.println("    - differences:");
        for (Constraint newConstraint : newTable.getConstraints()) {
            this.m_out.println("new constraint: " + newConstraint.getTable() + ": " + newConstraint);
        }
        for (Constraint oldConstraint : oldTable.getConstraints()) {
            this.m_out.println("old constraint: " + oldConstraint.getTable() + ": " + oldConstraint);
        }
        for (Column newColumn : newColumns) {
            String message;
            Column oldColumn = this.findColumn(oldColumns, newColumn.getName());
            if (oldColumn == null || !newColumn.equals(oldColumn)) {
                this.m_out.println("      - column \"" + newColumn.getName() + "\" is different");
                if (this.m_debug) {
                    this.m_out.println("        - old column: " + (oldColumn == null ? "null" : oldColumn.toString()));
                    this.m_out.println("        - new column: " + newColumn);
                }
            }
            if (!columnChanges.containsKey(newColumn.getName())) {
                columnChanges.put(newColumn.getName(), new ColumnChange());
            }
            ColumnChange columnChange = (ColumnChange)columnChanges.get(newColumn.getName());
            columnChange.setColumn(newColumn);
            if (this.m_columnReplacements.containsKey(table + "." + newColumn.getName())) {
                columnChange.setColumnReplacement(this.m_columnReplacements.get(table + "." + newColumn.getName()));
            }
            if (!newColumn.isNotNull() || columnChange.getColumnReplacement() != null) continue;
            if (oldColumn == null) {
                message = "Column " + newColumn.getName() + " in new table has NOT NULL " + "constraint, however this column " + "did not exist before and there is " + "no change replacement for this column";
                if (this.m_ignore_notnull) {
                    this.m_out.println(message + ".  Ignoring due to '-N'");
                    continue;
                }
                throw new Exception(message);
            }
            if (oldColumn.isNotNull()) continue;
            message = "Column " + newColumn.getName() + " in new table has NOT NULL " + "constraint, however this column " + "did not have the NOT NULL " + "constraint before and there is " + "no change replacement for this column";
            if (this.m_ignore_notnull) {
                this.m_out.println(message + ".  Ignoring due to '-N'");
                continue;
            }
            throw new Exception(message);
        }
        int i = 0;
        for (Column oldColumn : oldColumns) {
            oldColumnNames[i] = oldColumn.getName();
            if (columnChanges.containsKey(oldColumn.getName())) {
                ColumnChange columnChange = (ColumnChange)columnChanges.get(oldColumn.getName());
                Column newColumn = columnChange.getColumn();
                if (newColumn.getType().indexOf("timestamp") != -1) {
                    columnChange.setUpgradeTimestamp(true);
                }
            } else {
                this.m_out.println("      * WARNING: column \"" + oldColumn.getName() + "\" exists in the " + "database but is not in the new schema.  " + "REMOVING COLUMN");
            }
            ++i;
        }
        String tmpTable = table + "_old_" + System.currentTimeMillis();
        try {
            if (this.tableExists(tmpTable)) {
                st.execute("DROP TABLE " + tmpTable + " CASCADE");
            }
            this.m_out.print("    - creating temporary table... ");
            st.execute("CREATE TABLE " + tmpTable + " AS SELECT " + StringUtils.arrayToDelimitedString((Object[])oldColumnNames, (String)", ") + " FROM " + table);
            this.m_out.println("done");
            st.execute("DROP TABLE " + table + " CASCADE");
            this.m_out.print("    - creating new '" + table + "' table... ");
            st.execute("CREATE TABLE " + table + " (" + this.getTableCreateFromSQL(table) + ")");
            this.m_out.println("done");
            this.addIndexesForTable(table);
            this.addTriggersForTable(table);
            this.transformData(table, tmpTable, columnChanges, (String[])oldColumnNames);
            this.grantAccessToObject(table, 4);
            this.m_out.print("    - optimizing table " + table + "... ");
            st.execute("VACUUM ANALYZE " + table);
            this.m_out.println("DONE");
        }
        catch (Exception e) {
            if (this.m_no_revert) {
                this.m_out.println("FAILED!  Not reverting due to '-R' being passed.  Old data in " + tmpTable);
                throw e;
            }
            try {
                this.getConnection().rollback();
                this.getConnection().setAutoCommit(true);
                if (this.tableExists(table)) {
                    st.execute("DROP TABLE " + table + " CASCADE");
                }
                st.execute("CREATE TABLE " + table + " AS SELECT " + StringUtils.arrayToDelimitedString((Object[])oldColumnNames, (String)", ") + " FROM " + tmpTable);
                st.execute("DROP TABLE " + tmpTable);
            }
            catch (SQLException se) {
                throw new Exception("Got SQLException while trying to revert table changes due to original error: " + e + "\n" + "SQLException while reverting table: " + se, e);
            }
            this.m_out.println("FAILED!  Old data restored, however indexes and constraints on this table were not re-added");
            throw e;
        }
        st.execute("DROP TABLE " + tmpTable);
        this.m_out.println("  - checking table \"" + table + "\"... COMPLETED UPDATING TABLE");
    }

    public void transformData(String table, String oldTable, TreeMap<String, ColumnChange> columnChanges, String[] oldColumnNames) throws SQLException, ParseException, Exception {
        Statement st = this.getConnection().createStatement();
        st.setFetchSize(1024);
        for (int i = 0; i < oldColumnNames.length; ++i) {
            ColumnChange c = columnChanges.get(oldColumnNames[i]);
            if (c == null) continue;
            c.setSelectIndex(i + 1);
        }
        LinkedList<String> insertColumns = new LinkedList<String>();
        LinkedList<String> questionMarks = new LinkedList<String>();
        for (ColumnChange c : columnChanges.values()) {
            c.setColumnType(c.getColumn().getColumnSqlType());
            ColumnChangeReplacement r = c.getColumnReplacement();
            if (r != null && c.getSelectIndex() <= 0 && !r.addColumnIfColumnIsNew()) continue;
            insertColumns.add(c.getColumn().getName());
            questionMarks.add("?");
            c.setPrepareIndex(questionMarks.size());
        }
        this.m_out.print("    - transforming data into the new table...\r");
        ResultSet rs = st.executeQuery("SELECT count(*) FROM " + oldTable);
        rs.next();
        long num_rows = rs.getLong(1);
        String order = table.equals("outages") ? " ORDER BY iflostservice" : "";
        String dbcmd = "SELECT " + StringUtils.arrayToDelimitedString((Object[])oldColumnNames, (String)", ") + " FROM " + oldTable + order;
        if (this.m_debug) {
            this.m_out.println("    - performing select: " + dbcmd);
        }
        PreparedStatement select = this.getConnection().prepareStatement(dbcmd);
        select.setFetchSize(1024);
        dbcmd = "INSERT INTO " + table + " (" + StringUtils.collectionToDelimitedString(insertColumns, (String)", ") + ") values (" + StringUtils.collectionToDelimitedString(questionMarks, (String)", ") + ")";
        if (this.m_debug) {
            this.m_out.println("    - performing insert: " + dbcmd);
        }
        PreparedStatement insert = this.getConnection().prepareStatement(dbcmd);
        rs = select.executeQuery();
        this.getConnection().setAutoCommit(false);
        SimpleDateFormat dateParser = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        char[] spin = new char[]{'/', '-', '\\', '|'};
        int current_row = 0;
        while (rs.next()) {
            for (ColumnChange change : columnChanges.values()) {
                Object obj;
                String name = change.getColumn().getName();
                if (change.getSelectIndex() == 0 && change.hasColumnReplacement() && !change.getColumnReplacement().addColumnIfColumnIsNew()) continue;
                if (change.getSelectIndex() > 0) {
                    obj = rs.getObject(change.getSelectIndex());
                    if (rs.wasNull()) {
                        obj = null;
                    }
                } else {
                    if (this.m_debug) {
                        this.m_out.println("      - don't know what to do for \"" + name + "\", prepared column " + change.getPrepareIndex() + ": setting to null");
                    }
                    obj = null;
                }
                if (obj == null && change.hasColumnReplacement()) {
                    ColumnChangeReplacement replacement = change.getColumnReplacement();
                    obj = replacement.getColumnReplacement(rs, columnChanges);
                    if (this.m_debug) {
                        this.m_out.println("      - " + name + " was NULL but is a " + "requires NULL replacement -- " + "replacing with '" + obj + "'");
                    }
                }
                if (obj != null) {
                    if (change.isUpgradeTimestamp() && !obj.getClass().equals(Timestamp.class)) {
                        if (this.m_debug) {
                            this.m_out.println("      - " + name + " is an old-style timestamp");
                        }
                        String newObj = dateFormatter.format(dateParser.parse((String)obj));
                        if (this.m_debug) {
                            this.m_out.println("      - " + obj + " -> " + newObj);
                        }
                        obj = newObj;
                    }
                    if (this.m_debug) {
                        this.m_out.println("      - " + name + " = " + obj);
                    }
                } else if (this.m_debug) {
                    this.m_out.println("      - " + name + " = undefined");
                }
                if (obj == null) {
                    insert.setNull(change.getPrepareIndex(), change.getColumnType());
                    continue;
                }
                insert.setObject(change.getPrepareIndex(), obj);
            }
            try {
                insert.execute();
            }
            catch (SQLException e) {
                SQLException ex = new SQLException("Statement.execute() threw an SQLException while inserting a row: \"" + insert.toString() + "\".  " + "Original exception: " + e.toString(), e.getSQLState(), e.getErrorCode());
                ex.setNextException(e);
                throw ex;
            }
            if (++current_row % 20 != 0) continue;
            System.err.print("    - transforming data into the new table... " + (int)Math.floor((long)(current_row * 100) / num_rows) + "%  [" + spin[current_row / 20 % spin.length] + "]\r");
        }
        rs.close();
        select.close();
        insert.close();
        this.getConnection().commit();
        this.getConnection().setAutoCommit(true);
        if (table.equals("events") && num_rows == 0L) {
            st.execute("INSERT INTO events (eventid, eventuei, eventtime, eventsource, eventdpname, eventcreatetime, eventseverity, eventlog, eventdisplay) values (0, 'http://uei.opennms.org/dummyevent', now(), 'OpenNMS.Eventd', 'localhost', now(), 1, 'Y', 'Y')");
        }
        st.close();
        this.m_out.println("    - transforming data into the new table... DONE           ");
    }

    @Deprecated
    public void databaseCheckVersion() throws Exception {
        String pgFullVersion;
        this.m_out.print("- checking database version... ");
        Statement st = this.getAdminConnection().createStatement();
        ResultSet rs = st.executeQuery("SELECT version()");
        if (!rs.next()) {
            throw new Exception("Database didn't return any rows for 'SELECT version()'");
        }
        String versionString = rs.getString(1);
        rs.close();
        st.close();
        Matcher m = Pattern.compile("^PostgreSQL (\\d+\\.\\d+\\.\\d+)").matcher(versionString);
        if (m.find() && (pgFullVersion = m.group(1)).equals("8.4.0")) {
            throw new Exception(String.format("Unsupported database version 8.4.0.  PostgreSQL 8.4.0 has a bug in left join subselects which causes issues with OpenNMS.", new Object[0]));
        }
        m = Pattern.compile("^PostgreSQL (\\d+\\.\\d+)").matcher(versionString);
        if (!m.find()) {
            throw new Exception("Could not parse version number out of version string: " + versionString);
        }
        this.m_pg_version = Float.parseFloat(m.group(1));
        String message = "Unsupported database version \"" + this.m_pg_version + "\" -- you need at least " + 7.3f + " and less than " + 8.5f + ".  Use the \"-Q\" option to disable this check " + "if you feel brave and are willing to find and " + "fix bugs found yourself.";
        if (this.m_pg_version < 7.3f) {
            throw new Exception(message);
        }
        if (this.m_pg_version >= 8.5f) {
            throw new Exception(message);
        }
        this.m_out.println(Float.toString(this.m_pg_version));
        this.m_out.println("  - Full version string: " + versionString);
    }

    public void databaseCheckLanguage() throws Exception {
        if ((double)this.m_pg_version >= 7.4) {
            return;
        }
        String timestamp = Long.toString(System.currentTimeMillis());
        String bogus_query = "SELECT bogus_column_" + timestamp + " " + "FROM bogus_table_" + timestamp + " " + "WHERE another_bogus_column_" + timestamp + " IS NULL";
        try {
            Statement st = this.getAdminConnection().createStatement();
            st.executeQuery(bogus_query);
        }
        catch (SQLException e) {
            if (e.toString().indexOf("does not exist") != -1) {
                return;
            }
            throw new Exception("The database server's error messages are not in English, however the installer requires them to be in English when using PostgreSQL earlier than 7.4.  You either need to set \"lc_messages = 'C'\" in your postgresql.conf file and restart PostgreSQL or upgrade to PostgreSQL 7.4 or later.  The installer executed the query \"" + bogus_query + "\" and expected " + "\"does not exist\" in the error message, " + "but this exception was received instead: " + e, e);
        }
        throw new Exception("Expected an SQLException when executing a bogus query to test for the server's error message language, however the query succeeded unexpectedly.  SQL query: \"" + bogus_query + "\".");
    }

    public void checkOldTables() throws SQLException, BackupTablesFoundException {
        Statement st = this.getConnection().createStatement();
        ResultSet rs = st.executeQuery("SELECT relname FROM pg_class WHERE relkind = 'r' AND relname LIKE '%_old_%'");
        LinkedList<String> oldTables = new LinkedList<String>();
        this.m_out.print("- checking database for old backup tables... ");
        while (rs.next()) {
            oldTables.add(rs.getString(1));
        }
        rs.close();
        st.close();
        if (oldTables.size() == 0) {
            this.m_out.println("NONE");
            return;
        }
        throw new BackupTablesFoundException(oldTables);
    }

    public List<Constraint> getForeignKeyConstraints() throws Exception {
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        for (String table : this.getTableNames()) {
            String tableLower = table.toLowerCase();
            for (Constraint constraint : this.getTableFromSQL(tableLower).getConstraints()) {
                if (constraint.getType() != 2) continue;
                constraints.add(constraint);
            }
        }
        return constraints;
    }

    public void checkConstraints() throws Exception {
        List<Constraint> constraints = this.getForeignKeyConstraints();
        this.m_out.println("- checking for rows that violate constraints...");
        for (Constraint constraint : constraints) {
            this.m_out.print("  - checking for rows that violate constraint '" + constraint.getName() + "'... ");
            this.checkConstraint(constraint);
            this.m_out.println("DONE");
        }
        this.m_out.println("- checking for rows that violate constraints... DONE");
    }

    public void checkConstraint(Constraint constraint) throws Exception {
        ResultSet rs;
        String name = constraint.getName();
        String table = constraint.getTable();
        List<String> columns = constraint.getColumns();
        String ftable = constraint.getForeignTable();
        List<String> fcolumns = constraint.getForeignColumns();
        if (!this.tableExists(table)) {
            return;
        }
        for (String column : columns) {
            if (this.tableColumnExists(table, column)) continue;
            return;
        }
        String partialQuery = this.getJoinForRowsThatFailConstraint(table, columns, ftable, fcolumns);
        Statement st = this.getConnection().createStatement();
        String query = "SELECT count(*) " + partialQuery;
        try {
            rs = st.executeQuery(query);
        }
        catch (SQLException e) {
            throw new Exception("Failed to execute query '" + query + "'.  " + "Nested exception: " + e.getMessage(), e);
        }
        rs.next();
        int count = rs.getInt(1);
        rs.close();
        if (count != 0) {
            rs = st.executeQuery("SELECT count(*) FROM " + table);
            rs.next();
            int total = rs.getInt(1);
            rs.close();
            st.close();
            throw new Exception("Table " + table + " contains " + count + " rows " + "(out of " + total + ") that violate new constraint " + name + ".  " + "See the install guide for details " + "on how to correct this problem.  You can execute this " + "SQL query to see a list of the rows that violate the " + "constraint:\n" + "SELECT * " + partialQuery);
        }
        st.close();
    }

    private String getJoinForRowsThatFailConstraint(String table, List<String> columns, String ftable, List<String> fcolumns) throws Exception {
        String notNulls = this.notNullWhereClause(table, columns);
        String noForeign = "FROM " + table + " WHERE " + notNulls;
        if (!this.tableExists(ftable)) {
            return noForeign;
        }
        for (String fcolumn : fcolumns) {
            if (this.tableColumnExists(ftable, fcolumn)) continue;
            return noForeign;
        }
        String partialQuery = "FROM " + table + " LEFT JOIN " + ftable + " ON (";
        for (int i = 0; i < columns.size(); ++i) {
            String column = columns.get(i);
            String fcolumn = fcolumns.get(i);
            if (i != 0) {
                partialQuery = partialQuery + " AND ";
            }
            partialQuery = partialQuery + table + '.' + column + " = " + ftable + '.' + fcolumn;
        }
        partialQuery = partialQuery + ") WHERE " + ftable + '.' + fcolumns.get(0) + " is NULL AND " + notNulls;
        return partialQuery;
    }

    public String getForeignConstraintWhere(String table, List<String> columns, String ftable, List<String> fcolumns) throws Exception {
        String notNulls = this.notNullWhereClause(table, columns);
        if (!this.tableExists(ftable)) {
            return notNulls;
        }
        for (String fcolumn : fcolumns) {
            if (this.tableColumnExists(ftable, fcolumn)) continue;
            return notNulls;
        }
        return notNulls + " AND ( " + StringUtils.collectionToDelimitedString(this.tableColumnList(table, columns), (String)", ") + " ) NOT IN (SELECT " + StringUtils.collectionToDelimitedString(this.tableColumnList(ftable, fcolumns), (String)", ") + " FROM " + ftable + ")";
    }

    public String notNullWhereClause(String table, List<String> columns) {
        ArrayList<String> isNotNulls = new ArrayList<String>(columns.size());
        for (String column : columns) {
            isNotNulls.add(table + "." + column + " IS NOT NULL");
        }
        return StringUtils.collectionToDelimitedString(isNotNulls, (String)" AND ");
    }

    public List<String> tableColumnList(String table, List<String> columns) {
        ArrayList<String> tableColumns = new ArrayList<String>(columns.size());
        for (String column : columns) {
            tableColumns.add(table + "." + column);
        }
        return tableColumns;
    }

    public void fixConstraint(String constraintName, boolean removeRows) throws Exception {
        List<Constraint> constraints = this.getForeignKeyConstraints();
        this.m_out.print("- fixing rows that violate constraint " + constraintName + "... ");
        for (Constraint c : constraints) {
            if (!constraintName.equals(c.getName())) continue;
            this.m_out.println(this.fixConstraint(c, removeRows));
            return;
        }
        throw new Exception("Did not find constraint " + constraintName + " in the database.");
    }

    public String fixConstraint(Constraint constraint, boolean removeRows) throws Exception {
        String change_text;
        String query;
        String table = constraint.getTable();
        List<String> columns = constraint.getColumns();
        String ftable = constraint.getForeignTable();
        List<String> fcolumns = constraint.getForeignColumns();
        if (!this.tableExists(table)) {
            throw new Exception("Constraint " + constraint.getName() + " is on table " + table + ", but table does " + "not exist (so fixing this constraint does " + "nothing).");
        }
        for (String column : columns) {
            if (this.tableColumnExists(table, column)) continue;
            throw new Exception("Constraint " + constraint.getName() + " constrains column " + column + " of table " + table + ", but column does " + "not exist (so fixing this constraint " + "does nothing).");
        }
        String tuple = "";
        for (int i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                tuple = tuple + ", ";
            }
            tuple = tuple + table + '.' + columns.get(i);
        }
        String where = "( " + tuple + ") IN ( SELECT " + tuple + " " + this.getJoinForRowsThatFailConstraint(table, columns, ftable, fcolumns) + ")";
        if (removeRows) {
            query = "DELETE FROM " + table + " WHERE " + where;
            change_text = "DELETED";
        } else {
            ArrayList<String> sets = new ArrayList<String>(columns.size());
            for (String column : columns) {
                sets.add(column + " = NULL");
            }
            query = "UPDATE " + table + " SET " + StringUtils.collectionToDelimitedString(sets, (String)", ") + " " + "WHERE " + where;
            change_text = "UPDATED";
        }
        Statement st = this.getConnection().createStatement();
        int num = st.executeUpdate(query);
        return change_text + " " + num + (num == 1 ? " ROW" : " ROWS");
    }

    public boolean databaseUserExists() throws SQLException {
        this.assertUserSet();
        Statement st = this.getAdminConnection().createStatement();
        ResultSet rs = st.executeQuery("SELECT usename FROM pg_user WHERE usename = '" + this.m_user + "'");
        boolean exists = rs.next();
        rs.close();
        st.close();
        return exists;
    }

    public void databaseSetUser() throws SQLException {
        ResultSet rs = this.getAdminConnection().getMetaData().getTables(null, "public", "%", null);
        HashSet<String> objects = new HashSet<String>();
        while (rs.next()) {
            objects.add(rs.getString("TABLE_NAME"));
        }
        PreparedStatement st = this.getAdminConnection().prepareStatement("ALTER TABLE ? OWNER TO ?");
        for (String objName : objects) {
            st.setString(1, objName);
            st.setString(2, this.m_user);
            st.execute();
        }
        st.close();
    }

    @Deprecated
    public void databaseAddUser() throws SQLException {
        this.assertUserSet();
        Statement st = this.getAdminConnection().createStatement();
        st.execute("CREATE USER " + this.m_user + " WITH PASSWORD '" + this.m_pass + "' CREATEDB CREATEUSER");
    }

    public boolean databaseDBExists() throws SQLException {
        Statement st = this.getAdminConnection().createStatement();
        ResultSet rs = st.executeQuery("SELECT datname from pg_database WHERE datname = '" + this.m_databaseName + "'");
        boolean exists = rs.next();
        rs.close();
        st.close();
        return exists;
    }

    @Deprecated
    public void databaseAddDB() throws Exception {
        this.assertUserSet();
        this.m_out.print("- creating database '" + this.m_databaseName + "'... ");
        Statement st = this.getAdminConnection().createStatement();
        st.execute("CREATE DATABASE \"" + this.m_databaseName + "\" WITH ENCODING='UNICODE'");
        st.execute("GRANT ALL ON DATABASE \"" + this.m_databaseName + "\" TO \"" + this.m_user + "\"");
        st.close();
        this.m_out.print("DONE");
    }

    public void databaseRemoveDB() throws SQLException {
        this.assertUserSet();
        this.m_out.print("- removing database '" + this.m_databaseName + "'... ");
        Statement st = this.getAdminConnection().createStatement();
        st.execute("DROP DATABASE \"" + this.m_databaseName + "\"");
        st.close();
        this.m_out.print("DONE");
    }

    public void addIndexesForTable(String table) throws SQLException {
        List<Index> indexes = this.getIndexDao().getIndexesForTable(table.toLowerCase());
        for (Index index : indexes) {
            this.m_out.print("    - checking index '" + index.getName() + "' on this table... ");
            if (!index.isOnDatabase(this.getConnection())) {
                index.addToDatabase(this.getConnection());
            }
            this.m_out.println("DONE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantAccessToObject(String object, int indent) throws SQLException {
        this.assertUserSet();
        for (int i = 0; i < indent; ++i) {
            this.m_out.print(" ");
        }
        this.m_out.print("- granting access to '" + object + "' for user '" + this.m_user + "'... ");
        Statement st = this.getConnection().createStatement();
        try {
            st.execute("GRANT ALL ON " + object + " TO " + this.m_user);
        }
        finally {
            st.close();
        }
        this.m_out.println("DONE");
    }

    public void fixData() throws Exception {
        Statement st = this.getConnection().createStatement();
        st.execute("UPDATE ipinterface SET issnmpprimary='N' WHERE issnmpprimary IS NULL");
        st.execute("UPDATE service SET servicename='SSH' WHERE servicename='OpenSSH'");
        st.execute("UPDATE snmpinterface SET snmpipadentnetmask=NULL");
    }

    public void insertData() throws Exception {
        for (String table : this.getInserts().keySet()) {
            Status status = Status.OK;
            this.m_out.print("- inserting initial table data for \"" + table + "\"... ");
            LinkedList<Insert> toBeInserted = new LinkedList<Insert>();
            for (Insert insert : this.getInserts().get(table)) {
                if (!insert.isCriteriaMet()) continue;
                toBeInserted.add(insert);
            }
            for (Insert insert : toBeInserted) {
                status = status.combine(insert.doInsert());
            }
            this.m_out.println((Object)status);
        }
    }

    public void checkUnicode() throws Exception {
        this.assertUserSet();
        this.m_out.print("- checking if database \"" + this.m_databaseName + "\" is unicode... ");
        Statement st = null;
        ResultSet rs = null;
        try {
            try {
                st = this.getAdminConnection().createStatement();
                try {
                    rs = st.executeQuery("SELECT encoding FROM pg_database WHERE LOWER(datname)='" + this.m_databaseName.toLowerCase() + "'");
                    if (rs.next() && (rs.getInt(1) == 5 || rs.getInt(1) == 6)) {
                        this.m_out.println("ALREADY UNICODE");
                        return;
                    }
                    this.m_out.println("NOT UNICODE");
                    throw new Exception("OpenNMS requires a Unicode database.  Please delete and recreate your\ndatabase and try again.");
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        finally {
            this.disconnect();
        }
    }

    public void checkIndexUniqueness() throws Exception {
        Collection<Index> indexes = this.getIndexDao().getAllIndexes();
        Statement st = this.getConnection().createStatement();
        for (Index index : indexes) {
            String query;
            if (!index.isUnique() || !this.tableExists(index.getTable())) continue;
            boolean missingColumn = false;
            for (String column : index.getColumns()) {
                if (this.tableColumnExists(index.getTable(), column)) continue;
                missingColumn = true;
            }
            if (missingColumn || (query = index.getIndexUniquenessQuery()) == null) continue;
            String countQuery = query.replaceFirst("(?i)\\s(\\S+)\\s+FROM", " count(\\1) FROM").replaceFirst("(?i)\\s*ORDER\\s+BY\\s+[^()]+$", "");
            ResultSet rs = st.executeQuery(countQuery);
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            if (count <= 0) continue;
            st.close();
            throw new Exception("Unique index '" + index.getName() + "' " + "cannot be added to table '" + index.getTable() + "' because " + count + " rows are not unique.  See the " + "install guide for details on how to " + "correct this problem.  You can use the " + "following SQL to see which rows are not " + "unique:\n" + query);
        }
        st.close();
    }

    public List<Column> getTableColumnsFromSQL(String tableName) throws Exception {
        return this.getTableFromSQL(tableName).getColumns();
    }

    public String getTableCreateFromSQL(String table) throws Exception {
        return this.getXFromSQL(table, "(?i)\\bcreate table\\s+['\"]?(\\S+)['\"]?\\s+\\((.+?)\\);", 1, 2, "table");
    }

    public String getIndexFromSQL(String index) throws Exception {
        return this.getXFromSQL(index, "(?i)\\b(create (?:unique )?index\\s+['\"]?(\\S+)['\"]?\\s+.+?);", 2, 1, "index");
    }

    public String getFunctionFromSQL(String function) throws Exception {
        return this.getXFromSQL(function, "(?is)\\bcreate function\\s+['\"]?(\\S+)['\"]?\\s+(.+? language ['\"]?\\w+['\"]?);", 1, 2, "function");
    }

    public String getLanguageFromSQL(String language) throws Exception {
        return this.getXFromSQL(language, "(?is)\\bcreate trusted procedural language\\s+['\"]?(\\S+)['\"]?\\s+(.+?);", 1, 2, "language");
    }

    private void assertUserSet() {
        Assert.state((this.m_user != null ? 1 : 0) != 0, (String)"postgresOpennmsUser property has not been set");
    }

    private Connection getConnection() throws SQLException {
        if (this.m_connection == null) {
            this.initializeConnection();
        }
        return this.m_connection;
    }

    private void initializeConnection() throws SQLException {
        Assert.state((this.m_dataSource != null ? 1 : 0) != 0, (String)"dataSource property has not been set");
        try {
            this.m_connection = this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            this.rethrowDatabaseConnectionException(this.getDataSource(), e, "Could not get a connection to the OpenNMS database.");
        }
    }

    public void closeConnection() throws SQLException {
        if (this.m_connection == null) {
            return;
        }
        this.m_connection.close();
        this.m_connection = null;
    }

    private Connection getAdminConnection() throws SQLException {
        if (this.m_adminConnection == null) {
            this.initializeAdminConnection();
        }
        return this.m_adminConnection;
    }

    private void initializeAdminConnection() throws SQLException {
        Assert.state((this.m_adminDataSource != null ? 1 : 0) != 0, (String)"adminDataSource property has not been set");
        try {
            this.m_adminConnection = this.getAdminDataSource().getConnection();
        }
        catch (SQLException e) {
            this.rethrowDatabaseConnectionException(this.getAdminDataSource(), e, "Could not get an administrative connection to the database.");
        }
    }

    public void closeAdminConnection() throws SQLException {
        if (this.m_adminConnection == null) {
            return;
        }
        this.m_adminConnection.close();
        this.m_adminConnection = null;
    }

    public void disconnect() throws SQLException {
        this.closeColumnReplacements();
        this.closeConnection();
        this.closeAdminConnection();
    }

    private void rethrowDatabaseConnectionException(DataSource ds, SQLException e, String msg) throws SQLException {
        SQLException newE = new SQLException(msg + "  Is the database running, listening for TCP connections, and allowing us to connect and authenticate from localhost?  Tried connecting to database specified by data source " + ds.toString() + ".  Original error: " + e);
        newE.initCause(e);
        throw newE;
    }

    public void setCreateSqlLocation(String createSqlLocation) {
        this.m_createSqlLocation = createSqlLocation;
    }

    public String getCreateSqlLocation() {
        return this.m_createSqlLocation;
    }

    public List<String> getTableNames() {
        return this.m_tables;
    }

    public List<String> getSequenceNames() {
        return this.m_sequences;
    }

    public String[] getSequenceMapping(String sequence) {
        return this.m_seqmapping.get(sequence);
    }

    public IndexDao getIndexDao() {
        return this.m_indexDao;
    }

    public Map<String, List<Insert>> getInserts() {
        return this.m_inserts;
    }

    public String getSql() {
        return this.m_sql;
    }

    public boolean hasTableChanged(String table) {
        return this.m_changed.contains(table);
    }

    public void tableChanged(String table) {
        this.m_changed.add(table);
    }

    public void setOutputStream(PrintStream out) {
        this.m_out = out;
    }

    public TriggerDao getTriggerDao() {
        return this.m_triggerDao;
    }

    public void setStoredProcedureDirectory(String directory) {
        this.m_storedProcedureDirectory = directory;
    }

    public String getStoredProcedureDirectory() {
        return this.m_storedProcedureDirectory;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setAdminDataSource(DataSource dataSource) {
        this.m_adminDataSource = dataSource;
    }

    public DataSource getAdminDataSource() {
        return this.m_adminDataSource;
    }

    public void setForce(boolean force) {
        this.m_force = force;
    }

    public boolean getForce() {
        return this.m_force;
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    public void addColumnReplacement(String tableColumn, ColumnChangeReplacement replacement) {
        this.m_columnReplacements.put(tableColumn, replacement);
    }

    public void setIgnoreNotNull(boolean ignoreNotNull) {
        this.m_ignore_notnull = ignoreNotNull;
    }

    public String getDatabaseName() {
        return this.m_databaseName;
    }

    public void setDatabaseName(String name) {
        this.m_databaseName = name;
    }

    public void setNoRevert(boolean noRevert) {
        this.m_no_revert = noRevert;
    }

    public void setPostgresOpennmsUser(String user) {
        this.m_user = user;
    }

    public String getPostgresOpennmsUser() {
        return this.m_user;
    }

    public void setPostgresOpennmsPassword(String password) {
        this.m_pass = password;
    }

    public String getPostgresOpennmsPassword() {
        return this.m_pass;
    }

    public void setPostgresIpLikeLocation(String location) {
        File iplike;
        if (location != null && !(iplike = new File(location)).exists()) {
            this.m_out.println("WARNING: missing " + location + ": OpenNMS will use a slower stored procedure if the native library is not available");
        }
        this.m_pg_iplike = location;
    }

    public String getPgIpLikeLocation() {
        return this.m_pg_iplike;
    }

    public void setPostgresPlPgsqlLocation(String location) {
        File plpgsql;
        if (location != null && !(plpgsql = new File(location)).exists()) {
            this.m_out.println("FATAL: missing " + location + ": Unable to set up even the slower IPLIKE stored procedure without PL/PGSQL language support");
        }
        this.m_pg_plpgsql = location;
    }

    public String getPgPlPgsqlLocation() {
        return this.m_pg_plpgsql;
    }

    public boolean isPgPlPgsqlLibPresent() {
        if (this.m_pg_plpgsql == null) {
            return false;
        }
        File plpgsqlLib = new File(this.m_pg_plpgsql);
        return plpgsqlLib.exists() && plpgsqlLib.canRead();
    }

    public void addColumnReplacements() throws SQLException {
        this.addColumnReplacement("snmpinterface.id", new DoNotAddColumnReplacement());
        this.addColumnReplacement("ipinterface.id", new DoNotAddColumnReplacement());
        this.addColumnReplacement("ifservices.id", new DoNotAddColumnReplacement());
        this.addColumnReplacement("acks.id", new DoNotAddColumnReplacement());
        this.addColumnReplacement("assets.id", new DoNotAddColumnReplacement());
        this.addColumnReplacement("atinterface.id", new DoNotAddColumnReplacement());
        this.addColumnReplacement("datalinkinterface.id", new DoNotAddColumnReplacement());
        this.addColumnReplacement("element.id", new DoNotAddColumnReplacement());
        this.addColumnReplacement("ipinterface.snmpinterfaceid", new DoNotAddColumnReplacement());
        this.addColumnReplacement("ifservices.ipinterfaceid", new DoNotAddColumnReplacement());
        this.addColumnReplacement("outages.ifserviceid", new DoNotAddColumnReplacement());
        this.addColumnReplacement("events.eventsource", new EventSourceReplacement());
        this.addColumnReplacement("outages.outageid", new AutoIntegerReplacement(1));
        this.addColumnReplacement("snmpinterface.nodeid", new RowHasBogusDataReplacement("snmpInterface", "nodeId"));
        this.addColumnReplacement("snmpinterface.snmpifindex", new RowHasBogusDataReplacement("snmpInterface", "snmpIfIndex"));
        this.addColumnReplacement("ipinterface.nodeid", new RowHasBogusDataReplacement("ipInterface", "nodeId"));
        this.addColumnReplacement("ipinterface.ipaddr", new RowHasBogusDataReplacement("ipInterface", "ipAddr"));
        this.addColumnReplacement("ifservices.nodeid", new RowHasBogusDataReplacement("ifservices", "nodeId"));
        this.addColumnReplacement("ifservices.ipaddr", new RowHasBogusDataReplacement("ifservices", "ipaddr"));
        this.addColumnReplacement("ifservices.serviceid", new RowHasBogusDataReplacement("ifservices", "serviceId"));
        this.addColumnReplacement("outages.nodeid", new RowHasBogusDataReplacement("outages", "nodeId"));
        this.addColumnReplacement("outages.serviceid", new RowHasBogusDataReplacement("outages", "serviceId"));
        this.addColumnReplacement("usersnotified.id", new NextValReplacement("userNotifNxtId", this.getDataSource()));
        this.addColumnReplacement("alarms.x733probablecause", new FixedIntegerReplacement(0));
        this.addColumnReplacement("alarms.alarmid", new NextValReplacement("alarmsNxtId", this.getDataSource()));
    }

    public void closeColumnReplacements() throws SQLException {
        for (ColumnChangeReplacement r : this.m_columnReplacements.values()) {
            r.close();
        }
    }

    public void vacuumDatabase(boolean full) throws SQLException {
        Statement st = this.getConnection().createStatement();
        this.m_out.print("- optimizing database (VACUUM ANALYZE)... ");
        st.execute("VACUUM ANALYZE");
        this.m_out.println("OK");
        if (full) {
            this.m_out.print("- recovering database disk space (VACUUM FULL)... ");
            st.execute("VACUUM FULL");
            this.m_out.println("OK");
        }
    }

    public class Insert {
        private final String m_table;
        private final String m_insertStatement;
        private final String m_criteria;

        public Insert(String table, String line, String criteria) {
            this.m_table = table;
            this.m_insertStatement = line;
            this.m_criteria = criteria;
        }

        public String getTable() {
            return this.m_table;
        }

        public String getCriteria() {
            return this.m_criteria;
        }

        public String getInsertStatement() {
            return this.m_insertStatement;
        }

        Status execute() throws SQLException {
            if (this.isCriteriaMet()) {
                return this.doInsert();
            }
            return Status.SKIPPED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isCriteriaMet() throws SQLException {
            if (this.getCriteria() == null) {
                return true;
            }
            Statement st = null;
            try {
                boolean bl;
                block13: {
                    ResultSet rs;
                    block11: {
                        boolean bl2;
                        block12: {
                            st = InstallerDb.this.getConnection().createStatement();
                            rs = null;
                            try {
                                rs = st.executeQuery(this.getCriteria());
                                if (!rs.next()) break block11;
                                bl2 = rs.getBoolean(1);
                                if (rs == null) break block12;
                            }
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    rs.close();
                                }
                                throw throwable;
                            }
                            rs.close();
                        }
                        return bl2;
                    }
                    bl = false;
                    if (rs == null) break block13;
                    rs.close();
                }
                return bl;
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }

        private Status doInsert() throws SQLException {
            Statement st = null;
            try {
                st = InstallerDb.this.getConnection().createStatement();
                st.execute(this.getInsertStatement());
            }
            catch (SQLException e) {
                if (e.toString().indexOf("duplicate key") != -1 || "23505".equals(e.getSQLState())) {
                    Status status = Status.EXISTS;
                    return status;
                }
                throw e;
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
            return Status.OK;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        OK,
        SKIPPED,
        EXISTS;


        Status combine(Status s) {
            if (this.ordinal() > s.ordinal()) {
                return this;
            }
            return s;
        }
    }
}

