/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.LinkedList;
import java.util.List;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionAwareEventForwarder
implements EventForwarder,
InitializingBean {
    private EventForwarder m_eventForwarder;

    public TransactionAwareEventForwarder() {
    }

    public TransactionAwareEventForwarder(EventForwarder forwarder) throws Exception {
        this.setEventForwarder(forwarder);
        this.afterPropertiesSet();
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_eventForwarder != null ? 1 : 0) != 0, (String)"eventForwarder property must be set");
    }

    public void sendNow(Event event) {
        Log eventLog = new Log();
        Events events = new Events();
        eventLog.setEvents(events);
        events.addEvent(event);
        this.sendNow(eventLog);
    }

    public void sendNow(Log eventLog) {
        List<Log> pendingEvents = this.requestPendingEventsList();
        pendingEvents.add(eventLog);
        this.releasePendingEventsList(pendingEvents);
    }

    public List<Log> requestPendingEventsList() {
        PendingEventsHolder eventsHolder = (PendingEventsHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.m_eventForwarder));
        if (eventsHolder != null && (eventsHolder.hasPendingEvents() || eventsHolder.isSynchronizedWithTransaction())) {
            eventsHolder.requested();
            if (!eventsHolder.hasPendingEvents()) {
                eventsHolder.setPendingEventsList(new LinkedList<Log>());
            }
            return eventsHolder.getPendingEvents();
        }
        LinkedList<Log> pendingEvents = new LinkedList<Log>();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            PendingEventsHolder holderToUse = eventsHolder;
            if (holderToUse == null) {
                holderToUse = new PendingEventsHolder(pendingEvents);
            } else {
                holderToUse.setPendingEventsList(pendingEvents);
            }
            holderToUse.requested();
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new PendingEventsSynchronization(holderToUse, this.m_eventForwarder));
            holderToUse.setSynchronizedWithTransaction(true);
            if (holderToUse != eventsHolder) {
                TransactionSynchronizationManager.bindResource((Object)this.m_eventForwarder, (Object)((Object)holderToUse));
            }
        }
        return pendingEvents;
    }

    public void releasePendingEventsList(List<Log> pendingEvents) {
        if (pendingEvents == null) {
            return;
        }
        PendingEventsHolder eventsHolder = (PendingEventsHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.m_eventForwarder));
        if (eventsHolder != null && this.eventHolderHolds(eventsHolder, pendingEvents)) {
            eventsHolder.released();
        } else {
            for (Log log : pendingEvents) {
                this.m_eventForwarder.sendNow(log);
            }
        }
    }

    private boolean eventHolderHolds(PendingEventsHolder eventsHolder, List<Log> passedInEvents) {
        if (!eventsHolder.hasPendingEvents()) {
            return false;
        }
        return eventsHolder.getPendingEvents() == passedInEvents;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PendingEventsHolder
    extends ResourceHolderSupport {
        private List<Log> m_pendingEvents = null;

        public PendingEventsHolder(List<Log> pendingEvents) {
            this.m_pendingEvents = pendingEvents;
        }

        public synchronized List<Log> consumePendingEvents() {
            List<Log> pendingEvents = this.m_pendingEvents;
            this.m_pendingEvents = null;
            return pendingEvents;
        }

        public List<Log> getPendingEvents() {
            return this.m_pendingEvents;
        }

        public void clear() {
            this.m_pendingEvents = null;
        }

        public boolean hasPendingEvents() {
            return this.m_pendingEvents != null;
        }

        public void setPendingEventsList(List<Log> pendingEvents) {
            this.m_pendingEvents = pendingEvents;
        }
    }

    public static class PendingEventsSynchronization
    extends TransactionSynchronizationAdapter {
        private PendingEventsHolder m_eventsHolder;
        private EventForwarder m_eventForwarder;

        public PendingEventsSynchronization(PendingEventsHolder eventsHolder, EventForwarder eventForwarder) {
            this.m_eventsHolder = eventsHolder;
            this.m_eventForwarder = eventForwarder;
        }

        public void afterCommit() {
            if (!this.m_eventsHolder.hasPendingEvents()) {
                return;
            }
            List<Log> pendingEvents = this.m_eventsHolder.consumePendingEvents();
            for (Log events : pendingEvents) {
                this.m_eventForwarder.sendNow(events);
            }
        }

        public void afterCompletion(int status) {
            if (TransactionSynchronizationManager.hasResource((Object)this.m_eventForwarder)) {
                TransactionSynchronizationManager.unbindResource((Object)this.m_eventForwarder);
            }
        }
    }
}

