/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.config.datacollection.DatacollectionConfig;
import org.opennms.netmgt.config.datacollection.Group;
import org.opennms.netmgt.config.datacollection.Groups;
import org.opennms.netmgt.config.datacollection.MibObj;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.SnmpCollection;
import org.opennms.netmgt.config.datacollection.SystemDef;
import org.opennms.netmgt.config.datacollection.SystemDefChoice;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.model.RrdRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataCollectionConfigFactory
implements DataCollectionConfig {
    private static final Pattern s_digitsPattern = Pattern.compile("\\d+");
    private static DataCollectionConfig m_singleton = null;
    private DatacollectionConfig m_config;
    private static boolean m_loaded = false;
    private Map<String, Map<String, Group>> m_collectionGroupMap;
    private Map<String, SnmpCollection> m_collectionMap;
    private Map<String, ResourceType> m_configuredResourceTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataCollectionConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream stream = new FileInputStream(configFile);
        try {
            this.m_config = CastorUtils.unmarshal(DatacollectionConfig.class, stream);
            this.setUpFactory();
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    @Deprecated
    public DataCollectionConfigFactory(Reader rdr) throws MarshalException, ValidationException {
        this.m_config = CastorUtils.unmarshal(DatacollectionConfig.class, rdr);
        this.setUpFactory();
    }

    public DataCollectionConfigFactory(InputStream stream) throws MarshalException, ValidationException {
        this.m_config = CastorUtils.unmarshal(DatacollectionConfig.class, stream);
        this.setUpFactory();
    }

    protected void setUpFactory() {
        this.buildCollectionMap();
        this.processConfiguredResourceTypes();
        this.validateResourceTypes();
    }

    @Override
    public Map<String, ResourceType> getConfiguredResourceTypes() {
        return this.m_configuredResourceTypes;
    }

    public void processConfiguredResourceTypes() {
        HashMap<String, ResourceType> map = new HashMap<String, ResourceType>();
        List<SnmpCollection> snmpCollections = this.getSnmpCollections();
        for (SnmpCollection collection : snmpCollections) {
            List<ResourceType> resourceTypes = this.getResourceTypesForCollection(collection);
            for (ResourceType resourceType : resourceTypes) {
                map.put(resourceType.getName(), resourceType);
            }
        }
        this.m_configuredResourceTypes = map;
    }

    private List<ResourceType> getResourceTypesForCollection(SnmpCollection collection) {
        return collection.getResourceTypeCollection();
    }

    private List<SnmpCollection> getSnmpCollections() {
        return this.m_config.getSnmpCollectionCollection();
    }

    private static String join(String separator, Collection<String> collection) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            buffer.append(iterator.next());
        }
        while (iterator.hasNext()) {
            buffer.append(separator);
            buffer.append(iterator.next());
        }
        return buffer.toString();
    }

    private void validateResourceTypes() {
        Set<String> allowedResourceTypes = this.getConfiguredResourceTypes().keySet();
        String configuredString = allowedResourceTypes.size() == 0 ? "(none)" : DataCollectionConfigFactory.join(", ", allowedResourceTypes);
        String allowableValues = "any positive number, 'ifIndex', or any of the configured resourceTypes: " + configuredString;
        List<SnmpCollection> snmpCollections = this.getSnmpCollections();
        for (SnmpCollection collection : snmpCollections) {
            List<Group> groups = this.getGroupsForCollection(collection);
            for (Group group : groups) {
                List<MibObj> mibObjs = this.getMibObjsForGroup(group);
                for (MibObj mibObj : mibObjs) {
                    String instance = mibObj.getInstance();
                    if (instance == null || s_digitsPattern.matcher(instance).matches() || "ifIndex".equals(instance) || allowedResourceTypes.contains(instance)) continue;
                    throw new IllegalArgumentException("instance '" + instance + "' invalid in mibObj definition for OID '" + mibObj.getOid() + "' in collection '" + collection.getName() + "' for group '" + group.getName() + "'.  Allowable instance values: " + allowableValues);
                }
            }
        }
    }

    private List<MibObj> getMibObjsForGroup(Group group) {
        return group.getMibObjCollection();
    }

    private List<Group> getGroupsForCollection(SnmpCollection collection) {
        return collection.getGroups().getGroupCollection();
    }

    public static void setInstance(DataCollectionConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DATA_COLLECTION_CONF_FILE_NAME);
        ThreadCategory.getInstance(DataCollectionConfigFactory.class).debug("init: config file path: " + cfgFile.getPath());
        m_singleton = new DataCollectionConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        DataCollectionConfigFactory.init();
    }

    public static synchronized DataCollectionConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    @Override
    public List<MibObject> getMibObjectList(String cName, String aSysoid, String anAddress, int ifType) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("getMibObjectList: collection: " + cName + " sysoid: " + aSysoid + " address: " + anAddress + " ifType: " + ifType);
        }
        if (aSysoid == null) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("getMibObjectList: aSysoid parameter is NULL...");
            }
            return new ArrayList<MibObject>();
        }
        SnmpCollection collection = this.m_collectionMap.get(cName);
        if (collection == null) {
            return new ArrayList<MibObject>();
        }
        ArrayList<SystemDef> systemList = new ArrayList<SystemDef>();
        Enumeration e = collection.getSystems().enumerateSystemDef();
        SystemDef system2 = null;
        while (e.hasMoreElements()) {
            system2 = (SystemDef)e.nextElement();
            boolean bMatchSysoid = false;
            boolean isMask = false;
            String currSysoid = null;
            SystemDefChoice sysChoice = system2.getSystemDefChoice();
            if (sysChoice.getSysoid() != null) {
                currSysoid = sysChoice.getSysoid();
            } else if (sysChoice.getSysoidMask() != null) {
                currSysoid = sysChoice.getSysoidMask();
                isMask = true;
            }
            if (currSysoid != null) {
                if (isMask) {
                    if (aSysoid.startsWith(currSysoid)) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("getMibObjectList: includes sysoid " + aSysoid + " for system <name>: " + system2.getName());
                        }
                        bMatchSysoid = true;
                    }
                } else if (aSysoid.equals(currSysoid)) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("getMibObjectList: includes sysoid " + aSysoid + " for system <name>: " + system2.getName());
                    }
                    bMatchSysoid = true;
                }
            }
            boolean bMatchIPAddress = true;
            if (bMatchSysoid && anAddress != null) {
                List addrList = null;
                List maskList = null;
                if (system2.getIpList() != null) {
                    addrList = system2.getIpList().getIpAddrCollection();
                    maskList = system2.getIpList().getIpAddrMaskCollection();
                }
                if (addrList != null && addrList.size() > 0 || maskList != null && maskList.size() > 0) {
                    bMatchIPAddress = false;
                }
                if (addrList != null && addrList.size() > 0 && addrList.contains(anAddress)) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("getMibObjectList: addrList exists and does include IP address " + anAddress + " for system <name>: " + system2.getName());
                    }
                    bMatchIPAddress = true;
                }
                if (!bMatchIPAddress && maskList != null && maskList.size() > 0) {
                    for (String currMask : maskList) {
                        if (anAddress.indexOf(currMask) != 0) continue;
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("getMibObjectList: anAddress '" + anAddress + "' matches mask '" + currMask + "'");
                        }
                        bMatchIPAddress = true;
                        break;
                    }
                }
            }
            if (!bMatchSysoid || !bMatchIPAddress) continue;
            if (this.log().isDebugEnabled()) {
                this.log().debug("getMibObjectList: MATCH!! adding system '" + system2.getName() + "'");
            }
            systemList.add(system2);
        }
        ArrayList<MibObject> mibObjectList = new ArrayList<MibObject>();
        for (SystemDef system2 : systemList) {
            List groupList = system2.getCollect().getIncludeGroupCollection();
            for (String grpName : groupList) {
                this.processGroupName(cName, grpName, ifType, mibObjectList);
            }
        }
        return mibObjectList;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void processGroupName(String cName, String groupName, int ifType, List<MibObject> mibObjectList) {
        ThreadCategory log = this.log();
        Map<String, Group> groupMap = this.m_collectionGroupMap.get(cName);
        Group group = groupMap.get(groupName);
        if (group == null) {
            log.warn("DataCollectionConfigFactory.processGroupName: unable to retrieve group information for group name '" + groupName + "': check DataCollection.xml file.");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("processGroupName:  processing group: " + groupName + " groupIfType: " + group.getIfType() + " ifType: " + ifType);
        }
        List groupNameList = group.getIncludeGroupCollection();
        Iterator i = groupNameList.iterator();
        while (i.hasNext()) {
            this.processGroupName(cName, (String)i.next(), ifType, mibObjectList);
        }
        String ifTypeStr = String.valueOf(ifType);
        String groupIfType = group.getIfType();
        boolean addGroupObjects = false;
        if (ifType == -1) {
            if (groupIfType.equals("ignore")) {
                addGroupObjects = true;
            }
        } else if (groupIfType.equals("all")) {
            addGroupObjects = true;
        } else if (!groupIfType.equals("ignore")) {
            if (ifType == -2) {
                addGroupObjects = true;
            } else {
                boolean isList = false;
                if (groupIfType.indexOf(44) != -1) {
                    isList = true;
                }
                if (!isList) {
                    if (ifTypeStr.equals(groupIfType)) {
                        addGroupObjects = true;
                    }
                } else {
                    int tmpIndex = groupIfType.indexOf(ifTypeStr);
                    while (tmpIndex != -1) {
                        groupIfType = groupIfType.substring(tmpIndex);
                        int nextComma = groupIfType.indexOf(44);
                        String parsedType = null;
                        parsedType = nextComma == -1 ? groupIfType : groupIfType.substring(0, nextComma);
                        if (ifTypeStr.equals(parsedType)) {
                            addGroupObjects = true;
                            break;
                        }
                        if (nextComma == -1) break;
                        groupIfType = groupIfType.substring(nextComma + 1);
                        tmpIndex = groupIfType.indexOf(ifTypeStr);
                    }
                }
            }
        }
        if (addGroupObjects) {
            if (log.isDebugEnabled()) {
                log.debug("processGroupName: OIDs from group '" + group.getName() + ":" + group.getIfType() + "' are included for ifType: " + ifType);
            }
            List objectList = group.getMibObjCollection();
            this.processObjectList(groupName, groupIfType, objectList, mibObjectList);
        } else if (log.isDebugEnabled()) {
            log.debug("processGroupName: OIDs from group '" + group.getName() + ":" + group.getIfType() + "' are excluded for ifType: " + ifType);
        }
    }

    private void processObjectList(String groupName, String groupIfType, List<MibObj> objectList, List<MibObject> mibObjectList) {
        for (MibObj mibObj : objectList) {
            MibObject aMibObject = new MibObject();
            aMibObject.setGroupName(groupName);
            aMibObject.setGroupIfType(groupIfType);
            aMibObject.setOid(mibObj.getOid());
            aMibObject.setAlias(mibObj.getAlias());
            aMibObject.setType(mibObj.getType());
            aMibObject.setInstance(mibObj.getInstance());
            aMibObject.setMaxval(mibObj.getMaxval());
            aMibObject.setMinval(mibObj.getMinval());
            ResourceType resourceType = this.getConfiguredResourceTypes().get(mibObj.getInstance());
            if (resourceType != null) {
                aMibObject.setResourceType(resourceType);
            }
            if (mibObjectList.contains(aMibObject)) continue;
            mibObjectList.add(aMibObject);
        }
    }

    @Override
    public int getStep(String cName) {
        SnmpCollection collection = this.m_collectionMap.get(cName);
        if (collection != null) {
            return collection.getRrd().getStep();
        }
        return -1;
    }

    @Override
    public List<String> getRRAList(String cName) {
        SnmpCollection collection = this.m_collectionMap.get(cName);
        if (collection != null) {
            return collection.getRrd().getRraCollection();
        }
        return null;
    }

    @Override
    public String getSnmpStorageFlag(String cName) {
        SnmpCollection collection = this.m_collectionMap.get(cName);
        if (collection != null) {
            return collection.getSnmpStorageFlag();
        }
        return null;
    }

    @Override
    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdPath()));
        repo.setRraList(this.getRRAList(collectionName));
        repo.setStep(this.getStep(collectionName));
        repo.setHeartBeat(2 * this.getStep(collectionName));
        return repo;
    }

    @Override
    public String getRrdPath() {
        String rrdPath = this.m_config.getRrdRepository();
        if (rrdPath == null) {
            throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
        }
        if (rrdPath.endsWith(File.separator)) {
            rrdPath = rrdPath.substring(0, rrdPath.length() - File.separator.length());
        }
        return rrdPath;
    }

    private void buildCollectionMap() {
        this.m_collectionMap = new HashMap<String, SnmpCollection>();
        this.m_collectionGroupMap = new HashMap<String, Map<String, Group>>();
        List collections = this.m_config.getSnmpCollectionCollection();
        for (SnmpCollection collection : collections) {
            HashMap<String, Group> groupMap = new HashMap<String, Group>();
            Groups groups = collection.getGroups();
            List groupList = groups.getGroupCollection();
            for (Group group : groupList) {
                groupMap.put(group.getName(), group);
            }
            this.m_collectionGroupMap.put(collection.getName(), groupMap);
            this.m_collectionMap.put(collection.getName(), collection);
        }
    }
}

