/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcTransportFactory;
import org.apache.xmlrpc.secure.SecurityTool;
import org.opennms.netmgt.xmlrpcd.TimeoutSecureXmlRpcTransportFactory;

public class TimeoutSecureXmlRpcClient
extends XmlRpcClient {
    protected int timeout;

    public TimeoutSecureXmlRpcClient(URL url, int timeout) {
        super(url, (XmlRpcTransportFactory)new TimeoutSecureXmlRpcTransportFactory(url, timeout));
        this.timeout = timeout;
    }

    public TimeoutSecureXmlRpcClient(String url, int timeout) throws MalformedURLException {
        super(new URL(url), (XmlRpcTransportFactory)new TimeoutSecureXmlRpcTransportFactory(new URL(url), timeout));
        this.timeout = timeout;
    }

    public TimeoutSecureXmlRpcClient(String hostname, int port, int timeout) throws MalformedURLException {
        this("https://" + hostname + ':' + port + "/RPC2", timeout);
    }

    public void setup() throws Exception {
        SecurityTool.setup();
    }

    public static void main(String[] args) throws Exception {
        try {
            String url = args[0];
            int timeout = Integer.parseInt(args[1]);
            String method = args[2];
            Vector<Object> v = new Vector<Object>();
            for (int i = 3; i < args.length; ++i) {
                try {
                    v.addElement(new Integer(Integer.parseInt(args[i])));
                    continue;
                }
                catch (NumberFormatException nfx) {
                    v.addElement(args[i]);
                }
            }
            TimeoutSecureXmlRpcClient client = new TimeoutSecureXmlRpcClient(url, timeout);
            try {
                System.err.println(client.execute(method, v));
            }
            catch (Exception ex) {
                System.err.println("Error: " + ex.getMessage());
            }
        }
        catch (Exception x) {
            System.err.println(x);
            System.err.println("Usage: java " + TimeoutSecureXmlRpcClient.class.getName() + " <url> <timeout> <method> [args]");
            System.err.println("Arguments are sent as integers or strings.");
        }
    }
}

