/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.config.threshd.ResourceFilter;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.DefaultThresholdsDao;
import org.opennms.netmgt.threshd.IfInfoGetter;
import org.opennms.netmgt.threshd.JdbcIfInfoGetter;
import org.opennms.netmgt.threshd.ServiceThresholder;
import org.opennms.netmgt.threshd.SnmpThresholdConfiguration;
import org.opennms.netmgt.threshd.SnmpThresholdNetworkInterface;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdNetworkInterface;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SnmpThresholder
implements ServiceThresholder {
    private String m_serviceName;
    private ThresholdsDao m_thresholdsDao;
    private Map<NetworkInterface, SnmpThresholdNetworkInterface> m_snmpThresholdNetworkInterfaces;
    private IfInfoGetter m_ifInfoGetter;

    public String serviceName() {
        return this.m_serviceName;
    }

    @Override
    public void initialize(Map parameters) {
        this.m_serviceName = (String)parameters.get("svcName");
        this.setupThresholdsDao();
        this.setupIfInfoGetter();
        this.log().debug("initialize: successfully instantiated RRD subsystem");
        this.m_snmpThresholdNetworkInterfaces = Collections.synchronizedMap(new HashMap());
    }

    private void setupIfInfoGetter() {
        this.setIfInfoGetter(new JdbcIfInfoGetter());
    }

    @Override
    public void reinitialize() {
        this.setupThresholdsDao();
    }

    private void setupThresholdsDao() {
        DefaultThresholdsDao defaultThresholdsDao = new DefaultThresholdsDao();
        try {
            defaultThresholdsDao.setThresholdingConfigFactory(ThresholdingConfigFactory.getInstance());
            defaultThresholdsDao.afterPropertiesSet();
        }
        catch (Throwable t) {
            this.log().error("initialize: Could not initialize DefaultThresholdsDao: " + t, t);
            throw new RuntimeException("Could not initialize DefaultThresholdsDao: " + t, t);
        }
        this.setThresholdsDao(defaultThresholdsDao);
    }

    @Override
    public void release() {
    }

    @Override
    public void initialize(ThresholdNetworkInterface netIface, Map parms) {
        SnmpThresholdNetworkInterface snmpThresholdNetworkInterface = new SnmpThresholdNetworkInterface(this.m_thresholdsDao, netIface, parms);
        this.m_snmpThresholdNetworkInterfaces.put(netIface, snmpThresholdNetworkInterface);
        SnmpThresholdConfiguration config = snmpThresholdNetworkInterface.getThresholdConfiguration();
        if (!snmpThresholdNetworkInterface.isIPV4()) {
            throw new RuntimeException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("initialize: dumping node thresholds defined for " + snmpThresholdNetworkInterface + ":");
            for (Set<ThresholdEntity> entitySet : config.getNodeResourceType().getThresholdMap().values()) {
                for (ThresholdEntity thresholdEntity : entitySet) {
                    this.log().debug("    " + thresholdEntity);
                }
            }
            this.log().debug("initialize: dumping interface thresholds defined for " + snmpThresholdNetworkInterface + ":");
            for (Set<ThresholdEntity> entitySet : config.getIfResourceType().getThresholdMap().values()) {
                for (ThresholdEntity thresholdEntity : entitySet) {
                    this.log().debug("    " + thresholdEntity);
                }
            }
            this.log().debug("initialize: dumping generic resources thresholds defined for " + snmpThresholdNetworkInterface + ":");
            for (String resourceType : config.getGenericResourceTypeMap().keySet()) {
                for (Set set : config.getGenericResourceTypeMap().get(resourceType).getThresholdMap().values()) {
                    for (ThresholdEntity entity : set) {
                        this.log().debug("    " + resourceType + "." + entity);
                    }
                }
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("initialize: initialization completed for " + snmpThresholdNetworkInterface);
        }
    }

    @Override
    public void release(ThresholdNetworkInterface iface) {
        this.m_snmpThresholdNetworkInterfaces.remove(iface);
    }

    @Override
    public int check(ThresholdNetworkInterface netIface, EventProxy eproxy, Map parms) {
        File nodeDirectory;
        SnmpThresholdNetworkInterface snmpThresholdNetworkInterface = this.m_snmpThresholdNetworkInterfaces.get(netIface);
        if (snmpThresholdNetworkInterface == null) {
            this.log().warn("check: interface has not been initialized in this thresholder: " + netIface);
            return 2;
        }
        SnmpThresholdConfiguration config = snmpThresholdNetworkInterface.getThresholdConfiguration();
        if (this.log().isDebugEnabled()) {
            this.log().debug("check: service= " + this.serviceName() + " address= " + snmpThresholdNetworkInterface.getIpAddress() + " thresholding-group=" + config.getGroupName() + " interval=" + config.getInterval() + "ms range=" + config.getRange() + " mS");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("check: rrd repository=" + config.getRrdRepository());
        }
        if (!RrdFileConstants.isValidRRDNodeDir((File)(nodeDirectory = new File(config.getRrdRepository(), snmpThresholdNetworkInterface.getNodeId().toString())))) {
            this.log().info("Node directory for " + snmpThresholdNetworkInterface.getNodeId() + "/" + snmpThresholdNetworkInterface.getIpAddress() + " does not exist or is not a valid RRD node directory.");
            this.log().info("Threshold checking failed for primary SNMP interface " + snmpThresholdNetworkInterface.getIpAddress());
            return 2;
        }
        Events events = new Events();
        Date date = new Date();
        try {
            this.checkNodeDir(nodeDirectory, snmpThresholdNetworkInterface, date, events);
        }
        catch (IllegalArgumentException e) {
            this.log().info("check: Threshold checking failed for primary SNMP interface " + snmpThresholdNetworkInterface.getIpAddress() + ": " + e, (Throwable)e);
            return 2;
        }
        File[] files = nodeDirectory.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        if (files != null) {
            for (File file : files) {
                try {
                    this.checkIfDir(file, snmpThresholdNetworkInterface, date, events);
                }
                catch (IllegalArgumentException e) {
                    this.log().info("check: Threshold checking failed for primary SNMP interface " + snmpThresholdNetworkInterface.getIpAddress() + ": " + e, (Throwable)e);
                    return 2;
                }
            }
        }
        if (config.getGenericResourceTypeMap().size() > 0) {
            for (String resourceType : config.getGenericResourceTypeMap().keySet()) {
                File file = new File(nodeDirectory, resourceType);
                try {
                    this.checkResourceDir(file, snmpThresholdNetworkInterface, date, events);
                }
                catch (IllegalArgumentException e) {
                    this.log().info("check: Threshold checking failed for primary SNMP interface " + snmpThresholdNetworkInterface.getIpAddress() + ": " + e, (Throwable)e);
                    return 2;
                }
            }
        }
        if (events.getEventCount() > 0) {
            try {
                Log eventLog = new Log();
                eventLog.setEvents(events);
                eproxy.send(eventLog);
            }
            catch (EventProxyException e) {
                this.log().info("check: Failed sending threshold events: " + (Object)((Object)e), (Throwable)e);
                return 2;
            }
        }
        return 1;
    }

    protected void checkNodeDir(File directory, SnmpThresholdNetworkInterface thresholdNetworkInterface, Date date, Events events) throws IllegalArgumentException {
        Assert.notNull((Object)directory, (String)"directory argument cannot be null");
        Assert.notNull((Object)thresholdNetworkInterface, (String)"thresholdNetworkInterface argument cannot be null");
        Assert.notNull((Object)date, (String)"date argument cannot be null");
        Assert.notNull((Object)events, (String)"events argument cannot be null");
        SnmpThresholdConfiguration config = thresholdNetworkInterface.getThresholdConfiguration();
        Assert.notNull((Object)config, (String)"getThresholdConfiguration() of thresholdNetworkInterface argument cannot be null");
        Assert.notNull((Object)thresholdNetworkInterface.getNetworkInterface(), (String)"getNetworkInterface() of thresholdNetworkInterface argument cannot be null");
        Assert.notNull((Object)thresholdNetworkInterface.getNodeId(), (String)"getNodeId() of thresholdNetworkInterface argument cannot be null");
        Assert.notNull((Object)thresholdNetworkInterface.getInetAddress(), (String)"getInetAddress() of thresholdNetworkInterface argument cannot be null");
        if (this.log().isDebugEnabled()) {
            this.log().debug("checkNodeDir: threshold checking node dir: " + directory.getAbsolutePath());
        }
        Map<String, Set<ThresholdEntity>> thresholdMap = thresholdNetworkInterface.getNodeThresholdMap();
        for (String threshKey : thresholdMap.keySet()) {
            for (ThresholdEntity thresholdEntity : thresholdMap.get(threshKey)) {
                this.processThresholdForNode(directory, thresholdNetworkInterface, date, events, thresholdEntity);
            }
        }
    }

    private List<Event> processThreshold(File directory, SnmpThresholdNetworkInterface snmpIface, ThresholdEntity threshold, Date date) {
        SnmpThresholdConfiguration thresholdConfiguration = snmpIface.getThresholdConfiguration();
        Collection<String> requiredDatasources = threshold.getRequiredDatasources();
        HashMap<String, Double> values = new HashMap<String, Double>();
        String group = snmpIface.getThresholdConfiguration().getGroupName();
        for (String ds : requiredDatasources) {
            File dsFile = ResourceTypeUtils.getRrdFileForDs((File)directory, (String)ds);
            Double dsValue = null;
            if (dsFile.exists() && this.passedThresholdFilters(directory, group, threshold.getDatasourceType(), ds)) {
                dsValue = this.getDataSourceValue(thresholdConfiguration, dsFile, ds);
            }
            if (dsValue == null) {
                this.log().info("Could not get data source value for '" + ds + "'.  Not evaluating threshold.");
                return null;
            }
            values.put(ds, dsValue);
        }
        List<Event> eventList = threshold.evaluateAndCreateEvents(values, date);
        return eventList;
    }

    private String getDsLabel(ThresholdEntity threshold) {
        String dsLabelValue = threshold.getDatasourceLabel();
        if (dsLabelValue == null) {
            dsLabelValue = "Null";
        }
        return dsLabelValue;
    }

    private void processThresholdForNode(File directory, SnmpThresholdNetworkInterface snmpIface, Date date, Events events, ThresholdEntity threshold) {
        List<Event> eventList = this.processThreshold(directory, snmpIface, threshold, date);
        if (eventList == null || eventList.size() == 0) {
            return;
        }
        this.completeEventListAndAddToEvents(events, eventList, snmpIface, null, this.getDsLabel(threshold));
    }

    private void processThresholdForInterface(File directory, SnmpThresholdNetworkInterface snmpIface, Date date, Events events, ThresholdEntity threshold, String ifLabel, Map<String, String> ifDataMap) {
        List<Event> eventList = this.processThreshold(directory, snmpIface, threshold, date);
        if (eventList == null || eventList.size() == 0) {
            return;
        }
        if (ifDataMap.size() == 0 && ifLabel != null) {
            this.populateIfDataMap(ifDataMap, snmpIface.getNodeId(), ifLabel);
        }
        this.completeEventListAndAddToEvents(events, eventList, snmpIface, ifDataMap, this.getDsLabel(threshold));
    }

    private void processThresholdForResource(File directory, SnmpThresholdNetworkInterface snmpIface, Date date, Events events, ThresholdEntity threshold, String resource) {
        List<Event> eventList = this.processThreshold(directory, snmpIface, threshold, date);
        if (eventList == null || eventList.size() == 0) {
            return;
        }
        this.completeEventListAndAddToEvents(events, eventList, snmpIface, null, resource);
    }

    protected void checkIfDir(File directory, SnmpThresholdNetworkInterface snmpIface, Date date, Events events) throws IllegalArgumentException {
        if (directory == null || snmpIface.getNodeId() == null || snmpIface.getInetAddress() == null || date == null || events == null) {
            throw new IllegalArgumentException("Null parameters not permitted.");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("checkIfDir: threshold checking interface dir: " + directory.getAbsolutePath());
        }
        String ifLabel = directory.getName();
        if (this.log().isDebugEnabled()) {
            this.log().debug("checkIfDir: ifLabel=" + ifLabel);
        }
        Map<String, Set<ThresholdEntity>> thresholdMap = snmpIface.getInterfaceThresholdMap(ifLabel);
        HashMap<String, String> ifDataMap = new HashMap<String, String>();
        for (String threshKey : thresholdMap.keySet()) {
            for (ThresholdEntity thresholdEntity : thresholdMap.get(threshKey)) {
                this.processThresholdForInterface(directory, snmpIface, date, events, thresholdEntity, ifLabel, ifDataMap);
            }
        }
    }

    protected void checkResourceDir(File directory, SnmpThresholdNetworkInterface snmpIface, Date date, Events events) throws IllegalArgumentException {
        File[] files;
        ThresholdResourceType thresholdResourceType;
        if (directory == null || snmpIface.getNodeId() == null || snmpIface.getInetAddress() == null || date == null || events == null) {
            throw new IllegalArgumentException("Null parameters not permitted.");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("checkResourceDir: threshold checking generic resource dir: " + directory.getAbsolutePath());
        }
        String resourceType = directory.getName();
        if (!directory.exists()) {
            this.log().debug("Aborting check because this node does not support Resource Type " + resourceType);
            return;
        }
        SnmpThresholdConfiguration config = snmpIface.getThresholdConfiguration();
        if (this.log().isDebugEnabled()) {
            this.log().debug("checkResourceDir: group=" + config.getGroupName() + ", resourceType=" + resourceType);
        }
        if ((thresholdResourceType = config.getGenericResourceTypeMap().get(resourceType)) == null) {
            this.log().info("No generic resources for group " + config.getGroupName());
            return;
        }
        Map<String, Set<ThresholdEntity>> thresholdMap = thresholdResourceType.getThresholdMap();
        for (File file : files = directory.listFiles()) {
            String resource = file.getName();
            for (String threshKey : thresholdMap.keySet()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("checkResourceDir: resource=" + resource);
                }
                for (ThresholdEntity thresholdEntity : thresholdMap.get(threshKey)) {
                    String dsLabelValue = this.getDataSourceLabel(file, snmpIface, thresholdEntity);
                    this.processThresholdForResource(file, snmpIface, date, events, thresholdEntity, dsLabelValue);
                }
            }
        }
    }

    private ResourceFilter[] getThresholdFilters(String thresholdGroup, String dataSource) {
        Collection<Basethresholddef> thresholds = this.m_thresholdsDao.getThresholdingConfigFactory().getThresholds(thresholdGroup);
        for (Basethresholddef thresh : thresholds) {
            if (thresh instanceof Threshold) {
                Threshold t = (Threshold)thresh;
                if (!t.getDsName().equals(dataSource)) continue;
                return t.getResourceFilter();
            }
            Expression e = (Expression)thresh;
            if (e.getExpression().indexOf(dataSource) <= 0) continue;
            return e.getResourceFilter();
        }
        ResourceFilter[] filters = new ResourceFilter[]{};
        return filters;
    }

    protected boolean passedThresholdFilters(File resourceDir, String thresholdGroup, String resourceType, String dataSource) {
        ResourceFilter[] filters = this.getThresholdFilters(thresholdGroup, dataSource);
        if (filters.length == 0) {
            return true;
        }
        this.log().debug("checkFilters: resource=" + resourceDir.getName() + ", group=" + thresholdGroup + ", type=" + resourceType + ", filters=" + filters.length);
        int count = 1;
        for (ResourceFilter f : filters) {
            this.log().debug("checkFilters: filter #" + count + ": field=" + f.getField() + ", regex=" + f.getContent());
            ++count;
            String attr = this.getAttributeValue(resourceDir, resourceType, f.getField());
            if (attr == null) continue;
            Pattern p = Pattern.compile(f.getContent());
            Matcher m = p.matcher(attr);
            boolean pass = m.find();
            this.log().debug("checkFilters: the value of " + dataSource + " is " + attr + ". Pass filter? " + pass);
            if (!pass) continue;
            return true;
        }
        return false;
    }

    private void completeEventListAndAddToEvents(Events events, List<Event> eventList, SnmpThresholdNetworkInterface snmpIface, Map<String, String> ifDataMap, String dsLabelValue) {
        for (Event event : eventList) {
            Value parmValue;
            Parm eventParm;
            event.setNodeid(snmpIface.getNodeId().longValue());
            event.setService(this.serviceName());
            if (ifDataMap == null || ifDataMap.get("ipaddr") == null) {
                if (snmpIface.getInetAddress() != null) {
                    event.setInterface(snmpIface.getInetAddress().getHostAddress());
                }
            } else {
                String ifAddr = ifDataMap.get("ipaddr");
                event.setInterface(ifAddr);
            }
            Parms eventParms = event.getParms();
            if (dsLabelValue != null) {
                eventParm = new Parm();
                eventParm.setParmName("label");
                parmValue = new Value();
                parmValue.setContent(dsLabelValue);
                eventParm.setValue(parmValue);
                eventParms.addParm(eventParm);
            }
            if (ifDataMap != null && ifDataMap.get("iflabel") != null) {
                eventParm = new Parm();
                eventParm.setParmName("ifLabel");
                parmValue = new Value();
                parmValue.setContent(ifDataMap.get("iflabel"));
                eventParm.setValue(parmValue);
                eventParms.addParm(eventParm);
            }
            if (ifDataMap != null && ifDataMap.get("snmpifindex") != null) {
                eventParm = new Parm();
                eventParm.setParmName("ifIndex");
                parmValue = new Value();
                parmValue.setContent(ifDataMap.get("snmpifindex"));
                eventParm.setValue(parmValue);
                eventParms.addParm(eventParm);
            }
            events.addEvent(event);
        }
    }

    private Double getDataSourceValue(SnmpThresholdConfiguration thresholdConfiguration, File file, String datasource) {
        Double dsValue;
        try {
            if (thresholdConfiguration.getRange() != 0) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Checking datasource '" + datasource + "' for values within " + thresholdConfiguration.getRange() + " milliseconds of last possible PDP with interval " + thresholdConfiguration.getInterval() + ".");
                }
                dsValue = RrdUtils.fetchLastValueInRange((String)file.getAbsolutePath(), (String)datasource, (int)thresholdConfiguration.getInterval(), (int)thresholdConfiguration.getRange());
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Checking datasource '" + datasource + "' for value of last possible PDP only with interval " + thresholdConfiguration.getInterval() + ".");
                }
                dsValue = RrdUtils.fetchLastValue((String)file.getAbsolutePath(), (String)datasource, (int)thresholdConfiguration.getInterval());
            }
        }
        catch (NumberFormatException e) {
            this.log().warn("Unable to convert retrieved value for datasource '" + datasource + "' to a double: " + e);
            return null;
        }
        catch (RrdException e) {
            this.log().info("An error occurred retriving the last value for datasource '" + datasource + "': " + (Object)((Object)e), (Throwable)e);
            return null;
        }
        if (dsValue == null) {
            this.log().info("fetch value for data source '" + datasource + "' was null.");
            return null;
        }
        if (dsValue.isNaN()) {
            this.log().info("fetch value for data source '" + datasource + "' was NaN.");
            return null;
        }
        return dsValue;
    }

    protected String stripRrdExtension(String fileName) {
        if (!fileName.endsWith(RrdUtils.getExtension())) {
            this.log().info("stripRrdExtension: File '" + fileName + "' does not end with the RRD extension '" + RrdUtils.getExtension() + "'.");
            return null;
        }
        return fileName.substring(0, fileName.lastIndexOf(RrdUtils.getExtension()));
    }

    private String getAttributeValue(File resourceDirectory, String resourceType, String attribute) {
        this.log().debug("Getting Value for " + resourceType + "::" + attribute + " from " + resourceDirectory);
        String value = null;
        if (attribute.equals("ID")) {
            return resourceDirectory.getName();
        }
        try {
            if (resourceType.equals("if")) {
                String ifLabel = resourceDirectory.getName();
                int nodeId = Integer.parseInt(resourceDirectory.getParentFile().getName());
                HashMap<String, String> info = new HashMap<String, String>();
                this.populateIfDataMap(info, nodeId, ifLabel);
                value = (String)info.get(attribute);
            } else {
                value = ResourceTypeUtils.getStringProperty((File)resourceDirectory, (String)attribute);
            }
        }
        catch (Exception e) {
            this.log().warn("Can't get value for attribute " + attribute + ". " + e, (Throwable)e);
        }
        return value;
    }

    private String getDataSourceLabel(File directory, SnmpThresholdNetworkInterface snmpIface, ThresholdEntity threshold) {
        String dsLabelValue;
        block2: {
            dsLabelValue = null;
            try {
                String key = threshold.getDatasourceLabel();
                dsLabelValue = key == null ? null : ResourceTypeUtils.getStringProperty((File)directory, (String)key);
            }
            catch (DataAccessException e) {
                if (!this.log().isDebugEnabled()) break block2;
                this.log().debug("getDataSourceLabel: I/O exception when looking for strings.properties file for node id: " + snmpIface.getNodeId() + " looking here: " + directory + ": " + (Object)((Object)e), (Throwable)e);
            }
        }
        return dsLabelValue == null ? "Unknown" : dsLabelValue;
    }

    private void populateIfDataMap(Map<String, String> ifDataMap, int nodeId, String ifLabel) {
        Map<String, String> ifInfo = this.m_ifInfoGetter.getIfInfoForNodeAndLabel(nodeId, ifLabel);
        ifDataMap.putAll(ifInfo);
        ifDataMap.put("iflabel", ifLabel);
    }

    protected static Map<String, Set<ThresholdEntity>> getAttributeMap(ThresholdResourceType resourceType) {
        HashMap<String, Set<ThresholdEntity>> thresholdMap = new HashMap<String, Set<ThresholdEntity>>();
        for (Set<ThresholdEntity> entitySet : resourceType.getThresholdMap().values()) {
            for (ThresholdEntity entity : entitySet) {
                if (!thresholdMap.containsKey(entity.getDataSourceExpression())) {
                    thresholdMap.put(entity.getDataSourceExpression(), new LinkedHashSet());
                }
                ((Set)thresholdMap.get(entity.getDataSourceExpression())).add(entity.clone());
            }
        }
        return thresholdMap;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public ThresholdsDao getThresholdsDao() {
        return this.m_thresholdsDao;
    }

    public void setThresholdsDao(ThresholdsDao thresholdsDao) {
        this.m_thresholdsDao = thresholdsDao;
    }

    public IfInfoGetter getIfInfoGetter() {
        return this.m_ifInfoGetter;
    }

    public void setIfInfoGetter(IfInfoGetter ifInfoGetter) {
        this.m_ifInfoGetter = ifInfoGetter;
    }
}

