/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThresholdsDao
implements ThresholdsDao,
InitializingBean {
    private ThresholdingConfigFactory m_thresholdingConfigFactory;

    @Override
    public ThresholdGroup get(String name) {
        return this.get(name, null);
    }

    @Override
    public ThresholdGroup merge(ThresholdGroup group) {
        return this.get(group.getName(), group);
    }

    private ThresholdGroup get(String name, ThresholdGroup group) {
        boolean merge = group != null;
        ThresholdGroup newGroup = new ThresholdGroup(name);
        File rrdRepository = new File(this.getThresholdingConfigFactory().getRrdRepository(name));
        newGroup.setRrdRepository(rrdRepository);
        ThresholdResourceType nodeType = merge ? this.mergeType(name, "node", group.getNodeResourceType()) : this.createType(name, "node");
        newGroup.setNodeResourceType(nodeType);
        ThresholdResourceType ifType = merge ? this.mergeType(name, "if", group.getIfResourceType()) : this.createType(name, "if");
        newGroup.setIfResourceType(ifType);
        for (Basethresholddef thresh : this.getThresholdingConfigFactory().getThresholds(name)) {
            ThresholdResourceType genericType;
            String id = thresh.getDsType();
            if (id.equals("if") || id.equals("node") || newGroup.getGenericResourceTypeMap().containsKey(id) || (genericType = merge ? this.mergeType(name, id, group.getGenericResourceTypeMap().get(id)) : this.createType(name, id)).getThresholdMap().size() <= 0) continue;
            this.log().info("Adding " + name + "::" + id + " with " + genericType.getThresholdMap().size() + " elements");
            newGroup.getGenericResourceTypeMap().put(id, genericType);
        }
        return newGroup;
    }

    private Map<String, Set<ThresholdEntity>> createThresholdStateMap(String groupName, String typeName) {
        HashMap<String, Set<ThresholdEntity>> thresholdMap = new HashMap<String, Set<ThresholdEntity>>();
        this.fillThresholdStateMap(groupName, typeName, thresholdMap);
        return thresholdMap;
    }

    private Map<String, Set<ThresholdEntity>> mergeThresholdStateMap(String groupName, ThresholdResourceType type) {
        Map<String, Set<ThresholdEntity>> thresholdMap = type.getThresholdMap();
        this.fillThresholdStateMap(groupName, type.getDsType(), thresholdMap);
        return thresholdMap;
    }

    private void fillThresholdStateMap(String groupName, String typeName, Map<String, Set<ThresholdEntity>> thresholdMap) {
        boolean merge = !thresholdMap.isEmpty();
        for (Basethresholddef thresh : this.getThresholdingConfigFactory().getThresholds(groupName)) {
            if (!thresh.getDsType().equals(typeName)) continue;
            try {
                BaseThresholdDefConfigWrapper wrapper = BaseThresholdDefConfigWrapper.getConfigWrapper(thresh);
                Set<ThresholdEntity> thresholdEntitySet = thresholdMap.get(wrapper.getDatasourceExpression());
                if (thresholdEntitySet == null) {
                    thresholdEntitySet = new LinkedHashSet<ThresholdEntity>();
                    thresholdMap.put(wrapper.getDatasourceExpression(), thresholdEntitySet);
                }
                try {
                    ThresholdEntity thresholdEntity = new ThresholdEntity();
                    thresholdEntity.addThreshold(wrapper);
                    if (merge) {
                        boolean updated = false;
                        for (ThresholdEntity e : thresholdEntitySet) {
                            if (!thresholdEntity.getThresholdConfig().equals(e.getThresholdConfig())) continue;
                            e.merge(thresholdEntity);
                            updated = true;
                        }
                        if (updated) continue;
                        thresholdEntitySet.add(thresholdEntity);
                        continue;
                    }
                    thresholdEntitySet.add(thresholdEntity);
                }
                catch (IllegalStateException e) {
                    this.log().warn("fillThresholdStateMap: Encountered duplicate " + thresh.getType() + " for datasource " + wrapper.getDatasourceExpression() + ": " + e, (Throwable)e);
                }
            }
            catch (ThresholdExpressionException e) {
                this.log().warn("fillThresholdStateMap: Could not parse threshold expression: " + e.getMessage(), (Throwable)e);
            }
        }
        if (merge) {
            this.log().debug("fillThresholdStateMap(merge): checking if definitions that are no longer exist for group " + groupName + " using type " + typeName);
            for (String expression : thresholdMap.keySet()) {
                Iterator<ThresholdEntity> i = thresholdMap.get(expression).iterator();
                while (i.hasNext()) {
                    ThresholdEntity entity = i.next();
                    boolean found = false;
                    for (Basethresholddef thresh : this.getThresholdingConfigFactory().getThresholds(groupName)) {
                        BaseThresholdDefConfigWrapper newConfig = null;
                        try {
                            newConfig = BaseThresholdDefConfigWrapper.getConfigWrapper(thresh);
                        }
                        catch (ThresholdExpressionException e) {
                            this.log().warn("fillThresholdStateMap: Could not parse threshold expression: " + e.getMessage(), (Throwable)e);
                        }
                        if (!newConfig.equals(entity.getThresholdConfig())) continue;
                        found = true;
                    }
                    if (found) continue;
                    this.log().info("fillThresholdStateMap(merge): deleting entity " + entity);
                    entity.delete();
                    i.remove();
                }
            }
        }
    }

    private ThresholdResourceType createType(String groupName, String typeName) {
        ThresholdResourceType resourceType = new ThresholdResourceType(typeName);
        resourceType.setThresholdMap(this.createThresholdStateMap(groupName, typeName));
        return resourceType;
    }

    private ThresholdResourceType mergeType(String groupName, String typeName, ThresholdResourceType type) {
        ThresholdResourceType resourceType = new ThresholdResourceType(typeName);
        resourceType.setThresholdMap(this.mergeThresholdStateMap(groupName, type));
        return resourceType;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public ThresholdingConfigFactory getThresholdingConfigFactory() {
        return this.m_thresholdingConfigFactory;
    }

    public void setThresholdingConfigFactory(ThresholdingConfigFactory thresholdingConfigFactory) {
        this.m_thresholdingConfigFactory = thresholdingConfigFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_thresholdingConfigFactory != null ? 1 : 0) != 0, (String)"thresholdingConfigFactory property not set");
    }
}

