/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.DatagramSocket;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.syslogd.QueueManager;
import org.opennms.netmgt.syslogd.SyslogProcessor;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;

public final class SyslogHandler {
    private SyslogReceiver m_receiver = null;
    private SyslogProcessor m_processor = null;
    private volatile int m_status = 0;
    private DatagramSocket m_dgSock = null;
    private boolean m_NewSuspectOnMessage;
    private String m_ForwardingRegexp;
    private int m_MatchingGroupHost;
    private int m_MatchingGroupMessage;
    private UeiList m_UeiList;
    private HideMessage m_HideMessages;
    private int m_dgPort = m_syslogdConfig.getSyslogPort();
    private String m_logPrefix = null;
    private String m_DiscardUei;
    private static SyslogdConfig m_syslogdConfig;
    static QueueManager queueManager;
    public static final String[] STATUS_NAMES;
    public static final int START_PENDING = 0;
    public static final int STARTING = 1;
    public static final int RUNNING = 2;
    public static final int STOP_PENDING = 3;
    public static final int STOPPED = 4;

    public SyslogHandler() {
        this.m_NewSuspectOnMessage = m_syslogdConfig.getNewSuspectOnMessage();
        this.m_ForwardingRegexp = m_syslogdConfig.getForwardingRegexp();
        this.m_MatchingGroupHost = m_syslogdConfig.getMatchingGroupHost();
        this.m_MatchingGroupMessage = m_syslogdConfig.getMatchingGroupMessage();
        this.m_DiscardUei = m_syslogdConfig.getDiscardUei();
        this.m_UeiList = m_syslogdConfig.getUeiList();
        this.m_HideMessages = m_syslogdConfig.getHideMessages();
    }

    public static void setSyslogConfig(SyslogdConfig syslogdConfig) {
        m_syslogdConfig = syslogdConfig;
    }

    public synchronized void start() {
        if (this.m_status != 0) {
            throw new RuntimeException("The Fiber is in an incorrect state");
        }
        this.m_status = 1;
        try {
            this.m_dgSock = new DatagramSocket(this.m_dgPort);
            this.m_receiver = new SyslogReceiver(this.m_dgSock, this.m_ForwardingRegexp, this.m_MatchingGroupHost, this.m_MatchingGroupMessage, this.m_UeiList, this.m_HideMessages, this.m_DiscardUei);
            this.m_processor = new SyslogProcessor(this.m_NewSuspectOnMessage, this.m_ForwardingRegexp, this.m_MatchingGroupHost, this.m_MatchingGroupMessage, this.m_UeiList, this.m_HideMessages);
            if (this.m_logPrefix != null) {
                this.m_receiver.setLogPrefix(this.m_logPrefix);
                this.m_processor.setLogPrefix(this.m_logPrefix);
            }
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
        Thread rThread = new Thread((Runnable)this.m_receiver, "Syslog Event Receiver[" + this.m_dgPort + "]");
        Thread pThread = new Thread((Runnable)this.m_processor, "Syslog Event Processor[" + this.m_dgPort + "]");
        try {
            rThread.start();
            pThread.start();
        }
        catch (RuntimeException e) {
            rThread.interrupt();
            pThread.interrupt();
            this.m_status = 4;
            throw e;
        }
        this.m_status = 2;
    }

    public synchronized void stop() {
        if (this.m_status == 4) {
            return;
        }
        if (this.m_status == 0) {
            this.m_status = 4;
            return;
        }
        this.m_status = 3;
        try {
            this.m_receiver.stop();
            this.m_processor.stop();
        }
        catch (InterruptedException e) {
            ThreadCategory log = ThreadCategory.getInstance(this.getClass());
            log.warn("The thread was interrupted while attempting to join sub-threads", (Throwable)e);
        }
        this.m_dgSock.close();
        this.m_status = 4;
    }

    public String getName() {
        return "SyslogdHandler[" + this.m_dgPort + "]";
    }

    public int getStatus() {
        return this.m_status;
    }

    public void init() {
    }

    public void destroy() {
    }

    public void setPort(Integer port) {
        if (this.m_status == 1 || this.m_status == 2 || this.m_status == 3) {
            throw new IllegalStateException("The process is already running");
        }
        this.m_dgPort = port;
    }

    public Integer getPort() {
        return this.m_dgPort;
    }

    public void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    static {
        queueManager = new QueueManager();
        STATUS_NAMES = new String[]{"START_PENDING", "STARTING", "RUNNING", "STOP_PENDING", "STOPPED", "PAUSE_PENDING", "PAUSED", "RESUME_PENDING"};
    }

    public static interface EventHandler {
        public boolean processEvent(Event var1);

        public void receiptSent(EventReceipt var1);
    }
}

