/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.syslogd.HideMatch;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.ParameterAssignment;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.syslogd.MessageDiscardedException;
import org.opennms.netmgt.syslogd.SyslogDefs;
import org.opennms.netmgt.syslogd.SyslogTimeStamp;
import org.opennms.netmgt.syslogd.SyslogdIPMgr;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConvertToEvent {
    protected static final String HIDDEN_MESSAGE = "The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.";
    private String m_eventXML;
    private Log m_log;
    private InetAddress m_sender;
    private int m_port;
    private List<Event> m_ackEvents;
    private Event m_event;

    private ConvertToEvent() {
    }

    static ConvertToEvent make(DatagramPacket packet, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessage, String discardUei) throws UnsupportedEncodingException, MessageDiscardedException {
        return ConvertToEvent.make(packet.getAddress(), packet.getPort(), packet.getData(), packet.getLength(), matchPattern, hostGroup, messageGroup, ueiList, hideMessage, discardUei);
    }

    static ConvertToEvent make(InetAddress addr, int port, byte[] data, int len, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessage, String discardUei) throws UnsupportedEncodingException, MessageDiscardedException {
        Matcher msgMat;
        Pattern pattern;
        Matcher m;
        boolean traceEnabled;
        String timestamp;
        ConvertToEvent e = new ConvertToEvent();
        e.m_sender = addr;
        e.m_port = port;
        e.m_eventXML = new String(data, 0, len, "US-ASCII");
        e.m_ackEvents = new ArrayList<Event>(16);
        e.m_log = null;
        ThreadCategory.setPrefix((String)"OpenNMS.Syslogd");
        ThreadCategory log = ThreadCategory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug("In the make part of UdpReceivedSyslog " + e.toString());
        }
        Event event = new Event();
        event.setSource("syslogd");
        long nodeId = SyslogdIPMgr.getNodeId(addr.getHostAddress().replaceAll("/", ""));
        if (nodeId != -1L) {
            event.setNodeid(nodeId);
        }
        try {
            event.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhE) {
            event.setHost("unresolved.host");
            log.warn("Failed to resolve local hostname", (Throwable)uhE);
        }
        event.setInterface(addr.getHostAddress().replaceAll("/", ""));
        event.setTime(EventConstants.formatToString((Date)new Date()));
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        String message = new String(data, 0, len, "US-ASCII");
        int lbIdx = message.indexOf(60);
        int rbIdx = message.indexOf(62);
        if (lbIdx < 0 || rbIdx < 0 || lbIdx >= rbIdx - 1) {
            log.warn("Syslogd received an unparsable message!");
        }
        int priCode = 0;
        String priStr = message.substring(lbIdx + 1, rbIdx);
        try {
            priCode = Integer.parseInt(priStr);
        }
        catch (NumberFormatException ex) {
            log.debug("ERROR Bad priority code '" + priStr + "'");
        }
        int facility = SyslogDefs.extractFacility(priCode);
        int priority = SyslogDefs.extractPriority(priCode);
        String priorityTxt = SyslogDefs.getPriorityName(priority);
        String facilityTxt = SyslogDefs.getFacilityName(facility);
        event.setUei("uei.opennms.org/syslogd/" + facilityTxt + "/" + priorityTxt);
        message = message.substring(rbIdx + 1, message.length());
        boolean stdMsg = true;
        if (message.length() < 16) {
            stdMsg = false;
        } else if (message.charAt(3) != ' ' || message.charAt(6) != ' ' || message.charAt(9) != ':' || message.charAt(12) != ':' || message.charAt(15) != ' ') {
            stdMsg = false;
        }
        if (!stdMsg) {
            try {
                timestamp = SyslogTimeStamp.getInstance().format(new Date());
            }
            catch (IllegalArgumentException ex) {
                log.debug("ERROR INTERNAL DATE ERROR!");
                timestamp = "";
            }
        } else {
            timestamp = message.substring(0, 15);
            message = message.substring(16);
        }
        if (traceEnabled = log.isEnabledFor(ThreadCategory.Level.TRACE)) {
            log.trace("Message : " + message);
            log.trace("Pattern : " + matchPattern);
            log.trace("Host group: " + hostGroup);
            log.trace("Message group: " + messageGroup);
        }
        if ((m = (pattern = Pattern.compile(matchPattern)).matcher(message)).matches()) {
            if (traceEnabled) {
                log.trace("Regexp matched message: " + message);
                log.trace("Host: " + m.group(hostGroup));
                log.trace("Message: " + m.group(messageGroup));
            }
            StringBuffer sb = new StringBuffer();
            try {
                InetAddress address = InetAddress.getByName(m.group(hostGroup));
                byte[] ipAddr = address.getAddress();
                for (int i = 0; i < ipAddr.length; ++i) {
                    if (i > 0) {
                        sb.append(".");
                    }
                    sb.append(ipAddr[i] & 0xFF);
                }
            }
            catch (UnknownHostException e1) {
                log.warn("Could not parse the host: " + e1);
            }
            String myHost = sb.toString();
            if (!"".equals(myHost)) {
                nodeId = SyslogdIPMgr.getNodeId(myHost.replaceAll("/", ""));
                if (nodeId != -1L) {
                    event.setNodeid(nodeId);
                }
                event.setInterface(myHost.replaceAll("/", ""));
                message = m.group(messageGroup);
                if (traceEnabled) {
                    log.trace("Regexp used to find node: " + event.getNodeid());
                }
            }
        } else {
            log.debug("Regexp not matched: " + message);
            throw new MessageDiscardedException();
        }
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        List ueiMatch = ueiList.getUeiMatchCollection();
        if (ueiMatch == null) {
            log.warn("No ueiList configured.");
        } else {
            for (UeiMatch uei : ueiMatch) {
                if (uei.getMatch().getType().equals("substr")) {
                    if (traceEnabled) {
                        log.trace("Attempting substring match for text of a Syslogd event to :" + uei.getMatch().getExpression());
                    }
                    if (!message.contains(uei.getMatch().getExpression())) continue;
                    if (discardUei.equals(uei.getUei()) && traceEnabled) {
                        log.trace("Specified UEI '" + uei.getUei() + "' is same as discard-uei, discarding this message.");
                        throw new MessageDiscardedException();
                    }
                    if (traceEnabled) {
                        log.trace("Changed the UEI of a Syslogd event, based on substring match, to :" + uei.getUei());
                    }
                    event.setUei(uei.getUei());
                    break;
                }
                if (!uei.getMatch().getType().equals("regex")) continue;
                if (traceEnabled) {
                    log.trace("Attempting regex match for text of a Syslogd event to :" + uei.getMatch().getExpression());
                }
                try {
                    Pattern msgPat = Pattern.compile(uei.getMatch().getExpression(), 8);
                    msgMat = msgPat.matcher(message);
                }
                catch (PatternSyntaxException pse) {
                    log.warn("Failed to compile regex pattern '" + uei.getMatch().getExpression() + "'", (Throwable)pse);
                    msgMat = null;
                }
                if (msgMat == null || !msgMat.matches()) continue;
                if (discardUei.equals(uei.getUei())) {
                    if (log.isDebugEnabled()) {
                        log.debug("Specified UEI '" + uei.getUei() + "' is same as discard-uei, discarding this message.");
                    }
                    throw new MessageDiscardedException();
                }
                if (traceEnabled) {
                    log.trace("Changed the UEI of a Syslogd event, based on regex match, to :" + uei.getUei());
                }
                event.setUei(uei.getUei());
                if (msgMat.groupCount() > 0 && uei.getMatch().isDefaultParameterMapping()) {
                    log.trace("Doing default parameter mappings for this regex match.");
                    for (int groupNum = 1; groupNum <= msgMat.groupCount(); ++groupNum) {
                        if (traceEnabled) {
                            log.trace("Added parm 'group" + groupNum + "' with value '" + msgMat.group(groupNum) + "' to Syslogd event based on regex match group");
                        }
                        eventParm = new Parm();
                        eventParm.setParmName("group" + groupNum);
                        parmValue = new Value();
                        parmValue.setContent(msgMat.group(groupNum));
                        eventParm.setValue(parmValue);
                        eventParms.addParm(eventParm);
                    }
                }
                if (msgMat.groupCount() <= 0 || uei.getParameterAssignmentCount() <= 0) break;
                log.trace("Doing user-specified parameter assignments for this regex match.");
                for (ParameterAssignment assignment : uei.getParameterAssignmentCollection()) {
                    eventParm = new Parm();
                    eventParm.setParmName(assignment.getParameterName());
                    parmValue = new Value();
                    String vettedValue = msgMat.group(assignment.getMatchingGroup());
                    if (vettedValue == null) {
                        vettedValue = "";
                    }
                    parmValue.setContent(vettedValue);
                    eventParm.setValue(parmValue);
                    eventParms.addParm(eventParm);
                    if (!traceEnabled) continue;
                    log.trace("Added parm '" + eventParm.getParmName() + "' with value '" + parmValue.getContent() + "' to Syslogd event based on user-specified parameter assignment");
                }
            }
        }
        boolean doHide = false;
        List hideMatch = hideMessage.getHideMatchCollection();
        if (hideMatch == null) {
            log.warn("No hideMessage configured.");
        } else {
            for (HideMatch hide : hideMatch) {
                if (hide.getMatch().getType().equals("substr")) {
                    if (message.contains(hide.getMatch().getExpression())) {
                        doHide = true;
                    }
                } else if (hide.getMatch().getType().equals("regex")) {
                    try {
                        Pattern msgPat = Pattern.compile(hide.getMatch().getExpression(), 8);
                        msgMat = msgPat.matcher(message);
                    }
                    catch (PatternSyntaxException pse) {
                        log.warn("Failed to compile regex pattern '" + hide.getMatch().getExpression() + "'", (Throwable)pse);
                        msgMat = null;
                    }
                    if (msgMat != null && msgMat.matches()) {
                        doHide = true;
                    }
                }
                if (!doHide) continue;
                log.debug("Hiding syslog message from Event - May contain sensitive data");
                message = HIDDEN_MESSAGE;
                break;
            }
        }
        lbIdx = message.indexOf(91);
        rbIdx = message.indexOf(93);
        int colonIdx = message.indexOf(58);
        int spaceIdx = message.indexOf(32);
        int processId = 0;
        String processName = "";
        String processIdStr = "";
        if (lbIdx < rbIdx - 1 && colonIdx == rbIdx + 1 && spaceIdx == colonIdx + 1) {
            processName = message.substring(0, lbIdx);
            processIdStr = message.substring(lbIdx + 1, rbIdx);
            message = message.substring(colonIdx + 2);
            try {
                processId = Integer.parseInt(processIdStr);
            }
            catch (NumberFormatException ex) {
                log.debug("Bad process id '" + processIdStr + "'");
                processId = 0;
            }
        } else if (lbIdx < 0 && rbIdx < 0 && colonIdx > 0 && spaceIdx == colonIdx + 1) {
            processName = message.substring(0, colonIdx);
            message = message.substring(colonIdx + 2);
        }
        logmsg.setContent(message);
        event.setLogmsg(logmsg);
        eventParm = new Parm();
        eventParm.setParmName("syslogmessage");
        parmValue = new Value();
        parmValue.setContent(message);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("severity");
        parmValue = new Value();
        parmValue.setContent("" + priorityTxt);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("timestamp");
        parmValue = new Value();
        parmValue.setContent(timestamp);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("process");
        parmValue = new Value();
        parmValue.setContent(processName);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("service");
        parmValue = new Value();
        parmValue.setContent("" + facilityTxt);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("processid");
        parmValue = new Value();
        parmValue.setContent("" + processId);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        event.setParms(eventParms);
        e.m_event = event;
        return e;
    }

    Log unmarshal() throws ValidationException, MarshalException {
        if (this.m_log == null) {
            this.m_log = (Log)CastorUtils.unmarshal(Log.class, (InputStream)new ByteArrayInputStream(this.m_eventXML.getBytes()));
        }
        return this.m_log;
    }

    void ackEvent(Event e) {
        if (!this.m_ackEvents.contains(e)) {
            this.m_ackEvents.add(e);
        }
    }

    String getXmlData() {
        return this.m_eventXML;
    }

    InetAddress getSender() {
        return this.m_sender;
    }

    int getPort() {
        return this.m_port;
    }

    public List<Event> getAckedEvents() {
        return this.m_ackEvents;
    }

    public Event getEvent() {
        return this.m_event;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ConvertToEvent) {
            ConvertToEvent e = (ConvertToEvent)o;
            return this == e || this.m_port == e.m_port && this.m_sender.equals(e.m_sender);
        }
        return false;
    }

    public int hashCode() {
        return this.m_port ^ this.m_sender.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Sender", (Object)this.m_sender).append("Port", this.m_port).append("Acknowledged Events", this.m_ackEvents).append("Event", (Object)this.m_event).toString();
    }
}

