/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.opennms.core.utils.DefaultTimeKeeper;
import org.opennms.core.utils.TimeKeeper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RelativeTime {
    LASTTHIRTYONEDAYS{

        public Date getStart() {
            return this.getStartDate(31);
        }

        public Date getEnd() {
            return this.getStartOfToday();
        }
    }
    ,
    LASTSEVENDAYS{

        public Date getStart() {
            return this.getStartDate(7);
        }

        public Date getEnd() {
            return this.getStartOfToday();
        }
    }
    ,
    YESTERDAY{

        public Date getStart() {
            return this.getStartDate(1);
        }

        public Date getEnd() {
            return this.getStartOfToday();
        }
    }
    ,
    LASTHOUR{

        public Date getStart() {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(this.getCurrentTime());
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            ((Calendar)calendar).add(10, -1);
            return calendar.getTime();
        }

        public Date getEnd() {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(this.getCurrentTime());
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            return calendar.getTime();
        }
    };

    private static TimeKeeper DEFAULT_TIME_KEEPER;
    private TimeKeeper m_timeKeeper = null;

    protected Date getStartDate(int offset) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(this.getCurrentTime());
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        ((Calendar)calendar).add(6, -offset);
        return calendar.getTime();
    }

    protected Date getStartOfToday() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(this.getCurrentTime());
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        return calendar.getTime();
    }

    public abstract Date getStart();

    public abstract Date getEnd();

    public TimeKeeper getTimeKeeper() {
        return this.m_timeKeeper;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }

    protected long getCurrentTime() {
        if (this.getTimeKeeper() == null) {
            return DEFAULT_TIME_KEEPER.getCurrentTime();
        }
        return this.getTimeKeeper().getCurrentTime();
    }

    static {
        DEFAULT_TIME_KEEPER = new DefaultTimeKeeper();
    }
}

