/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class Pop3Monitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 110;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        tracker = new TimeoutTracker(parameters, 0, 3000);
        port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)110);
        ipv4Addr = (InetAddress)iface.getAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug("poll: address = " + ipv4Addr + ", port = " + port + ", " + tracker);
        }
        serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() != false) {
            block31: {
                if (serviceStatus.isAvailable() != false) return serviceStatus;
                socket = null;
                try {
                    block32: {
                        tracker.startAttempt();
                        socket = new Socket();
                        socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                        socket.setSoTimeout(tracker.getSoTimeout());
                        this.log().debug("Pop3Monitor: connected to host: " + ipv4Addr + " on port: " + port);
                        serviceStatus = PollStatus.unresponsive();
                        rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        banner = rdr.readLine();
                        responseTime = tracker.elapsedTimeInMillis();
                        if (banner != null) break block32;
                        var16_18 = null;
                        ** GOTO lbl-1000
                    }
                    t = new StringTokenizer(banner);
                    if (t.nextToken().equals("+OK")) {
                        cmd = "QUIT\r\n";
                        socket.getOutputStream().write(cmd.getBytes());
                        t = new StringTokenizer(rdr.readLine());
                        if (t.nextToken().equals("+OK")) {
                            serviceStatus = PollStatus.available((Double)responseTime);
                        }
                    }
                    if (serviceStatus.isAvailable()) ** GOTO lbl112
                    serviceStatus = PollStatus.unavailable();
                    ** GOTO lbl112
                }
                catch (NoRouteToHostException e) {
                    serviceStatus = this.logDown(Level.WARN, "No route to host exception for address " + ipv4Addr.getHostAddress(), e);
                    var16_18 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("poll: Error closing socket.", (Throwable)e);
                        }
                        break block31;
                    }
                }
                catch (InterruptedIOException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "did not connect to host with " + tracker);
                    var16_18 = null;
                    try {}
                    catch (IOException e) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("poll: Error closing socket.", (Throwable)e);
                        }
                        break block31;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block31;
                }
                catch (ConnectException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address " + ipv4Addr.getHostAddress(), e);
                    var16_18 = null;
                    try {}
                    catch (IOException e) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("poll: Error closing socket.", (Throwable)e);
                        }
                        break block31;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block31;
                }
                catch (IOException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address " + ipv4Addr.getHostAddress(), e);
                    var16_18 = null;
                    try {}
                    catch (IOException e) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("poll: Error closing socket.", (Throwable)e);
                        }
                        break block31;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block31;
                }
                {
                    catch (Throwable var15_20) {
                        var16_18 = null;
                        ** try [egrp 2[TRYBLOCK] [15 : 551->564)] { 
lbl96:
                        // 1 sources

                        if (socket == null) throw var15_20;
                        socket.close();
                        throw var15_20;
lbl99:
                        // 1 sources

                        catch (IOException e) {
                            if (this.log().isDebugEnabled() == false) throw var15_20;
                            this.log().debug("poll: Error closing socket.", (Throwable)e);
                        }
                        throw var15_20;
                    }
lbl-1000:
                    // 1 sources

                    try {}
                    catch (IOException e) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("poll: Error closing socket.", (Throwable)e);
                        }
                    }
                    if (socket != null) {
                        socket.close();
                    }
lbl112:
                    // 2 sources

                    var16_18 = null;
                    ** try [egrp 2[TRYBLOCK] [15 : 551->564)] { 
lbl114:
                    // 1 sources

                    if (socket != null) {
                        socket.close();
                    }
lbl118:
                    // 1 sources

                    catch (IOException e) {}
                    if (!this.log().isDebugEnabled()) break block31;
                    this.log().debug("poll: Error closing socket.", (Throwable)e);
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

