/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class MemcachedMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 11211;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String[] m_keys = new String[]{"uptime", "rusageuser", "rusage_system", "curr_items", "totalitems", "bytes", "currconnections", "totalconnections", "connectionstructure", "cmdget", "cmdset", "gethits", "getmisses", "evictions", "bytesread", "byteswritten", "threads"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        timeoutTracker = new TimeoutTracker(parameters, 0, 3000);
        port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)11211);
        ipv4Addr = svc.getAddress();
        host = ipv4Addr.getHostAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug("polling interface: " + host + timeoutTracker);
        }
        serviceStatus = PollStatus.unavailable();
        timeoutTracker.reset();
        while (timeoutTracker.shouldRetry() && !serviceStatus.isAvailable()) {
            socket = null;
            try {
                block38: {
                    block40: {
                        timeoutTracker.startAttempt();
                        socket = new Socket();
                        socket.connect(new InetSocketAddress(ipv4Addr, port), timeoutTracker.getConnectionTimeout());
                        socket.setSoTimeout(timeoutTracker.getSoTimeout());
                        this.log().debug("connected to host: " + host + " on port: " + port);
                        serviceStatus = PollStatus.unresponsive();
                        osw = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
                        osw.write("stats\n");
                        osw.flush();
                        reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        statProps = new LinkedHashMap<String, Double>();
                        for (String key : MemcachedMonitor.m_keys) {
                            statProps.put(key, null);
                        }
                        line = null;
                        if (reader == null) break block40;
                        while ((line = reader.readLine()) != null) {
                            block41: {
                                statEntry = line.trim().split("\\s", 3);
                                if (!statEntry[0].equals("STAT")) break block41;
                                try {
                                    value /* !! */  = statEntry[2].contains(".") != false ? Double.valueOf(Double.parseDouble(statEntry[2])) : Long.valueOf(Long.parseLong(statEntry[2]));
                                    key = statEntry[1].toLowerCase();
                                    key = key.replaceAll("_", "");
                                    if (key.length() > 19) {
                                        key = key.substring(0, 19);
                                    }
                                    if (statProps.containsKey(key)) {
                                        statProps.put(key, value /* !! */ );
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (Exception e) {}
                                ** GOTO lbl-1000
                            }
                            if (statEntry[0].equals("END")) {
                                serviceStatus = PollStatus.available();
                                osw.write("quit\n");
                                osw.flush();
                            } else if (line != null) continue;
                            break block38;
                        }
                        break block38;
                    }
                    this.log().warn("unable to read after sending stats request");
                }
                serviceStatus.setProperties(statProps);
                serviceStatus.setResponseTime(Double.valueOf(timeoutTracker.elapsedTimeInMillis()));
            }
            catch (ConnectException e) {
                serviceStatus = this.logDown(Level.DEBUG, "Connection refused by host " + host, e);
            }
            catch (NoRouteToHostException e) {
                serviceStatus = this.logDown(Level.INFO, "Unable to test host " + host + ", no route available", e);
            }
            catch (InterruptedIOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "did not connect to host " + host + " within timeout: " + timeoutTracker);
            }
            catch (IOException e) {
                serviceStatus = this.logDown(Level.INFO, "Error communicating with host " + host, e);
            }
            catch (Throwable t) {
                serviceStatus = this.logDown(Level.WARN, "Undeclared throwable exception caught contacting host " + host, t);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                        socket = null;
                    }
                }
                catch (IOException e) {}
            }
            timeoutTracker.nextAttempt();
        }
        return serviceStatus;
    }
}

