/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable(value={DistributionContext.DAEMON})
public final class DiskUsageMonitor
extends SnmpMonitorStrategy {
    private static final String m_serviceName = "DISK-USAGE";
    private static final String hrStorageDescr = ".1.3.6.1.2.1.25.2.3.1.3";
    private static final String hrStorageSize = ".1.3.6.1.2.1.25.2.3.1.5";
    private static final String hrStorageUsed = ".1.3.6.1.2.1.25.2.3.1.6";
    private static final int MATCH_TYPE_EXACT = 0;
    private static final int MATCH_TYPE_STARTSWITH = 1;
    private static final int MATCH_TYPE_ENDSWITH = 2;
    private static final int MATCH_TYPE_REGEX = 3;

    public String serviceName() {
        return m_serviceName;
    }

    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (MarshalException ex) {
            this.log().fatal("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        super.initialize(svc);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        int matchType = 0;
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.available();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        this.log().debug("poll: setting SNMP peer attribute for interface " + ipaddr.getHostAddress());
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        String diskName = ParameterMap.getKeyedString(parameters, (String)"disk", null);
        Integer percentFree = ParameterMap.getKeyedInteger(parameters, (String)"free", (int)15);
        String matchTypeStr = ParameterMap.getKeyedString(parameters, (String)"match-type", (String)"exact");
        if (matchTypeStr.equalsIgnoreCase("exact")) {
            matchType = 0;
        } else if (matchTypeStr.equalsIgnoreCase("startswith")) {
            matchType = 1;
        } else if (matchTypeStr.equalsIgnoreCase("endswith")) {
            matchType = 2;
        } else if (matchTypeStr.equalsIgnoreCase("regex")) {
            matchType = 3;
        } else {
            throw new RuntimeException("Unknown value '" + matchTypeStr + "' for parameter 'match-type'");
        }
        this.log().debug("diskName=" + diskName);
        this.log().debug("percentfree=" + percentFree);
        this.log().debug("matchType=" + matchTypeStr);
        if (this.log().isDebugEnabled()) {
            this.log().debug("poll: service= SNMP address= " + agentConfig);
        }
        try {
            SnmpObjId hrStorageDescrSnmpObject;
            Map flagResults;
            if (this.log().isDebugEnabled()) {
                this.log().debug("DiskUsageMonitor.poll: SnmpAgentConfig address: " + agentConfig);
            }
            if ((flagResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"DiskUsagePoller", (SnmpObjId)(hrStorageDescrSnmpObject = SnmpObjId.get((String)hrStorageDescr)))).size() == 0) {
                this.log().debug("SNMP poll failed: no results, addr=" + ipaddr.getHostAddress() + " oid=" + hrStorageDescrSnmpObject);
                return PollStatus.unavailable();
            }
            for (Map.Entry e : flagResults.entrySet()) {
                this.log().debug("poll: SNMPwalk poll succeeded, addr=" + ipaddr.getHostAddress() + " oid=" + hrStorageDescrSnmpObject + " instance=" + e.getKey() + " value=" + e.getValue());
                if (!this.isMatch(((SnmpValue)e.getValue()).toString(), diskName, matchType)) continue;
                this.log().debug("DiskUsageMonitor.poll: found disk=" + diskName);
                SnmpObjId hrStorageSizeSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.25.2.3.1.5." + ((SnmpInstId)e.getKey()).toString()));
                SnmpObjId hrStorageUsedSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.25.2.3.1.6." + ((SnmpInstId)e.getKey()).toString()));
                SnmpValue snmpSize = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)hrStorageSizeSnmpObject);
                SnmpValue snmpUsed = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)hrStorageUsedSnmpObject);
                float calculatedPercentage = ((float)snmpSize.toLong() - (float)snmpUsed.toLong()) / (float)snmpSize.toLong() * 100.0f;
                this.log().debug("DiskUsageMonitor: calculatedPercentage=" + calculatedPercentage + " percentFree=" + percentFree);
                if (calculatedPercentage < (float)percentFree.intValue()) {
                    return PollStatus.unavailable((String)(diskName + " usage high (" + (100 - (int)calculatedPercentage) + "%)"));
                }
                return status;
            }
            this.log().debug("DiskUsageMonitor: no disks found");
            return PollStatus.unavailable((String)("could not find " + diskName + "in table"));
        }
        catch (NumberFormatException e) {
            status = this.logDown(Level.ERROR, "Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            status = this.logDown(Level.ERROR, "Invalid Snmp Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            status = this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + ipaddr.getHostAddress(), t);
        }
        return status;
    }

    private boolean isMatch(String candidate, String target, int matchType) {
        boolean matches = false;
        this.log().debug("isMessage: candidate is '" + candidate + "', matching against target '" + target + "'");
        if (matchType == 0) {
            this.log().debug("Attempting equality match: candidate '" + candidate + "', target '" + target + "'");
            matches = candidate.equals(target);
        } else if (matchType == 1) {
            this.log().debug("Attempting startsWith match: candidate '" + candidate + "', target '" + target + "'");
            matches = candidate.startsWith(target);
        } else if (matchType == 2) {
            this.log().debug("Attempting endsWith match: candidate '" + candidate + "', target '" + target + "'");
            matches = candidate.endsWith(target);
        } else if (matchType == 3) {
            this.log().debug("Attempting endsWith match: candidate '" + candidate + "', target '" + target + "'");
            matches = Pattern.compile(target).matcher(candidate).find();
        }
        this.log().debug("isMatch: Match is positive");
        return matches;
    }
}

