/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UdpReceivedEvent {
    private String m_eventXML;
    private Log m_log;
    private InetAddress m_sender;
    private int m_port;
    private List<Event> m_ackEvents;

    private UdpReceivedEvent() {
    }

    static UdpReceivedEvent make(DatagramPacket packet) throws UnsupportedEncodingException {
        return UdpReceivedEvent.make(packet.getAddress(), packet.getPort(), packet.getData(), packet.getLength());
    }

    static UdpReceivedEvent make(InetAddress addr, int port, byte[] data, int len) throws UnsupportedEncodingException {
        UdpReceivedEvent e = new UdpReceivedEvent();
        e.m_sender = addr;
        e.m_port = port;
        e.m_eventXML = new String(data, 0, len, "US-ASCII");
        e.m_ackEvents = new ArrayList<Event>(16);
        e.m_log = null;
        return e;
    }

    Log unmarshal() throws ValidationException, MarshalException {
        if (this.m_log == null) {
            StringReader rdr = new StringReader(this.m_eventXML);
            this.m_log = (Log)CastorUtils.unmarshal(Log.class, (Reader)rdr);
        }
        return this.m_log;
    }

    void ackEvent(Event e) {
        if (!this.m_ackEvents.contains(e)) {
            this.m_ackEvents.add(e);
        }
    }

    String getXmlData() {
        return this.m_eventXML;
    }

    InetAddress getSender() {
        return this.m_sender;
    }

    int getPort() {
        return this.m_port;
    }

    public List<Event> getAckedEvents() {
        return this.m_ackEvents;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof UdpReceivedEvent) {
            UdpReceivedEvent e = (UdpReceivedEvent)o;
            return this == e || this.m_port == e.m_port && this.m_sender.equals(e.m_sender);
        }
        return false;
    }

    public int hashCode() {
        return this.m_port ^ this.m_sender.hashCode();
    }
}

