/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.vacuumd.Action;
import org.opennms.netmgt.config.vacuumd.ActionEvent;
import org.opennms.netmgt.config.vacuumd.AutoEvent;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.config.vacuumd.Statement;
import org.opennms.netmgt.config.vacuumd.Trigger;
import org.opennms.netmgt.config.vacuumd.VacuumdConfiguration;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VacuumdConfigFactory {
    private static VacuumdConfigFactory m_singleton = null;
    private static boolean m_loadedFromFile = false;
    private VacuumdConfiguration m_config;

    @Deprecated
    public VacuumdConfigFactory(Reader rdr) throws MarshalException, ValidationException {
        this.m_config = (VacuumdConfiguration)CastorUtils.unmarshal(VacuumdConfiguration.class, (Reader)rdr);
    }

    public VacuumdConfigFactory(InputStream stream) throws MarshalException, ValidationException {
        this.m_config = (VacuumdConfiguration)CastorUtils.unmarshal(VacuumdConfiguration.class, (InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_singleton != null) {
            return;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.VACUUMD_CONFIG_FILE_NAME));
            VacuumdConfigFactory.setInstance(new VacuumdConfigFactory(is));
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        m_loadedFromFile = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        if (m_loadedFromFile) {
            VacuumdConfigFactory.setInstance(null);
            VacuumdConfigFactory.init();
        }
    }

    public static synchronized VacuumdConfigFactory getInstance() {
        Assert.state((m_singleton != null ? 1 : 0) != 0, (String)"The factory has not been initialized");
        return m_singleton;
    }

    public static synchronized void setInstance(VacuumdConfigFactory instance) {
        m_singleton = instance;
    }

    public synchronized Collection<Automation> getAutomations() {
        return this.m_config.getAutomations().getAutomationCollection();
    }

    public synchronized Collection<Trigger> getTriggers() {
        return this.m_config.getTriggers().getTriggerCollection();
    }

    public synchronized Collection<Action> getActions() {
        return this.m_config.getActions().getActionCollection();
    }

    public synchronized Collection<AutoEvent> getAutoEvents() {
        return this.m_config.getAutoEvents().getAutoEventCollection();
    }

    public synchronized Collection<ActionEvent> getActionEvents() {
        return this.m_config.getActionEvents().getActionEventCollection();
    }

    public synchronized int getPeriod() {
        return this.m_config.getPeriod();
    }

    public synchronized Trigger getTrigger(String triggerName) {
        for (Trigger trig : this.getTriggers()) {
            if (!trig.getName().equals(triggerName)) continue;
            return trig;
        }
        return null;
    }

    public synchronized Action getAction(String actionName) {
        for (Action act : this.getActions()) {
            if (!act.getName().equals(actionName)) continue;
            return act;
        }
        return null;
    }

    public synchronized Automation getAutomation(String autoName) {
        for (Automation auto : this.getAutomations()) {
            if (!auto.getName().equals(autoName)) continue;
            return auto;
        }
        return null;
    }

    public synchronized AutoEvent getAutoEvent(String name) {
        for (AutoEvent ae : this.getAutoEvents()) {
            if (!ae.getName().equals(name)) continue;
            return ae;
        }
        return null;
    }

    public synchronized String[] getSqlStatements() {
        Statement[] stmts = this.m_config.getStatement();
        String[] sql = new String[stmts.length];
        for (int i = 0; i < stmts.length; ++i) {
            sql[i] = stmts[i].getContent();
        }
        return sql;
    }

    public synchronized List<Statement> getStatements() {
        return this.m_config.getStatementCollection();
    }

    public ActionEvent getActionEvent(String name) {
        for (ActionEvent actionEvent : this.getActionEvents()) {
            if (!actionEvent.getName().equals(name)) continue;
            return actionEvent;
        }
        return null;
    }
}

