/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceParameters {
    Map<String, String> m_parameters;

    public ServiceParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public String toString() {
        return "domain: " + this.getDomain() + ", " + "storeByNodeID: " + this.getStoreByNodeID() + ", " + "storeByIfAlias: " + this.getStoreByIfAlias() + ", " + "storFlagOverride: " + this.getStorFlagOverride() + ", " + "ifAliasComment: " + this.getIfAliasComment();
    }

    String getDomain() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"domain", (String)"default");
    }

    String getStoreByNodeID() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"storeByNodeID", (String)"normal");
    }

    String getStoreByIfAlias() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"storeByIfAlias", (String)"false");
    }

    String getStorFlagOverride() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"storFlagOverride", (String)"false");
    }

    String getIfAliasComment() {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"ifAliasComment", null);
    }

    boolean aliasesEnabled() {
        return this.getStoreByIfAlias().equals("true");
    }

    boolean overrideStorageFlag() {
        return !this.getStorFlagOverride().equals("false");
    }

    void logIfAliasConfig() {
        this.log().info(this.toString());
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    boolean forceStoreByAlias(String alias) {
        if (alias == null || alias.equals("")) {
            return false;
        }
        String comment = this.getIfAliasComment();
        int si = -1;
        if (comment != null && !comment.equals("")) {
            si = alias.indexOf(comment);
        }
        if (si == 0) {
            return false;
        }
        return this.overrideStorageFlag();
    }

    String getCollectionName() {
        if (this.getParameters().containsKey("collection")) {
            return this.getParameters().get("collection");
        }
        if (this.getParameters().containsKey("http-collection")) {
            return this.getParameters().get("http-collection");
        }
        if (this.getParameters().containsKey("nsclient-collection")) {
            return this.getParameters().get("nsclient-collection");
        }
        if (this.m_parameters.containsKey("wmi-collection")) {
            return this.m_parameters.get("wmi-collection");
        }
        return "default";
    }

    int getSnmpPort(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)"port", (int)current);
    }

    int getSnmpRetries(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)"retry", (int)current);
    }

    int getSnmpTimeout(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)"timeout", (int)current);
    }

    String getSnmpReadCommunity(String current) {
        String readCommunity = ParameterMap.getKeyedString(this.getParameters(), (String)"read-community", null);
        if (readCommunity == null) {
            readCommunity = ParameterMap.getKeyedString(this.m_parameters, (String)"readCommunity", (String)current);
        }
        return readCommunity;
    }

    String getSnmpWriteCommunity(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"write-community", (String)current);
    }

    InetAddress getSnmpProxyFor(InetAddress current) {
        String address = ParameterMap.getKeyedString(this.getParameters(), (String)"proxy-host", null);
        if (address != null) {
            try {
                return InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                this.log().error("determineProxyHost: Problem converting proxy host string to InetAddress", (Throwable)e);
            }
        }
        return current;
    }

    int getSnmpVersion(int current) {
        String version = ParameterMap.getKeyedString(this.getParameters(), (String)"version", null);
        if (version != null) {
            if (version.equals("v1")) {
                return 1;
            }
            if (version.equals("v2c")) {
                return 2;
            }
            if (version.equals("v3")) {
                return 3;
            }
        }
        return current;
    }

    int getSnmpMaxVarsPerPdu(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)"max-vars-per-pdu", (int)current);
    }

    int getSnmpMaxRepetitions(int current) {
        int maxRepetitions = ParameterMap.getKeyedInteger(this.m_parameters, (String)"max-repetitions", (int)-1);
        if (maxRepetitions == -1) {
            maxRepetitions = ParameterMap.getKeyedInteger(this.m_parameters, (String)"maxRepetitions", (int)current);
        }
        return maxRepetitions;
    }

    int getSnmpMaxRequestSize(int current) {
        return ParameterMap.getKeyedInteger(this.getParameters(), (String)"max-request-size", (int)current);
    }

    String getSnmpSecurityName(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"security-name", (String)current);
    }

    String getSnmpAuthPassPhrase(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"auth-passphrase", (String)current);
    }

    String getSnmpAuthProtocol(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"auth-protocol", (String)current);
    }

    String getSnmpPrivPassPhrase(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"privacy-passphrase", (String)current);
    }

    String getSnmpPrivProtocol(String current) {
        return ParameterMap.getKeyedString(this.getParameters(), (String)"privacy-protocol", (String)current);
    }
}

