/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.Map;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.model.RrdRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IfInfo
extends SnmpCollectionResource {
    private SNMPCollectorEntry m_entry;
    private String m_ifAlias;
    private SnmpIfData m_snmpIfData;

    public IfInfo(ResourceType def, CollectionAgent agent, SnmpIfData snmpIfData) {
        super(def);
        this.m_snmpIfData = snmpIfData;
        this.m_ifAlias = snmpIfData.getIfAlias();
    }

    private int getNodeId() {
        return this.m_snmpIfData.getNodeId();
    }

    public int getIndex() {
        return this.m_snmpIfData.getIfIndex();
    }

    @Override
    public int getType() {
        return this.m_snmpIfData.getIfType();
    }

    @Override
    public String getLabel() {
        return this.m_snmpIfData.getLabelForRRD();
    }

    public void setIfAlias(String ifAlias) {
        this.m_ifAlias = ifAlias;
    }

    String getCurrentIfAlias() {
        return this.m_ifAlias;
    }

    public boolean isCollectionEnabled() {
        return this.m_snmpIfData.isCollectionEnabled();
    }

    public void setEntry(SNMPCollectorEntry ifEntry) {
        this.m_entry = ifEntry;
    }

    protected SNMPCollectorEntry getEntry() {
        return this.m_entry;
    }

    public Map<String, String> getAttributesMap() {
        return this.m_snmpIfData.getAttribtuesMap();
    }

    String getNewIfAlias() {
        if (this.getEntry() == null) {
            return this.getCurrentIfAlias();
        }
        return this.getEntry().getValueForBase(".1.3.6.1.2.1.31.1.1.1.18");
    }

    boolean currentAliasIsOutOfDate(String ifAlias) {
        this.log().debug("currentAliasIsOutOfDate: ifAlias from collection = " + ifAlias + ", current ifAlias = " + this.getCurrentIfAlias());
        return ifAlias != null && !ifAlias.equals(this.getCurrentIfAlias());
    }

    void logAlias(String ifAlias) {
        ThreadCategory log = this.log();
        if (log.isDebugEnabled()) {
            log.debug("Alias for RRD directory name = " + ifAlias);
        }
    }

    String getAliasDir(String ifAlias, String ifAliasComment) {
        if (ifAlias != null) {
            int si;
            if (ifAliasComment != null && (si = ifAlias.indexOf(ifAliasComment)) > -1) {
                ifAlias = ifAlias.substring(0, si).trim();
            }
            if (ifAlias != null) {
                ifAlias = AlphaNumeric.parseAndReplaceExcept((String)ifAlias, (char)'_', (String)"-._");
            }
        }
        this.logAlias(ifAlias);
        return ifAlias;
    }

    void logForceRescan(String ifAlias) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("Forcing rescan.  IfAlias " + ifAlias + " for index " + this.getIndex() + " does not match DB value: " + this.getCurrentIfAlias());
        }
    }

    boolean isScheduledForCollection() {
        this.log().debug(this + ".collectionEnabled = " + this.isCollectionEnabled());
        this.log().debug("selectCollectionOnly = " + this.getCollection().isSelectCollectionOnly());
        boolean isScheduled = this.isCollectionEnabled() || !this.getCollection().isSelectCollectionOnly();
        this.log().debug("isScheduled = " + isScheduled);
        return isScheduled;
    }

    private OnmsSnmpCollection getCollection() {
        return this.getResourceType().getCollection();
    }

    @Override
    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, String.valueOf(this.getNodeId()));
        File ifDir = new File(nodeDir, this.getLabel());
        return ifDir;
    }

    public String toString() {
        return "node[" + this.getNodeId() + "].interfaceSnmp[" + this.getLabel() + ']';
    }

    boolean shouldStore(ServiceParameters serviceParameters) {
        if (serviceParameters.getStoreByNodeID().equals("normal")) {
            return this.isScheduledForCollection();
        }
        return serviceParameters.getStoreByNodeID().equals("true");
    }

    @Override
    public boolean shouldPersist(ServiceParameters serviceParameters) {
        boolean shdprsist = this.shouldStore(serviceParameters) && (this.isScheduledForCollection() || serviceParameters.forceStoreByAlias(this.getCurrentIfAlias()));
        this.log().debug("shouldPersist = " + shdprsist);
        return shdprsist;
    }

    @Override
    public String getResourceTypeName() {
        return "if";
    }

    @Override
    public String getInstance() {
        return Integer.toString(this.getIndex());
    }
}

