/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.CollectdConfig;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.dao.CollectorConfigDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorConfigDaoImpl
implements CollectorConfigDao {
    public CollectorConfigDaoImpl() {
        this.loadConfigFactory();
    }

    private void loadConfigFactory() {
        try {
            CollectdConfigFactory.init();
        }
        catch (MarshalException ex) {
            this.log().fatal("loadConfigFactory: Failed to load collectd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal("loadConfigFactory: Failed to load collectd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal("loadConfigFactory: Failed to load collectd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private CollectdConfig getConfig() {
        return CollectdConfigFactory.getInstance().getCollectdConfig();
    }

    public int getSchedulerThreads() {
        return this.getConfig().getThreads();
    }

    public Collection<Collector> getCollectors() {
        return this.getConfig().getConfig().getCollectorCollection();
    }

    public void rebuildPackageIpListMap() {
        this.getConfig().rebuildPackageIpListMap();
    }

    public Collection<CollectdPackage> getPackages() {
        return this.getConfig().getPackages();
    }

    public CollectdPackage getPackage(String name) {
        return this.getConfig().getPackage(name);
    }
}

