/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.util.HashSet;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.capsd.FailedOperationException;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.utils.XmlrpcUtil;
import org.opennms.netmgt.xml.event.Event;

@Aspect
public class XmlRpcEventHandlerNotifier {
    private Set<String> m_notifySet = new HashSet<String>();
    private boolean m_xmlRpcEnabled;

    @Pointcut(value="execution(* org.opennms.netmgt.capsd.BroadcastEventProcessor.*(..))")
    public void capsdMethod() {
    }

    @Pointcut(value="@annotation(org.opennms.netmgt.model.events.annotations.EventHandler)")
    public void eventHandler() {
    }

    @Pointcut(value="capsdMethod() && eventHandler()")
    public void capsdEventHandler() {
    }

    @Around(value="capsdEventHandler() && args(event)")
    public void onEvent(ProceedingJoinPoint pjp, Event event) throws Throwable {
        this.notifyEventReceived(event);
        try {
            pjp.proceed();
            this.notifyEventSuccess(event);
        }
        catch (InsufficientInformationException ex) {
            this.handleInsufficientInformationException(event, ex);
        }
        catch (FailedOperationException ex) {
            this.handleFailedOperationException(event, ex);
        }
    }

    public XmlRpcEventHandlerNotifier() {
        this.m_notifySet.add("uei.opennms.org/internal/capsd/addNode");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/deleteNode");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/addInterface");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/deleteInterface");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/changeService");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/updateServer");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/updateService");
    }

    public boolean isXmlRpcEnabled() {
        return this.m_xmlRpcEnabled;
    }

    public void setXmlRpcEnabled(boolean xmlRpcEnabled) {
        this.m_xmlRpcEnabled = xmlRpcEnabled;
    }

    private void handleFailedOperationException(Event event, FailedOperationException ex) {
        this.log().error("BroadcastEventProcessor: operation failed for event: " + event.getUei() + ", exception: " + ex.getMessage());
        this.notifyEventError(event, "processing failed: ", ex);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void handleInsufficientInformationException(Event event, InsufficientInformationException ex) {
        this.log().info("BroadcastEventProcessor: insufficient information in event, discarding it: " + ex.getMessage());
        this.notifyEventError(event, "Invalid parameters: ", ex);
    }

    private void notifyEventSuccess(Event event) {
        if (!this.isXmlRpcEnabled()) {
            return;
        }
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        if (txNo != -1L && this.m_notifySet.contains(event.getUei())) {
            StringBuffer message = new StringBuffer("Completed processing event: ");
            message.append(event.getUei());
            message.append(" : ");
            message.append(event);
            int status = 1;
            XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, event.getUei(), message.toString(), status, "OpenNMS.Capsd");
        }
    }

    private void notifyEventError(Event event, String msg, Exception ex) {
        if (!this.isXmlRpcEnabled()) {
            return;
        }
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        if (txNo != -1L && this.m_notifySet.contains(event.getUei())) {
            int status = 2;
            XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, event.getUei(), msg + ex.getMessage(), status, "OpenNMS.Capsd");
        }
    }

    private void notifyEventReceived(Event event) {
        if (!this.isXmlRpcEnabled()) {
            return;
        }
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        if (txNo != -1L && this.m_notifySet.contains(event.getUei())) {
            StringBuffer message = new StringBuffer("Received event: ");
            message.append(event.getUei());
            message.append(" : ");
            message.append(event);
            int status = 0;
            XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, event.getUei(), message.toString(), status, "OpenNMS.Capsd");
        }
    }
}

