/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.BadlyFormattedFlowExecutionKeyException;

public class CompositeFlowExecutionKey
extends FlowExecutionKey {
    private static final String EXECUTION_ID_PREFIX = "e";
    private static final String SNAPSHOT_ID_PREFIX = "s";
    private static final String FORMAT = "e<executionId>s<snapshotId>";
    private Serializable executionId;
    private Serializable snapshotId;

    public CompositeFlowExecutionKey(Serializable executionId, Serializable snapshotId) {
        Assert.notNull((Object)executionId, (String)"The execution id is required");
        Assert.notNull((Object)snapshotId, (String)"The snapshot id is required");
        this.executionId = executionId;
        this.snapshotId = snapshotId;
    }

    public Serializable getExecutionId() {
        return this.executionId;
    }

    public Serializable getSnapshotId() {
        return this.snapshotId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeFlowExecutionKey)) {
            return false;
        }
        CompositeFlowExecutionKey other = (CompositeFlowExecutionKey)obj;
        return this.executionId.equals(other.executionId) && this.snapshotId.equals(other.snapshotId);
    }

    public int hashCode() {
        return this.executionId.hashCode() + this.snapshotId.hashCode();
    }

    public String toString() {
        return EXECUTION_ID_PREFIX + this.executionId + SNAPSHOT_ID_PREFIX + this.snapshotId;
    }

    public static String getFormat() {
        return FORMAT;
    }

    public static String[] keyParts(String encodedKey) throws BadlyFormattedFlowExecutionKeyException {
        if (!encodedKey.startsWith(EXECUTION_ID_PREFIX)) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, FORMAT);
        }
        int snapshotStart = encodedKey.indexOf(SNAPSHOT_ID_PREFIX, EXECUTION_ID_PREFIX.length());
        if (snapshotStart == -1) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, FORMAT);
        }
        String executionId = encodedKey.substring(EXECUTION_ID_PREFIX.length(), snapshotStart);
        String snapshotId = encodedKey.substring(snapshotStart + SNAPSHOT_ID_PREFIX.length());
        return new String[]{executionId, snapshotId};
    }
}

