/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.core.AnnotatedObject;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.WildcardTransitionCriteria;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;

public class Transition
extends AnnotatedObject
implements TransitionDefinition {
    protected final Log logger;
    private TransitionCriteria matchingCriteria;
    private TransitionCriteria executionCriteria;
    private TargetStateResolver targetStateResolver;
    static /* synthetic */ Class class$0;

    public Transition() {
        this(WildcardTransitionCriteria.INSTANCE, null);
    }

    public Transition(TargetStateResolver targetStateResolver) {
        this(WildcardTransitionCriteria.INSTANCE, targetStateResolver);
    }

    public Transition(TransitionCriteria matchingCriteria, TargetStateResolver targetStateResolver) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.engine.Transition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.executionCriteria = WildcardTransitionCriteria.INSTANCE;
        this.setMatchingCriteria(matchingCriteria);
        this.setTargetStateResolver(targetStateResolver);
    }

    public String getId() {
        return this.matchingCriteria.toString();
    }

    public String getTargetStateId() {
        if (this.targetStateResolver != null) {
            return this.targetStateResolver.toString();
        }
        return null;
    }

    public TransitionCriteria getMatchingCriteria() {
        return this.matchingCriteria;
    }

    public void setMatchingCriteria(TransitionCriteria matchingCriteria) {
        Assert.notNull((Object)matchingCriteria, (String)"The criteria for matching this transition is required");
        this.matchingCriteria = matchingCriteria;
    }

    public TransitionCriteria getExecutionCriteria() {
        return this.executionCriteria;
    }

    public void setExecutionCriteria(TransitionCriteria executionCriteria) {
        this.executionCriteria = executionCriteria;
    }

    public TargetStateResolver getTargetStateResolver() {
        return this.targetStateResolver;
    }

    public void setTargetStateResolver(TargetStateResolver targetStateResolver) {
        this.targetStateResolver = targetStateResolver;
    }

    public boolean matches(RequestContext context) {
        return this.matchingCriteria.test(context);
    }

    public boolean canExecute(RequestContext context) {
        if (this.executionCriteria != null) {
            return this.executionCriteria.test(context);
        }
        return false;
    }

    public boolean execute(State sourceState, RequestControlContext context) throws FlowExecutionException {
        if (this.canExecute(context)) {
            State targetState;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing " + this));
            }
            context.setCurrentTransition(this);
            if (this.targetStateResolver != null && (targetState = this.targetStateResolver.resolveTargetState(this, sourceState, context)) != null) {
                if (sourceState != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Exiting state '" + sourceState.getId() + "'"));
                    }
                    if (sourceState instanceof TransitionableState) {
                        ((TransitionableState)sourceState).exit(context);
                    }
                }
                targetState.enter(context);
                if (this.logger.isDebugEnabled()) {
                    if (context.getFlowExecutionContext().isActive()) {
                        this.logger.debug((Object)("Completed transition execution.  As a result, the new state is '" + context.getCurrentState().getId() + "' in flow '" + context.getActiveFlow().getId() + "'"));
                    } else {
                        this.logger.debug((Object)"Completed transition execution.  As a result, the flow execution has ended");
                    }
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("on", (Object)this.getMatchingCriteria()).append("to", (Object)this.getTargetStateResolver()).toString();
    }
}

