/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.ActionResultExposer;
import org.springframework.webflow.action.ResultEventFactory;
import org.springframework.webflow.action.ResultEventFactorySelector;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ActionExecutor;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class EvaluateAction
extends AbstractAction {
    private Expression expression;
    private ActionResultExposer evaluationResultExposer;
    private ResultEventFactory resultEventFactory;

    public EvaluateAction(Expression expression, ActionResultExposer evaluationResultExposer) {
        this.init(expression, evaluationResultExposer, null);
    }

    public EvaluateAction(Expression expression, ActionResultExposer evaluationResultExposer, ResultEventFactory resultEventFactory) {
        this.init(expression, evaluationResultExposer, resultEventFactory);
    }

    protected Event doExecute(RequestContext context) throws Exception {
        Object result = this.expression.getValue((Object)context);
        if (result instanceof Action) {
            return ActionExecutor.execute((Action)result, context);
        }
        if (this.evaluationResultExposer != null) {
            this.evaluationResultExposer.exposeResult(result, context);
        }
        return this.resultEventFactory.createResultEvent(this, result, context);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("expression", (Object)this.expression).append("resultExposer", (Object)this.evaluationResultExposer).toString();
    }

    private void init(Expression expression, ActionResultExposer evaluationResultExposer, ResultEventFactory resultEventFactory) {
        Assert.notNull((Object)expression, (String)"The expression this action should evaluate is required");
        this.expression = expression;
        this.evaluationResultExposer = evaluationResultExposer;
        this.resultEventFactory = resultEventFactory != null ? resultEventFactory : new DefaultResultEventFactory();
    }

    private class DefaultResultEventFactory
    implements ResultEventFactory {
        private ResultEventFactorySelector selector = new ResultEventFactorySelector();

        private DefaultResultEventFactory() {
        }

        public Event createResultEvent(Object source, Object resultObject, RequestContext context) {
            return this.selector.forResult(resultObject).createResultEvent(source, resultObject, context);
        }
    }
}

