/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.netmgt.config.RWSConfigManager;

public final class RWSConfigFactory
extends RWSConfigManager {
    private static RWSConfig m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    @Deprecated
    public RWSConfigFactory(long currentVersion, FileReader reader) throws MarshalException, ValidationException, IOException {
        super(reader);
        this.m_currentVersion = currentVersion;
    }

    public RWSConfigFactory(long currentVersion, InputStream stream) throws MarshalException, ValidationException, IOException {
        super(stream);
        this.m_currentVersion = currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RWS_CONFIG_FILE_NAME);
        RWSConfigFactory.logStatic().debug("init: config file path: " + cfgFile.getPath());
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(cfgFile);
            RWSConfigFactory config = new RWSConfigFactory(cfgFile.lastModified(), stream);
            RWSConfigFactory.setInstance(config);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    private static ThreadCategory logStatic() {
        return ThreadCategory.getInstance(RWSConfigFactory.class);
    }

    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            long timestamp = System.currentTimeMillis();
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RWS_CONFIG_FILE_NAME);
            RWSConfigFactory.logStatic().debug("saveXml: saving config file at " + timestamp + ": " + cfgFile.getPath());
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
            RWSConfigFactory.logStatic().debug("saveXml: finished saving config file: " + cfgFile.getPath());
        }
    }

    public static synchronized RWSConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(RWSConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RWS_CONFIG_FILE_NAME);
        if (cfgFile.lastModified() > this.m_currentVersion) {
            this.m_currentVersion = cfgFile.lastModified();
            RWSConfigFactory.logStatic().debug("init: config file path: " + cfgFile.getPath());
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(cfgFile);
                this.reloadXML(stream);
            }
            finally {
                if (stream != null) {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
            RWSConfigFactory.logStatic().debug("init: finished loading config file: " + cfgFile.getPath());
        }
    }
}

