/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.tree;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.bean.Export;
import org.extremecomponents.table.bean.Row;
import org.extremecomponents.table.bean.Table;
import org.extremecomponents.table.calc.CalcResult;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.View;
import org.extremecomponents.table.view.html.BuilderUtils;
import org.extremecomponents.tree.HtmlViewUtils;
import org.extremecomponents.tree.TreeRegistryUtils;
import org.extremecomponents.util.ExtremeUtils;
import org.extremecomponents.util.HtmlBuilder;

public class HtmlView
extends HtmlBuilder
implements View {
    public static final String TOOLBAR = "toolbar";
    public static final String SEPARATOR = "separator";
    public static final String STATUS_BAR = "statusBar";
    public static final String FILTER_BUTTONS = "filterButtons";
    public static final String FORM_BUTTONS = "formButtons";
    public static final String FILTER = "filter";
    public static final String TITLE = "title";
    public static final String TABLE_TOTAL_TITLE = "tableTotalTitle";
    public static final String TABLE_TOTALS = "tableTotal";
    public static final String TABLE_TOTALS_EMPTY = "tableTotalEmpty";
    public static final String TABLE_BODY = "tableBody";
    public static final String LAST_PAGE = "lastPage";
    public static final String LAST_PAGE_DISABLED = "lastPageDisabled";
    public static final String FIRST_PAGE = "firstPage";
    public static final String FIRST_PAGE_DISABLED = "firstPageDisabled";
    public static final String PREV_PAGE = "prevPage";
    public static final String PREV_PAGE_DISABLED = "prevPageDisabled";
    public static final String NEXT_PAGE = "nextPage";
    public static final String NEXT_PAGE_DISABLED = "nextPageDisabled";
    public static final String SEARCH_ARROW_IMAGE = "searchArrow";
    public static final String SEARCH_IMAGE = "search";
    public static final String CLEAR_IMAGE = "clear";

    public void beforeBody(TableModel model) {
        this.div().styleClass("eXtremeTable").close();
        this.toolbarPlacement(model);
        this.tableStart(model);
        this.statusBar(model);
        this.filter(model);
        this.header(model);
        this.tbody(1).styleClass(TABLE_BODY).close();
    }

    public void body(TableModel model, Column column) {
        if (column.isFirstColumn()) {
            this.tr(1);
            if (model.getRowHandler().isRowEven()) {
                this.rowStyleAndJavascript(model, "even");
            } else {
                this.rowStyleAndJavascript(model, "odd");
            }
            this.close();
        }
        this.append(column.getCellDisplay());
        if (column.isLastColumn()) {
            this.trEnd(1);
        }
    }

    public Object afterBody(TableModel model) {
        this.totals(model);
        this.tbodyEnd(1);
        this.tableEnd(model);
        this.newline().divEnd();
        return this.toString();
    }

    private void rowStyleAndJavascript(TableModel model, String defaultStyleClass) {
        Row row = model.getRowHandler().getRow();
        String styleClass = row.getStyleClass();
        String style = row.getStyle();
        if (StringUtils.isBlank((String)styleClass)) {
            styleClass = defaultStyleClass;
        }
        this.styleClass(styleClass);
        this.style(style);
        this.onclick(row.getOnclick());
        boolean highlightRow = row.isHighlightRow();
        if (highlightRow) {
            String highlightClass = row.getHighlightClass();
            if (StringUtils.isNotBlank((String)row.getOnmouseover())) {
                this.onmouseover("this.className='" + highlightClass + "'; " + row.getOnmouseover());
            } else {
                this.onmouseover("this.className='" + highlightClass + "'");
            }
            if (StringUtils.isNotBlank((String)row.getOnmouseout())) {
                this.onmouseout("this.className='" + styleClass + "'; " + row.getOnmouseout());
            } else {
                this.onmouseout("this.className='" + styleClass + "'");
            }
        } else {
            this.onmouseover(row.getOnmouseover());
            this.onmouseout(row.getOnmouseout());
        }
    }

    public void toolbarPlacement(TableModel model) {
        boolean showPagination = model.getTableHandler().getTable().isShowPagination();
        boolean showExports = model.getExportHandler().showExports();
        if (!showPagination && !showExports && StringUtils.isBlank((String)model.getTableHandler().getTable().getTitle())) {
            return;
        }
        this.table(0).border("0").cellPadding("0").cellSpacing("0");
        this.width(model.getTableHandler().getTable().getWidth()).close();
        this.tr(1).close();
        this.td(2).styleClass(TITLE).close();
        this.title(model);
        this.tdEnd();
        this.td(2).align("right").close();
        this.toolbar(model);
        this.tdEnd();
        this.trEnd(1);
        this.tableEnd(0);
        this.newline();
    }

    public void title(TableModel model) {
        String title = model.getTableHandler().getTable().getTitle();
        if (StringUtils.isNotBlank((String)title)) {
            this.span().close().append(title).spanEnd();
        }
    }

    public void toolbar(TableModel model) {
        boolean showPagination = model.getTableHandler().getTable().isShowPagination();
        boolean showExports = model.getExportHandler().showExports();
        if (!showPagination && !showExports) {
            return;
        }
        this.table(2).border("0").cellPadding("0").cellSpacing("1").styleClass(TOOLBAR).close();
        this.tr(3).close();
        this.toolbarFormStart(model);
        if (showPagination) {
            this.toolbarPaginationIcons(model);
            String separator = BuilderUtils.getImage(model, SEPARATOR);
            this.td(4).rowSpan("2").styleClass(SEPARATOR).close().img(separator).tdEnd();
            this.rowsDisplayedDroplist(model);
            if (showExports) {
                this.td(4).rowSpan("2").styleClass(SEPARATOR).close().img(separator).tdEnd();
            }
        }
        if (showExports) {
            this.toolbarExportIcons(model);
        }
        this.trEnd(3);
        this.tr(3).close();
        this.formEnd();
        this.trEnd(3);
        this.tableEnd(2);
        this.newline();
        this.tabs(2);
    }

    private void toolbarFormStart(TableModel model) {
        this.form();
        this.name(model.getTableHandler().prefixWithTableId() + TOOLBAR);
        String action = model.getTableHandler().getTable().getAction();
        if (StringUtils.isNotEmpty((String)action)) {
            this.action(action);
        }
        this.close();
        String hiddenFields = TreeRegistryUtils.getFormHiddenFields(model, true, true, false, false);
        if (StringUtils.isNotEmpty((String)hiddenFields)) {
            this.append(hiddenFields);
        }
    }

    public void toolbarPaginationIcons(TableModel model) {
        String lastPageImage;
        String nextPageImage;
        String prevPageImage;
        String firstPageImage;
        int page = model.getLimit().getPage();
        int totalPages = BuilderUtils.getTotalPages(model);
        this.td(4).close();
        if (!BuilderUtils.isFirstPageEnabled(page)) {
            firstPageImage = BuilderUtils.getImage(model, FIRST_PAGE_DISABLED);
            this.img(firstPageImage);
        } else {
            firstPageImage = BuilderUtils.getImage(model, FIRST_PAGE);
            String firstPageTooltip = model.getMessages().getMessage("toolbar.tooltip.firstPage");
            this.paginationImage(model, 1, firstPageImage, firstPageTooltip);
        }
        this.tdEnd();
        this.td(4).close();
        if (!BuilderUtils.isPrevPageEnabled(page)) {
            prevPageImage = BuilderUtils.getImage(model, PREV_PAGE_DISABLED);
            this.img(prevPageImage);
        } else {
            prevPageImage = BuilderUtils.getImage(model, PREV_PAGE);
            String prevPageTooltip = model.getMessages().getMessage("toolbar.tooltip.prevPage");
            this.paginationImage(model, page - 1, prevPageImage, prevPageTooltip);
        }
        this.tdEnd();
        this.td(4).close();
        if (!BuilderUtils.isNextPageEnabled(page, totalPages)) {
            nextPageImage = BuilderUtils.getImage(model, NEXT_PAGE_DISABLED);
            this.img(nextPageImage);
        } else {
            nextPageImage = BuilderUtils.getImage(model, NEXT_PAGE);
            String nextPageTooltip = model.getMessages().getMessage("toolbar.tooltip.nextPage");
            this.paginationImage(model, page + 1, nextPageImage, nextPageTooltip);
        }
        this.tdEnd();
        this.td(4).close();
        if (!BuilderUtils.isLastPageEnabled(page, totalPages)) {
            lastPageImage = BuilderUtils.getImage(model, LAST_PAGE_DISABLED);
            this.img(lastPageImage);
        } else {
            lastPageImage = BuilderUtils.getImage(model, LAST_PAGE);
            String lastPageTooltip = model.getMessages().getMessage("toolbar.tooltip.lastPage");
            this.paginationImage(model, totalPages, lastPageImage, lastPageTooltip);
        }
        this.tdEnd();
    }

    public void paginationImage(TableModel model, int page, String image, String tooltip) {
        this.a();
        this.quote();
        String action = model.getTableHandler().getTable().getAction();
        if (StringUtils.isNotEmpty((String)action)) {
            this.append(action);
        }
        this.question().append(model.getTableHandler().prefixWithTableId()).append("p").equals().append("" + page);
        this.append(TreeRegistryUtils.getURLParameterString(model, true, true, false, true));
        this.quote().close();
        this.img(image, tooltip);
        this.aEnd();
    }

    public void toolbarExportIcons(TableModel model) {
        Iterator iter = model.getExportHandler().getExports().iterator();
        while (iter.hasNext()) {
            this.td(4).close();
            Export export = (Export)iter.next();
            this.exportImage(model, export);
            this.tdEnd();
        }
    }

    public void rowsDisplayedDroplist(TableModel model) {
        int rowsDisplayed = model.getTableHandler().getTable().getRowsDisplayed();
        int medianRowsDisplayed = model.getTableHandler().getTable().getMedianRowsDisplayed();
        int maxRowsDisplayed = model.getTableHandler().getTable().getMaxRowsDisplayed();
        int currentRowsDisplayed = model.getLimit().getCurrentRowsDisplayed();
        this.td(4).width("20").close();
        this.newline();
        this.tabs(4);
        this.select().name(model.getTableHandler().prefixWithTableId() + "crd");
        StringBuffer onchange = new StringBuffer();
        onchange.append(HtmlViewUtils.paginationJavaScript(model));
        this.onchange(onchange.toString());
        this.close();
        this.newline();
        this.tabs(4);
        this.option().value(String.valueOf(rowsDisplayed));
        if (currentRowsDisplayed == rowsDisplayed) {
            this.append(" selected");
        }
        this.close();
        this.append(String.valueOf(rowsDisplayed));
        this.optionEnd();
        this.option().value(String.valueOf(medianRowsDisplayed));
        if (currentRowsDisplayed == medianRowsDisplayed) {
            this.append(" selected");
        }
        this.close();
        this.append(String.valueOf(medianRowsDisplayed));
        this.optionEnd();
        this.option().value(String.valueOf(maxRowsDisplayed));
        if (currentRowsDisplayed == maxRowsDisplayed) {
            this.append(" selected");
        }
        this.close();
        this.append(String.valueOf(maxRowsDisplayed));
        this.optionEnd();
        this.newline();
        this.tabs(4);
        this.selectEnd();
        this.img(BuilderUtils.getImage(model, "rowsDisplayed"));
        this.tdEnd();
    }

    private void exportImage(TableModel model, Export export) {
        this.a();
        this.quote();
        String action = model.getTableHandler().getTable().getAction();
        if (StringUtils.isNotEmpty((String)action)) {
            this.append(action);
        }
        this.question().append("ec_eti").equals().append(model.getTableHandler().getTable().getTableId()).ampersand().append(model.getTableHandler().prefixWithTableId() + "ev").equals().append(export.getView()).ampersand().append(model.getTableHandler().prefixWithTableId() + "efn").equals().append(export.getFileName());
        this.append(TreeRegistryUtils.getURLParameterString(model, true, true, true, true));
        this.quote();
        this.close();
        String imageName = BuilderUtils.getImage(model, export.getImageName());
        if (StringUtils.isNotEmpty((String)imageName)) {
            String tooltip = export.getTooltip();
            if (StringUtils.isEmpty((String)tooltip)) {
                this.img(imageName);
            } else {
                this.img(imageName, tooltip);
            }
        } else {
            this.nbsp().append(export.getView()).nbsp();
        }
        this.aEnd();
    }

    public void statusBar(TableModel model) {
        if (!model.getTableHandler().getTable().isShowStatusBar() && !model.getTableHandler().getTable().isFilterable()) {
            return;
        }
        this.tr(1).close();
        this.td(2).colSpan(String.valueOf(model.getColumnHandler().columnCount())).close();
        this.table(2).border("0").cellPadding("0").cellSpacing("0").width("100%").close();
        this.tr(3).close();
        if (model.getTableHandler().getTable().isShowStatusBar()) {
            this.td(4).styleClass(STATUS_BAR).close();
            if (model.getLimit().getTotalRows() == 0) {
                this.append(model.getMessages().getMessage("statusbar.noResultsFound"));
            } else {
                Integer total = new Integer(model.getLimit().getTotalRows());
                Integer from = new Integer(model.getLimit().getRowStart() + 1);
                Integer to = new Integer(model.getLimit().getRowEnd());
                Object[] messageArguments = new Object[]{total, from, to};
                this.append(model.getMessages().getMessage("statusbar.resultsFound", messageArguments));
            }
            this.tdEnd();
        }
        if (model.getTableHandler().getTable().isFilterable()) {
            this.td(4).styleClass(FILTER_BUTTONS).close();
            String imageSearchArrow = BuilderUtils.getImage(model, SEARCH_ARROW_IMAGE);
            this.img(imageSearchArrow);
            this.nbsp();
            this.a().quote().append(HtmlViewUtils.filterJavaScript(model)).quote().close();
            String imageSearch = BuilderUtils.getImage(model, SEARCH_IMAGE);
            if (StringUtils.isNotEmpty((String)imageSearch)) {
                String searchTooltip = model.getMessages().getMessage("toolbar.tooltip.filter");
                this.img(imageSearch, searchTooltip);
            } else {
                this.append("&nbsp;Filter&nbsp;");
            }
            this.aEnd();
            this.nbsp();
            this.a().quote().append("javascript:document.forms." + model.getTableHandler().prefixWithTableId() + "filter." + model.getTableHandler().prefixWithTableId() + "f_" + "a" + ".value='" + "ca" + "';document.forms." + model.getTableHandler().prefixWithTableId() + "filter.submit()").quote().close();
            String imageClear = BuilderUtils.getImage(model, CLEAR_IMAGE);
            if (StringUtils.isNotEmpty((String)imageClear)) {
                String clearTooltip = model.getMessages().getMessage("toolbar.tooltip.clear");
                this.img(imageClear, clearTooltip);
            } else {
                this.append("&nbsp;Clear&nbsp;");
            }
            this.aEnd();
            this.tdEnd();
        }
        this.trEnd(3);
        this.tableEnd(2);
        this.newline();
        this.tabs(2);
        this.tdEnd();
        this.trEnd(1);
        this.tabs(2);
        this.newline();
    }

    public void tableStart(TableModel model) {
        Table table = model.getTableHandler().getTable();
        this.table(0);
        this.id(table.getTableId());
        this.border(table.getBorder());
        this.cellSpacing(table.getCellspacing());
        this.cellPadding(table.getCellpadding());
        this.width(table.getWidth());
        this.styleClass(table.getStyleClass());
        this.style(table.getStyle());
        this.close();
    }

    public void tableEnd(TableModel model) {
        this.tableEnd(0);
    }

    public void header(TableModel model) {
        this.tr(1).close();
        List columns = model.getColumnHandler().getHeaderColumns();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            this.append(column.getCellDisplay());
        }
        this.trEnd(1);
    }

    public void filter(TableModel model) {
        if (!model.getTableHandler().getTable().isFilterable()) {
            return;
        }
        this.filterFormStart(model);
        this.tr(1).styleClass(FILTER).id(FILTER).close();
        List columns = model.getColumnHandler().getFilterColumns();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            this.append(column.getCellDisplay());
        }
        this.trEnd(1);
        this.formEnd();
    }

    private void filterFormStart(TableModel model) {
        this.form();
        this.name(model.getTableHandler().prefixWithTableId() + FILTER);
        String action = model.getTableHandler().getTable().getAction();
        if (StringUtils.isNotEmpty((String)action)) {
            this.action(action);
        }
        this.close();
        this.input("hidden").name(model.getTableHandler().prefixWithTableId() + "f_" + "a").close();
        String hiddenFields = TreeRegistryUtils.getFormHiddenFields(model, false, true, false, true);
        if (StringUtils.isNotEmpty((String)hiddenFields)) {
            this.append(hiddenFields);
        }
    }

    public void totals(TableModel model) {
        Column calcColumn = model.getColumnHandler().getFirstCalcColumn();
        if (calcColumn == null) {
            return;
        }
        String[] calcTitle = calcColumn.getCalcTitle();
        if (calcTitle != null && calcTitle.length > 0) {
            this.tr(1).close();
            this.td(2).styleClass(TABLE_TOTAL_TITLE).colSpan("" + model.getColumnHandler().columnCount()).close();
            for (int i = 0; i < calcTitle.length; ++i) {
                String title = calcTitle[i];
                this.append(title);
            }
            this.tdEnd();
            this.trEnd(1);
        }
        this.tr(1).close();
        Iterator iter = model.getColumnHandler().getColumns().iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (column.isCalculated()) {
                this.td(2).styleClass(TABLE_TOTALS).close();
                CalcResult[] calcValues = model.getColumnHandler().getCalcResults(column);
                for (int i = 0; i < calcValues.length; ++i) {
                    CalcResult calcValue = calcValues[i];
                    Number value = calcValue.getValue();
                    this.append(ExtremeUtils.formatNumber(column.getFormat(), value, model.getLocale()));
                    if (calcValues.length <= 0 || i + 1 == calcValues.length) continue;
                    this.append(" / ");
                }
            } else {
                this.td(2).styleClass(TABLE_TOTALS_EMPTY).close();
                this.nbsp();
            }
            this.tdEnd();
        }
        this.trEnd(1);
    }
}

