/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view;

import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.bean.Export;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.ExportViewUtils;
import org.extremecomponents.table.view.View;

public class CsvView
implements View {
    public static final String DELIMITER = "delimiter";
    static final String DEFAULT_DELIMITER = ",";
    private StringBuffer plainData = new StringBuffer();

    public void beforeBody(TableModel model) {
    }

    public void body(TableModel model, Column column) {
        Export export = model.getExportHandler().getCurrentExport();
        String delimiter = export.getAttributeAsString(DELIMITER);
        if (StringUtils.isBlank((String)delimiter)) {
            delimiter = DEFAULT_DELIMITER;
        }
        String value = ExportViewUtils.parseCSV(column.getCellDisplay());
        this.plainData.append(value.trim());
        this.plainData.append(delimiter);
        if (column.isLastColumn()) {
            this.plainData.append("\r\n");
        }
    }

    public Object afterBody(TableModel model) {
        return this.plainData.toString();
    }
}

