/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.resource;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.core.Messages;
import org.extremecomponents.table.core.TableModelUtils;

public class TableResourceBundle
implements Messages {
    private static Log logger = LogFactory.getLog((Class)(class$org$extremecomponents$table$resource$TableResourceBundle == null ? (class$org$extremecomponents$table$resource$TableResourceBundle = TableResourceBundle.class$("org.extremecomponents.table.resource.TableResourceBundle")) : class$org$extremecomponents$table$resource$TableResourceBundle));
    public static final String EXTREMETABLE_RESOURCE_BUNDLE = "org.extremecomponents.table.resource.extremetableResourceBundle";
    private ResourceBundle customResourceBundle;
    private ResourceBundle defaultResourceBundle;
    private Locale locale;
    static /* synthetic */ Class class$org$extremecomponents$table$resource$TableResourceBundle;

    public void init(Context context, Locale locale) {
        this.locale = locale;
        this.defaultResourceBundle = this.findResourceBundle(EXTREMETABLE_RESOURCE_BUNDLE, locale);
        String messagesLocation = TableModelUtils.getMessagesLocation(context);
        if (StringUtils.isNotBlank((String)messagesLocation)) {
            this.customResourceBundle = this.findResourceBundle(messagesLocation, locale);
        }
    }

    private ResourceBundle findResourceBundle(String resourceBundleLocation, Locale locale) {
        try {
            return ResourceBundle.getBundle(resourceBundleLocation, locale, this.getClass().getClassLoader());
        }
        catch (MissingResourceException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("The resource bundle [ " + resourceBundleLocation + "] was not found. Make sure the path and resource name is correct."), (Throwable)e);
            }
            return null;
        }
    }

    public String getMessage(String code) {
        return this.getMessage(code, null);
    }

    public String getMessage(String code, Object[] args) {
        String result = this.findResource(this.customResourceBundle, code);
        if (result == null) {
            result = this.findResource(this.defaultResourceBundle, code);
        }
        if (result != null && args != null) {
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(this.locale);
            formatter.applyPattern(result);
            result = formatter.format(args);
        }
        return result;
    }

    private String findResource(ResourceBundle resourceBundle, String code) {
        String result = null;
        if (resourceBundle == null) {
            return result;
        }
        try {
            result = resourceBundle.getString(code);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

