/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.limit;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.extremecomponents.table.limit.Filter;

public class FilterSet {
    private String action;
    private Filter[] filters;

    public FilterSet() {
    }

    public FilterSet(String action, Filter[] filters) {
        this.action = action;
        this.filters = filters;
    }

    public boolean isFiltered() {
        return this.action != null && this.action.equals("fa") && this.filters != null && this.filters.length > 0;
    }

    public boolean isCleared() {
        return this.action != null && this.action.equals("ca");
    }

    public String getAction() {
        return this.action;
    }

    public Filter[] getFilters() {
        return this.filters;
    }

    public String getFilterValue(String alias) {
        for (int i = 0; i < this.filters.length; ++i) {
            Filter filter = this.filters[i];
            if (!filter.getAlias().equals(alias)) continue;
            return filter.getValue();
        }
        return "";
    }

    public Filter getFilter(String alias) {
        for (int i = 0; i < this.filters.length; ++i) {
            Filter filter = this.filters[i];
            if (!filter.getAlias().equals(alias)) continue;
            return filter;
        }
        return null;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("action", (Object)this.action);
        if (this.filters != null) {
            for (int i = 0; i < this.filters.length; ++i) {
                Filter filter = this.filters[i];
                builder.append((Object)filter.toString());
            }
        }
        return builder.toString();
    }
}

