/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.bean.Row;
import org.extremecomponents.table.core.TableCache;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;

public class RowHandler {
    private static Log logger = LogFactory.getLog((Class)(class$org$extremecomponents$table$handler$RowHandler == null ? (class$org$extremecomponents$table$handler$RowHandler = RowHandler.class$("org.extremecomponents.table.handler.RowHandler")) : class$org$extremecomponents$table$handler$RowHandler));
    private TableModel model;
    private Row row;
    static /* synthetic */ Class class$org$extremecomponents$table$handler$RowHandler;

    public RowHandler(TableModel model) {
        this.model = model;
    }

    public TableModel getModel() {
        return this.model;
    }

    public Row getRow() {
        return this.row;
    }

    public void addRow(Row row) {
        this.row = row;
        this.addRowAttributes();
        row.defaults();
    }

    public void addRowAttributes() {
        String interceptor = TableModelUtils.getInterceptPreference(this.model, this.row.getInterceptor(), "row.interceptor.");
        this.row.setInterceptor(interceptor);
        TableCache.getInstance().getRowInterceptor(interceptor).addRowAttributes(this.model, this.row);
    }

    public void modifyRowAttributes() {
        TableCache.getInstance().getRowInterceptor(this.row.getInterceptor()).modifyRowAttributes(this.model, this.row);
    }

    public boolean isRowEven() {
        return this.row.getRowCount() != 0 && this.row.getRowCount() % 2 == 0;
    }

    public boolean isRowOdd() {
        return this.row.getRowCount() == 0 || this.row.getRowCount() % 2 != 0;
    }

    public int increaseRowCount() {
        if (this.row == null) {
            String msg = "There is no row defined. The row (Row or RowTag) is now required and needs to be put around the columns.";
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        this.row.setRowCount(this.row.getRowCount() + 1);
        return this.row.getRowCount();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

