/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.calc.Calc;
import org.extremecomponents.table.callback.FilterRowsCallback;
import org.extremecomponents.table.callback.RetrieveRowsCallback;
import org.extremecomponents.table.callback.SortRowsCallback;
import org.extremecomponents.table.cell.Cell;
import org.extremecomponents.table.core.AutoGenerateColumns;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.interceptor.ColumnInterceptor;
import org.extremecomponents.table.interceptor.ExportInterceptor;
import org.extremecomponents.table.interceptor.RowInterceptor;
import org.extremecomponents.table.interceptor.TableInterceptor;
import org.extremecomponents.table.state.State;

public class TableCache {
    private static Log logger = LogFactory.getLog((Class)(class$org$extremecomponents$table$core$TableCache == null ? (class$org$extremecomponents$table$core$TableCache = TableCache.class$("org.extremecomponents.table.core.TableCache")) : class$org$extremecomponents$table$core$TableCache));
    public static TableCache tableCache = new TableCache();
    private Map cache = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$extremecomponents$table$core$TableCache;

    private TableCache() {
    }

    public static TableCache getInstance() {
        return tableCache;
    }

    private Object getCachedObject(String className) {
        Object cachedObject = null;
        try {
            Class<?> classForName = Class.forName(className);
            cachedObject = this.cache.get(classForName);
            if (cachedObject == null) {
                cachedObject = classForName.newInstance();
                this.cache.put(classForName, cachedObject);
            }
        }
        catch (Exception e) {
            String msg = "Could not create the object [" + className + "]. The class was not found or does not exist.";
            logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
        return cachedObject;
    }

    public Cell getCell(String cell) {
        return (Cell)this.getCachedObject(cell);
    }

    public State getState(String state) {
        return (State)this.getCachedObject(state);
    }

    public RetrieveRowsCallback getRetrieveRowsCallback(TableModel model) {
        String retrieveRowsCallback = model.getTableHandler().getTable().getRetrieveRowsCallback();
        return (RetrieveRowsCallback)this.getCachedObject(retrieveRowsCallback);
    }

    public FilterRowsCallback getFilterRowsCallback(TableModel model) {
        String filterRowsCallback = model.getTableHandler().getTable().getFilterRowsCallback();
        return (FilterRowsCallback)this.getCachedObject(filterRowsCallback);
    }

    public SortRowsCallback getSortRowsCallback(TableModel model) {
        String sortRowsCallback = model.getTableHandler().getTable().getSortRowsCallback();
        return (SortRowsCallback)this.getCachedObject(sortRowsCallback);
    }

    public Calc getCalc(String calc) {
        return (Calc)this.getCachedObject(calc);
    }

    public TableInterceptor getTableInterceptor(String tableInterceptor) {
        return (TableInterceptor)this.getCachedObject(tableInterceptor);
    }

    public RowInterceptor getRowInterceptor(String rowInterceptor) {
        return (RowInterceptor)this.getCachedObject(rowInterceptor);
    }

    public ColumnInterceptor getColumnInterceptor(String columnInterceptor) {
        return (ColumnInterceptor)this.getCachedObject(columnInterceptor);
    }

    public ExportInterceptor getExportInterceptor(String exportInterceptor) {
        return (ExportInterceptor)this.getCachedObject(exportInterceptor);
    }

    public AutoGenerateColumns getAutoGenerateColumns(String autoGenerateColumns) {
        return (AutoGenerateColumns)this.getCachedObject(autoGenerateColumns);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

