/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.cell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.cell.Cell;
import org.extremecomponents.table.cell.FilterOption;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.html.TableActions;
import org.extremecomponents.util.ExtremeUtils;
import org.extremecomponents.util.HtmlBuilder;

public class FilterDroplistCell
implements Cell {
    private static Log logger = LogFactory.getLog((Class)(class$org$extremecomponents$table$cell$FilterDroplistCell == null ? (class$org$extremecomponents$table$cell$FilterDroplistCell = FilterDroplistCell.class$("org.extremecomponents.table.cell.FilterDroplistCell")) : class$org$extremecomponents$table$cell$FilterDroplistCell));
    static /* synthetic */ Class class$org$extremecomponents$table$cell$FilterDroplistCell;

    public String getExportDisplay(TableModel model, Column column) {
        return null;
    }

    public String getHtmlDisplay(TableModel model, Column column) {
        HtmlBuilder html = new HtmlBuilder();
        if (!column.isFilterable()) {
            html.append("");
        } else {
            Collection filterOptions = column.getFilterOptions();
            if (filterOptions == null || filterOptions.isEmpty()) {
                filterOptions = this.getFilterDropList(model, column);
            }
            html.append(this.dropListHtml(model, column, filterOptions));
        }
        return html.toString();
    }

    protected Collection getFilterDropList(TableModel model, Column column) {
        ArrayList<Option> droplist = new ArrayList<Option>();
        HashSet<Object> options = new HashSet<Object>();
        Collection beans = model.getCollectionOfBeans();
        Iterator iter = beans.iterator();
        while (iter.hasNext()) {
            Object bean = iter.next();
            try {
                Object obj = this.getFilterOption(column, bean);
                if (obj == null || options.contains(obj)) continue;
                droplist.add(new Option(obj));
                options.add(obj);
            }
            catch (Exception e) {
                logger.debug((Object)"Problems getting the droplist.", (Throwable)e);
            }
        }
        BeanComparator comparator = new BeanComparator("label", (Comparator)new NullComparator());
        Collections.sort(droplist, comparator);
        return droplist;
    }

    protected Object getFilterOption(Column column, Object bean) throws Exception {
        return PropertyUtils.getProperty((Object)bean, (String)column.getProperty());
    }

    protected String dropListHtml(TableModel model, Column column, Collection droplist) {
        HtmlBuilder html = new HtmlBuilder();
        html.td(2).close();
        html.newline();
        html.tabs(2);
        html.select().name(model.getTableHandler().prefixWithTableId() + "f_" + column.getAlias());
        StringBuffer onkeypress = new StringBuffer();
        onkeypress.append(new TableActions(model).getFilterAction());
        html.onchange(onkeypress.toString());
        html.close();
        html.newline();
        html.tabs(2);
        html.option().value("").close();
        html.optionEnd();
        Locale locale = model.getLocale();
        Iterator iter = droplist.iterator();
        while (iter.hasNext()) {
            FilterOption filterOption = (FilterOption)iter.next();
            String value = String.valueOf(filterOption.getValue());
            String label = String.valueOf(filterOption.getLabel());
            if (column.isDate()) {
                value = ExtremeUtils.formatDate(column.getParse(), column.getFormat(), filterOption.getValue(), locale);
            }
            html.newline();
            html.tabs(2);
            html.option().value(value);
            if (value.equals(column.getValueAsString())) {
                html.selected();
            }
            html.close();
            html.append(label);
            html.optionEnd();
        }
        html.newline();
        html.tabs(2);
        html.selectEnd();
        html.tdEnd();
        return html.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class Option
    implements FilterOption {
        private final Object label;
        private final Object value;

        public Option(Object obj) {
            this.label = obj;
            this.value = obj;
        }

        public Option(Object label, Object value) {
            this.label = label;
            this.value = value;
        }

        public Object getLabel() {
            return this.label;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

