/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.callback;

import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.util.ExtremeUtils;

public final class FilterPredicate
implements Predicate {
    private static Log logger = LogFactory.getLog((Class)(class$org$extremecomponents$table$callback$FilterPredicate == null ? (class$org$extremecomponents$table$callback$FilterPredicate = FilterPredicate.class$("org.extremecomponents.table.callback.FilterPredicate")) : class$org$extremecomponents$table$callback$FilterPredicate));
    private TableModel model;
    static /* synthetic */ Class class$org$extremecomponents$table$callback$FilterPredicate;

    public FilterPredicate(TableModel model) {
        this.model = model;
    }

    public boolean evaluate(Object bean) {
        boolean match = false;
        try {
            Iterator iter = this.model.getColumnHandler().getColumns().iterator();
            while (iter.hasNext()) {
                Locale locale;
                String property;
                Object value;
                Column column = (Column)iter.next();
                String alias = column.getAlias();
                String filterValue = this.model.getLimit().getFilterSet().getFilterValue(alias);
                if (StringUtils.isEmpty((String)filterValue) || (value = PropertyUtils.getProperty((Object)bean, (String)(property = column.getProperty()))) == null) continue;
                if (column.isDate()) {
                    locale = this.model.getLocale();
                    value = ExtremeUtils.formatDate(column.getParse(), column.getFormat(), value, locale);
                } else if (column.isCurrency()) {
                    locale = this.model.getLocale();
                    value = ExtremeUtils.formatNumber(column.getFormat(), value, locale);
                }
                if (!this.isSearchMatch(value.toString(), filterValue)) {
                    match = false;
                    break;
                }
                match = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"FilterPredicate.evaluate() had problems", (Throwable)e);
        }
        return match;
    }

    private boolean isSearchMatch(String value, String search) {
        value = value.toLowerCase().trim();
        if ((search = search.toLowerCase().trim()).startsWith("*") && value.endsWith(StringUtils.replace((String)search, (String)"*", (String)""))) {
            return true;
        }
        if (search.endsWith("*") && value.startsWith(StringUtils.replace((String)search, (String)"*", (String)""))) {
            return true;
        }
        return StringUtils.contains((String)value, (String)search);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

