/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.bean;

import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;

final class ExportDefaults {
    ExportDefaults() {
    }

    static String getEncoding(TableModel model, String encoding) {
        if (StringUtils.isBlank((String)encoding)) {
            return model.getPreferences().getPreference("export.encoding");
        }
        return encoding;
    }

    static String getText(TableModel model, String text) {
        String resourceValue;
        if (TableModelUtils.isResourceBundleProperty(text) && (resourceValue = model.getMessages().getMessage(text)) != null) {
            return resourceValue;
        }
        return text;
    }

    static String getTooltip(TableModel model, String tooltip) {
        String resourceValue;
        if (TableModelUtils.isResourceBundleProperty(tooltip) && (resourceValue = model.getMessages().getMessage(tooltip)) != null) {
            return resourceValue;
        }
        return tooltip;
    }

    static String getviewResolver(TableModel model, String viewResolver) {
        String result = null;
        if (StringUtils.isNotBlank((String)viewResolver) && StringUtils.isBlank((String)(result = model.getPreferences().getPreference("export.viewResolver." + viewResolver)))) {
            result = viewResolver;
        }
        return result;
    }
}

