/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.requisition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"m_interfaces", "m_categories", "m_assets"})
@XmlRootElement(name="node")
public class RequisitionNode {
    @XmlElement(name="interface")
    protected List<RequisitionInterface> m_interfaces = new ArrayList<RequisitionInterface>();
    @XmlElement(name="category")
    protected List<RequisitionCategory> m_categories = new ArrayList<RequisitionCategory>();
    @XmlElement(name="asset")
    protected List<RequisitionAsset> m_assets = new ArrayList<RequisitionAsset>();
    @XmlAttribute
    protected String building;
    @XmlAttribute
    protected String city;
    @XmlAttribute(name="foreign-id", required=true)
    protected String foreignId;
    @XmlAttribute(name="node-label", required=true)
    protected String nodeLabel;
    @XmlAttribute(name="parent-foreign-id")
    protected String parentForeignId;
    @XmlAttribute(name="parent-node-label")
    protected String parentNodeLabel;

    @XmlTransient
    public int getInterfaceCount() {
        return this.m_interfaces == null ? 0 : this.m_interfaces.size();
    }

    @XmlTransient
    public RequisitionInterface[] getInterface() {
        return this.getInterfaces().toArray(new RequisitionInterface[0]);
    }

    public List<RequisitionInterface> getInterfaces() {
        if (this.m_interfaces == null) {
            this.m_interfaces = new ArrayList<RequisitionInterface>();
        }
        return this.m_interfaces;
    }

    public void setInterfaces(List<RequisitionInterface> interfaces) {
        this.m_interfaces = interfaces;
    }

    public RequisitionInterface getInterface(String ipAddress) {
        if (this.m_interfaces != null) {
            for (RequisitionInterface iface : this.m_interfaces) {
                if (!iface.getIpAddr().equals(ipAddress)) continue;
                return iface;
            }
        }
        return null;
    }

    public void removeInterface(RequisitionInterface iface) {
        if (this.m_interfaces != null) {
            Iterator<RequisitionInterface> i = this.m_interfaces.iterator();
            while (i.hasNext()) {
                RequisitionInterface ri = i.next();
                if (!ri.getIpAddr().equals(iface.getIpAddr())) continue;
                i.remove();
                break;
            }
        }
    }

    public void deleteInterface(String ipAddress) {
        if (this.m_interfaces != null) {
            Iterator<RequisitionInterface> i = this.m_interfaces.iterator();
            while (i.hasNext()) {
                RequisitionInterface iface = i.next();
                if (!iface.getIpAddr().equals(ipAddress)) continue;
                i.remove();
                break;
            }
        }
    }

    public void insertInterface(RequisitionInterface iface) {
        Iterator<RequisitionInterface> iterator = this.m_interfaces.iterator();
        while (iterator.hasNext()) {
            RequisitionInterface existingIface = iterator.next();
            if (!existingIface.getIpAddr().equals(iface.getIpAddr())) continue;
            iterator.remove();
        }
        this.m_interfaces.add(0, iface);
    }

    public void putInterface(RequisitionInterface iface) {
        Iterator<RequisitionInterface> iterator = this.m_interfaces.iterator();
        while (iterator.hasNext()) {
            RequisitionInterface existingIface = iterator.next();
            if (!existingIface.getIpAddr().equals(iface.getIpAddr())) continue;
            iterator.remove();
        }
        this.m_interfaces.add(iface);
    }

    @XmlTransient
    public int getCategoryCount() {
        return this.m_categories == null ? 0 : this.m_categories.size();
    }

    @XmlTransient
    public RequisitionCategory[] getCategory() {
        return this.m_categories.toArray(new RequisitionCategory[0]);
    }

    public List<RequisitionCategory> getCategories() {
        if (this.m_categories == null) {
            this.m_categories = new ArrayList<RequisitionCategory>();
        }
        return this.m_categories;
    }

    public void setCategories(List<RequisitionCategory> categories) {
        this.m_categories = categories;
    }

    public RequisitionCategory getCategory(String category) {
        if (this.m_categories != null) {
            for (RequisitionCategory cat : this.m_categories) {
                if (!cat.getName().equals(category)) continue;
                return cat;
            }
        }
        return null;
    }

    public void removeCategory(RequisitionCategory cat) {
        if (this.m_assets != null) {
            Iterator<RequisitionCategory> i = this.m_categories.iterator();
            while (i.hasNext()) {
                RequisitionCategory a = i.next();
                if (!a.getName().equals(cat.getName())) continue;
                i.remove();
                break;
            }
        }
    }

    public void deleteCategory(RequisitionCategory category) {
        if (this.m_categories != null) {
            Iterator<RequisitionCategory> i = this.m_categories.iterator();
            while (i.hasNext()) {
                RequisitionCategory cat = i.next();
                if (!cat.getName().equals(category.getName())) continue;
                i.remove();
                break;
            }
        }
    }

    public void deleteCategory(String category) {
        if (this.m_categories != null) {
            Iterator<RequisitionCategory> i = this.m_categories.iterator();
            while (i.hasNext()) {
                RequisitionCategory cat = i.next();
                if (!cat.getName().equals(category)) continue;
                i.remove();
                break;
            }
        }
    }

    public void insertCategory(RequisitionCategory category) {
        Iterator<RequisitionCategory> iterator = this.m_categories.iterator();
        while (iterator.hasNext()) {
            RequisitionCategory existing = iterator.next();
            if (!existing.getName().equals(category.getName())) continue;
            iterator.remove();
        }
        this.m_categories.add(0, category);
    }

    public void putCategory(RequisitionCategory category) {
        Iterator<RequisitionCategory> iterator = this.m_categories.iterator();
        while (iterator.hasNext()) {
            RequisitionCategory existing = iterator.next();
            if (!existing.getName().equals(category.getName())) continue;
            iterator.remove();
        }
        this.m_categories.add(category);
    }

    @XmlTransient
    public int getAssetCount() {
        return this.m_assets == null ? 0 : this.m_assets.size();
    }

    @XmlTransient
    public RequisitionAsset[] getAsset() {
        return this.m_assets.toArray(new RequisitionAsset[0]);
    }

    public List<RequisitionAsset> getAssets() {
        if (this.m_assets == null) {
            this.m_assets = new ArrayList<RequisitionAsset>();
        }
        return this.m_assets;
    }

    public void setAssets(List<RequisitionAsset> assets) {
        this.m_assets = assets;
    }

    public RequisitionAsset getAsset(String name) {
        if (this.m_assets != null) {
            for (RequisitionAsset asset : this.m_assets) {
                if (!asset.getName().equals(name)) continue;
                return asset;
            }
        }
        return null;
    }

    public void removeAsset(RequisitionAsset asset) {
        if (this.m_assets != null) {
            Iterator<RequisitionAsset> i = this.m_assets.iterator();
            while (i.hasNext()) {
                RequisitionAsset a = i.next();
                if (!a.getName().equals(asset.getName())) continue;
                i.remove();
                break;
            }
        }
    }

    public void deleteAsset(String name) {
        if (this.m_assets != null) {
            Iterator<RequisitionAsset> i = this.m_assets.iterator();
            while (i.hasNext()) {
                RequisitionAsset asset = i.next();
                if (!asset.getName().equals(name)) continue;
                i.remove();
                break;
            }
        }
    }

    public void insertAsset(RequisitionAsset asset) {
        Iterator<RequisitionAsset> iterator = this.m_assets.iterator();
        while (iterator.hasNext()) {
            RequisitionAsset existing = iterator.next();
            if (!existing.getName().equals(asset.getName())) continue;
            iterator.remove();
        }
        this.m_assets.add(0, asset);
    }

    public void putAsset(RequisitionAsset asset) {
        Iterator<RequisitionAsset> iterator = this.m_assets.iterator();
        while (iterator.hasNext()) {
            RequisitionAsset existing = iterator.next();
            if (!existing.getName().equals(asset.getName())) continue;
            iterator.remove();
        }
        this.m_assets.add(asset);
    }

    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String value) {
        this.building = value;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String value) {
        this.city = value;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public void setForeignId(String value) {
        this.foreignId = value;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public void setNodeLabel(String value) {
        this.nodeLabel = value;
    }

    public String getParentForeignId() {
        return this.parentForeignId;
    }

    public void setParentForeignId(String value) {
        this.parentForeignId = value;
    }

    public String getParentNodeLabel() {
        return this.parentNodeLabel;
    }

    public void setParentNodeLabel(String value) {
        this.parentNodeLabel = value;
    }
}

