/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.requisition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="model-import")
public class Requisition
implements Serializable,
Comparable<Requisition> {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private Map<String, OnmsNodeRequisition> m_nodeReqs = new LinkedHashMap<String, OnmsNodeRequisition>();
    @XmlElement(name="node")
    protected List<RequisitionNode> m_nodes = new ArrayList<RequisitionNode>();
    @XmlAttribute(name="date-stamp")
    protected XMLGregorianCalendar m_dateStamp;
    @XmlAttribute(name="foreign-source")
    protected String m_foreignSource = "imported:";
    @XmlAttribute(name="last-import")
    protected XMLGregorianCalendar m_lastImport;

    public RequisitionNode getNode(String foreignId) {
        if (this.m_nodes != null) {
            for (RequisitionNode n : this.m_nodes) {
                if (!n.getForeignId().equals(foreignId)) continue;
                if (this.log().isDebugEnabled()) {
                    this.log().debug(String.format("returning node '%s' for foreign id '%s'", n, foreignId));
                }
                return n;
            }
        }
        return null;
    }

    public void removeNode(RequisitionNode node) {
        if (this.m_nodes != null) {
            Iterator<RequisitionNode> i = this.m_nodes.iterator();
            while (i.hasNext()) {
                RequisitionNode n = i.next();
                if (!n.getForeignId().equals(node.getForeignId())) continue;
                i.remove();
                break;
            }
        }
    }

    public void deleteNode(String foreignId) {
        if (this.m_nodes != null) {
            Iterator<RequisitionNode> i = this.m_nodes.iterator();
            while (i.hasNext()) {
                RequisitionNode n = i.next();
                if (!n.getForeignId().equals(foreignId)) continue;
                i.remove();
                break;
            }
        }
    }

    @XmlTransient
    public RequisitionNode[] getNode() {
        return this.getNodes().toArray(new RequisitionNode[0]);
    }

    public List<RequisitionNode> getNodes() {
        return this.m_nodes;
    }

    public void setNodes(List<RequisitionNode> nodes) {
        this.m_nodes = nodes;
        this.updateNodeCache();
    }

    public void insertNode(RequisitionNode node) {
        if (this.m_nodeReqs.containsKey(node.getForeignId())) {
            RequisitionNode n = this.m_nodeReqs.get(node.getForeignId()).getNode();
            this.m_nodes.remove(n);
        }
        this.m_nodes.add(0, node);
        this.m_nodeReqs.put(node.getForeignId(), new OnmsNodeRequisition(this.getForeignSource(), node));
    }

    public void putNode(RequisitionNode node) {
        if (this.m_nodeReqs.containsKey(node.getForeignId())) {
            RequisitionNode n = this.m_nodeReqs.get(node.getForeignId()).getNode();
            this.m_nodes.remove(n);
        }
        this.m_nodes.add(node);
        this.m_nodeReqs.put(node.getForeignId(), new OnmsNodeRequisition(this.getForeignSource(), node));
    }

    public XMLGregorianCalendar getDateStamp() {
        return this.m_dateStamp;
    }

    public void setDateStamp(XMLGregorianCalendar value) {
        this.m_dateStamp = value;
    }

    public void updateDateStamp() {
        try {
            this.m_dateStamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            this.log().warn("unable to update datestamp", (Throwable)e);
        }
    }

    public String getForeignSource() {
        if (this.m_foreignSource == null) {
            return "imported:";
        }
        return this.m_foreignSource;
    }

    public void setForeignSource(String value) {
        this.m_foreignSource = value;
    }

    public XMLGregorianCalendar getLastImport() {
        return this.m_lastImport;
    }

    public void setLastImport(XMLGregorianCalendar value) {
        this.m_lastImport = value;
    }

    public void updateLastImported() {
        try {
            this.m_lastImport = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            this.log().warn("unable to update last import datestamp", (Throwable)e);
        }
    }

    public Requisition() {
        this.updateNodeCache();
        this.updateDateStamp();
    }

    public Requisition(String foreignSource) {
        this();
        this.m_foreignSource = foreignSource;
    }

    private void updateNodeCache() {
        this.m_nodeReqs.clear();
        if (this.m_nodes != null) {
            for (RequisitionNode n : this.m_nodes) {
                this.m_nodeReqs.put(n.getForeignId(), new OnmsNodeRequisition(this.getForeignSource(), n));
            }
        }
    }

    public void visit(RequisitionVisitor visitor) {
        if (this.m_nodeReqs.size() == 0 && this.m_nodes != null && this.m_nodes.size() > 0) {
            this.updateNodeCache();
        }
        if (visitor == null) {
            this.log().warn("no visitor specified!");
            return;
        }
        visitor.visitModelImport(this);
        for (OnmsNodeRequisition nodeReq : this.m_nodeReqs.values()) {
            nodeReq.visit(visitor);
        }
        visitor.completeModelImport(this);
    }

    public OnmsNodeRequisition getNodeRequistion(String foreignId) {
        if (this.m_nodeReqs.size() == 0 && this.m_nodes != null && this.m_nodes.size() > 0) {
            this.updateNodeCache();
        }
        return this.m_nodeReqs.get(foreignId);
    }

    @XmlTransient
    public int getNodeCount() {
        return this.m_nodes == null ? 0 : this.m_nodes.size();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(Requisition.class);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("foreign-source", (Object)this.getForeignSource()).append("date-stamp", (Object)this.getDateStamp()).append("last-import", (Object)this.getLastImport()).append("nodes", this.getNodes()).toString();
    }

    @Override
    public int compareTo(Requisition obj) {
        return new CompareToBuilder().append((Object)this.getForeignSource(), (Object)obj.getForeignSource()).append((Object)this.getDateStamp(), (Object)obj.getDateStamp()).append((Object)this.getLastImport(), (Object)obj.getLastImport()).append(this.getNodes(), obj.getNodes()).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Requisition) {
            Requisition other = (Requisition)obj;
            return new EqualsBuilder().append((Object)this.getForeignSource(), (Object)other.getForeignSource()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(37, 29).append((Object)this.getForeignSource()).append((Object)this.getDateStamp()).append((Object)this.getLastImport()).append(this.getNodes()).toHashCode();
    }
}

