/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.provision.BasePolicy;
import org.opennms.netmgt.provision.SnmpInterfacePolicy;
import org.opennms.netmgt.provision.annotations.Policy;
import org.opennms.netmgt.provision.annotations.Require;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
@Policy(value="Match SNMP Interface")
public class MatchingSnmpInterfacePolicy
extends BasePolicy<OnmsSnmpInterface>
implements SnmpInterfacePolicy {
    private Action m_action = Action.DO_NOT_PERSIST;

    @Require(value={"ENABLE_COLLECTION", "DISABLE_COLLECTION", "DO_NOT_PERSIST"})
    public String getAction() {
        return this.m_action.toString();
    }

    public void setAction(String action) {
        this.m_action = action != null && action.toUpperCase().contains("ENABLE") ? Action.ENABLE_COLLECTION : (action != null && action.toUpperCase().contains("DISABLE") ? Action.DISABLE_COLLECTION : Action.DO_NOT_PERSIST);
    }

    public OnmsSnmpInterface act(OnmsSnmpInterface iface) {
        switch (this.m_action) {
            case DO_NOT_PERSIST: {
                this.info("NOT Peristing %s according to policy", new Object[]{iface});
                return null;
            }
            case DISABLE_COLLECTION: {
                iface.setCollectionEnabled(false);
                this.info("Disabled collection for %s according to policy", new Object[]{iface});
                return iface;
            }
            case ENABLE_COLLECTION: {
                iface.setCollectionEnabled(true);
                this.info("Enabled collection for %s according to policy", new Object[]{iface});
                return iface;
            }
        }
        return iface;
    }

    public String getIfDescr() {
        return this.getCriteria("ifDescr");
    }

    public void setIfDescr(String ifDescr) {
        this.putCriteria("ifDescr", ifDescr);
    }

    public String getIfName() {
        return this.getCriteria("ifName");
    }

    public void setIfName(String ifName) {
        this.putCriteria("ifName", ifName);
    }

    public String getIfType() {
        return this.getCriteria("ifType");
    }

    public void setIfType(String ifType) {
        this.putCriteria("ifType", ifType);
    }

    public String getIpAddress() {
        return this.getCriteria("ipAddress");
    }

    public void setIpAddress(String ipAddress) {
        this.putCriteria("ipAddress", ipAddress);
    }

    public String getNetmask() {
        return this.getCriteria("netmask");
    }

    public void setNetmask(String netmask) {
        this.putCriteria("netmask", netmask);
    }

    public String getPhysAddr() {
        return this.getCriteria("physAddr");
    }

    public void setPhysAddr(String physAddr) {
        this.putCriteria("physAddr", physAddr);
    }

    public String getIfIndex() {
        return this.getCriteria("ifIndex");
    }

    public void setIfIndex(String ifIndex) {
        this.putCriteria("ifIndex", ifIndex);
    }

    public String getIfSpeed() {
        return this.getCriteria("ifSpeed");
    }

    public void setIfSpeed(String ifSpeed) {
        this.putCriteria("ifSpeed", ifSpeed);
    }

    public String getIfAdminStatus() {
        return this.getCriteria("ifAdminStatus");
    }

    public void setIfAdminStatus(String ifAdminStatus) {
        this.putCriteria("ifAdminStatus", ifAdminStatus);
    }

    public String getIfOperStatus() {
        return this.getCriteria("ifOperStatus");
    }

    public void setIfOperStatus(String ifOperStatus) {
        this.putCriteria("ifOperStatus", ifOperStatus);
    }

    public String getIfAlias() {
        return this.getCriteria("ifAlias");
    }

    public void setIfAlias(String ifAlias) {
        this.putCriteria("ifAlias", ifAlias);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        ENABLE_COLLECTION,
        DISABLE_COLLECTION,
        DO_NOT_PERSIST;

    }
}

