/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.provision.BasePolicy;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.annotations.Policy;
import org.opennms.netmgt.provision.annotations.Require;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
@Policy(value="Match IP Interface")
public class MatchingIpInterfacePolicy
extends BasePolicy<OnmsIpInterface>
implements IpInterfacePolicy {
    private Action m_action = Action.DO_NOT_PERSIST;

    @Require(value={"MANAGE", "UNMANAGE", "DO_NOT_PERSIST"})
    public String getAction() {
        return this.m_action.toString();
    }

    public void setAction(String action) {
        this.m_action = Action.MANAGE.toString().equalsIgnoreCase(action) ? Action.MANAGE : (Action.UNMANAGE.toString().equalsIgnoreCase(action) ? Action.UNMANAGE : Action.DO_NOT_PERSIST);
    }

    public OnmsIpInterface act(OnmsIpInterface iface) {
        switch (this.m_action) {
            case DO_NOT_PERSIST: {
                this.info("NOT Peristing %s according to policy", new Object[]{iface});
                return null;
            }
            case MANAGE: {
                this.info("Managing %s according to policy", new Object[]{iface});
                iface.setIsManaged("M");
                return iface;
            }
            case UNMANAGE: {
                this.info("Unmanaging %s according to policy", new Object[]{iface});
                iface.setIsManaged("U");
                return iface;
            }
        }
        return iface;
    }

    public void setIpAddress(String ipAddress) {
        this.putCriteria("ipAddress", ipAddress);
    }

    public String getIpAddress() {
        return this.getCriteria("ipAddress");
    }

    public void setHostName(String hostName) {
        this.putCriteria("ipHostName", hostName);
    }

    public String getHostName() {
        return this.getCriteria("ipHostName");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        MANAGE,
        UNMANAGE,
        DO_NOT_PERSIST;

    }
}

