/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.foreignsource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.joda.time.Duration;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.persist.StringIntervalAdapter;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="foreign-source")
public class ForeignSource
implements Serializable,
Comparable<ForeignSource> {
    private static final PluginConfig[] OF_PLUGIN_CONFIGS = new PluginConfig[0];
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="date-stamp")
    protected XMLGregorianCalendar m_dateStamp;
    @XmlElement(name="scan-interval")
    @XmlJavaTypeAdapter(value=StringIntervalAdapter.class)
    private Duration m_scanInterval = Duration.standardDays((long)1L);
    @XmlElementWrapper(name="detectors")
    @XmlElement(name="detector")
    private List<PluginConfig> m_detectors = new ArrayList<PluginConfig>();
    @XmlElementWrapper(name="policies")
    @XmlElement(name="policy")
    private List<PluginConfig> m_policies = new ArrayList<PluginConfig>();
    private boolean m_default;

    public ForeignSource() {
        this.updateDateStamp();
    }

    public ForeignSource(String name) {
        this.updateDateStamp();
        this.setName(name);
    }

    @XmlTransient
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @XmlTransient
    public Duration getScanInterval() {
        return this.m_scanInterval;
    }

    public void setScanInterval(Duration scanInterval) {
        this.m_scanInterval = scanInterval;
    }

    @XmlTransient
    public XMLGregorianCalendar getDateStamp() {
        return this.m_dateStamp;
    }

    @XmlTransient
    public Date getDateStampAsDate() {
        return this.m_dateStamp.toGregorianCalendar().getTime();
    }

    public void setDateStamp(XMLGregorianCalendar value) {
        this.m_dateStamp = value;
    }

    public void updateDateStamp() {
        try {
            this.m_dateStamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            this.log().warn("unable to update datestamp", (Throwable)e);
        }
    }

    @XmlTransient
    public List<PluginConfig> getDetectors() {
        return this.m_detectors;
    }

    public void setDetectors(List<PluginConfig> detectors) {
        this.m_detectors = detectors;
    }

    @XmlTransient
    public List<PluginConfig> getPolicies() {
        return this.m_policies;
    }

    public void setPolicies(List<PluginConfig> policies) {
        this.m_policies = policies;
    }

    public void addDetector(PluginConfig detector) {
        this.m_detectors.add(detector);
    }

    public void addPolicy(PluginConfig policy) {
        this.m_policies.add(policy);
    }

    public PluginConfig getDetector(String detector) {
        for (PluginConfig pc : this.m_detectors) {
            if (!pc.getName().equals(detector)) continue;
            return pc;
        }
        return null;
    }

    public void removeDetectors(PluginConfig detector) {
        this.m_detectors.remove(detector);
    }

    public PluginConfig getPolicy(String policy) {
        for (PluginConfig pc : this.m_policies) {
            if (!pc.getName().equals(policy)) continue;
            return pc;
        }
        return null;
    }

    public void removePolicies(PluginConfig policy) {
        this.m_policies.remove(policy);
    }

    public boolean isDefault() {
        return this.m_default;
    }

    @XmlTransient
    public void setDefault(boolean isDefault) {
        this.m_default = isDefault;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(ForeignSource.class);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("scan-interval", (Object)this.getScanInterval()).append("detectors", (Object[])this.getDetectors().toArray(OF_PLUGIN_CONFIGS)).append("policies", (Object[])this.getPolicies().toArray(OF_PLUGIN_CONFIGS)).toString();
    }

    @Override
    public int compareTo(ForeignSource obj) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)obj.getName()).append((Object)this.getScanInterval(), (Object)obj.getScanInterval()).append((Object[])this.getDetectors().toArray(OF_PLUGIN_CONFIGS), (Object[])obj.getDetectors().toArray(OF_PLUGIN_CONFIGS)).append((Object[])this.getPolicies().toArray(OF_PLUGIN_CONFIGS), (Object[])obj.getPolicies().toArray(OF_PLUGIN_CONFIGS)).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ForeignSource) {
            ForeignSource other = (ForeignSource)obj;
            return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).append((Object)this.getScanInterval(), (Object)other.getScanInterval()).append((Object[])this.getDetectors().toArray(OF_PLUGIN_CONFIGS), (Object[])other.getDetectors().toArray(OF_PLUGIN_CONFIGS)).append((Object[])this.getPolicies().toArray(OF_PLUGIN_CONFIGS), (Object[])other.getPolicies().toArray(OF_PLUGIN_CONFIGS)).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(443, 1061).append((Object)this.getName()).append((Object)this.getScanInterval()).append((Object[])this.getDetectors().toArray(OF_PLUGIN_CONFIGS)).append((Object[])this.getPolicies().toArray(OF_PLUGIN_CONFIGS)).toHashCode();
    }
}

